/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.BaseByteArrayReader;
import com.centrus.geostan.BaseByteArrayWriter;
import com.centrus.geostan.ByteBufferUtil;
import com.centrus.geostan.GeoStanBase;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class NativeOutput {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    private static final int BASE_SIZE = 1000;
    private Map dataFields;
    private ByteBuffer dataBuf = ByteBuffer.allocateDirect(1000);
    private byte[] dataBytes;
    private Map inputDataFields;
    private ByteBuffer inputDataBuf = ByteBuffer.allocateDirect(1000);
    private byte[] inputDataBytes;
    private Map centerlineDataFields;
    private ByteBuffer centerlineDataBuf = ByteBuffer.allocateDirect(1000);
    private byte[] centerlineDataBytes;
    private Map multipleDataRecords = new HashMap();
    private ByteBuffer multipleDataBuf = ByteBuffer.allocateDirect(1000);
    private Map multipleDataBytes = new HashMap();

    NativeOutput() {
        this.init();
    }

    private void init() {
        this.dataFields = EMPTY_MAP;
        this.dataBytes = null;
        this.inputDataFields = EMPTY_MAP;
        this.inputDataBytes = null;
        this.centerlineDataFields = EMPTY_MAP;
        this.centerlineDataBytes = null;
        this.multipleDataRecords.clear();
        this.multipleDataBytes.clear();
    }

    void clear() {
        this.init();
    }

    private byte[] toDataBytes(int[] elements) {
        this.dataBytes = NativeOutput.toBytes(elements);
        return this.dataBytes;
    }

    private byte[] toInputDataBytes(int[] elements) {
        this.inputDataBytes = NativeOutput.toBytes(elements);
        return this.inputDataBytes;
    }

    private byte[] toCenterlineDataBytes(int[] elements) {
        this.centerlineDataBytes = NativeOutput.toBytes(elements);
        return this.centerlineDataBytes;
    }

    private byte[] toMultipleDataBytes(int[] elements, short index) {
        byte[] bytes = NativeOutput.toBytes(elements);
        this.multipleDataBytes.put(new Short(index), bytes);
        return bytes;
    }

    private static byte[] toBytes(int[] elements) {
        int count = elements.length;
        int bytesLength = 4 * count + 2;
        for (int i = 0; i < count; ++i) {
            bytesLength += GeoStanBase.getFieldLength(elements[i]);
        }
        BaseByteArrayWriter writer = BaseByteArrayWriter.newBaseByteArrayWriter(bytesLength);
        writer.writeBinaryShort((short)count);
        for (int i = 0; i < count; ++i) {
            writer.writeBinaryShort((short)elements[i]);
            short fieldLength = GeoStanBase.getFieldLength(elements[i]);
            writer.writeBinaryShort(fieldLength);
            writer.skip(fieldLength);
        }
        return writer.getBytes();
    }

    private static Map fromBytes(byte[] byteArray) {
        BaseByteArrayReader reader = BaseByteArrayReader.newBaseByteArrayReader(byteArray);
        int count = reader.readBinaryShort();
        HashMap<Short, String> fields = new HashMap<Short, String>(count);
        for (int i = 0; i < count; ++i) {
            Short fieldID = new Short(reader.readBinaryShort());
            short fieldLength = reader.readBinaryShort();
            String fieldValue = reader.readString(fieldLength, false);
            fields.put(fieldID, fieldValue);
        }
        return fields;
    }

    boolean containsDataField(short element) {
        return this.dataFields.containsKey(new Short(element));
    }

    boolean containsInputDataField(short element) {
        return this.inputDataFields.containsKey(new Short(element));
    }

    boolean containsCenterlineDataField(short element) {
        return this.centerlineDataFields.containsKey(new Short(element));
    }

    boolean containsMultipleDataField(short element, short index) {
        Map multipleDataFields = this.getMultipleDataFields(index);
        if (multipleDataFields == null) {
            return false;
        }
        return multipleDataFields.containsKey(new Short(element));
    }

    String getData(short element) {
        return ((String)this.dataFields.get(new Short(element))).trim();
    }

    String getInputData(short element) {
        return ((String)this.inputDataFields.get(new Short(element))).trim();
    }

    String getCenterlineData(short element) {
        return ((String)this.centerlineDataFields.get(new Short(element))).trim();
    }

    String getMultipleData(short element, short index) {
        Map multipleDataFields = this.getMultipleDataFields(index);
        if (multipleDataFields == null) {
            return null;
        }
        return ((String)multipleDataFields.get(new Short(element))).trim();
    }

    private Map getMultipleDataFields(short index) {
        Map fields = (Map)this.multipleDataRecords.get(new Short(index));
        return fields;
    }

    ByteBuffer getDataBuf(int[] elements) {
        this.toDataBytes(elements);
        this.dataBuf = NativeOutput.getBuf(this.dataBuf, this.dataBytes);
        return this.dataBuf;
    }

    ByteBuffer getInputDataBuf(int[] elements) {
        this.toInputDataBytes(elements);
        this.inputDataBuf = NativeOutput.getBuf(this.inputDataBuf, this.inputDataBytes);
        return this.inputDataBuf;
    }

    ByteBuffer getCenterlineDataBuf(int[] elements) {
        this.toCenterlineDataBytes(elements);
        this.centerlineDataBuf = NativeOutput.getBuf(this.centerlineDataBuf, this.centerlineDataBytes);
        return this.centerlineDataBuf;
    }

    ByteBuffer getMultipleDataBuf(int[] elements, short index) {
        byte[] bytes = this.toMultipleDataBytes(elements, index);
        this.multipleDataBuf = NativeOutput.getBuf(this.multipleDataBuf, bytes);
        return this.multipleDataBuf;
    }

    private static ByteBuffer getBuf(ByteBuffer buf, byte[] bytes) {
        int bytesLength = bytes.length;
        ByteBuffer tmpBuf = buf;
        int capacity = tmpBuf.capacity();
        if (bytesLength > capacity) {
            tmpBuf = ByteBuffer.allocateDirect(bytesLength);
        }
        ByteBufferUtil.loadBuffer(bytes, tmpBuf);
        return tmpBuf;
    }

    void setDataBuf(ByteBuffer dataBuf) {
        this.dataBytes = NativeOutput.checkBytesSize(dataBuf, this.dataBytes);
        this.dataFields = NativeOutput.setBuf(dataBuf, this.dataBytes);
    }

    void setInputDataBuf(ByteBuffer inputDataBuf) {
        this.inputDataBytes = NativeOutput.checkBytesSize(inputDataBuf, this.inputDataBytes);
        this.inputDataFields = NativeOutput.setBuf(inputDataBuf, this.inputDataBytes);
    }

    void setCenterlineDataBuf(ByteBuffer centerlineDataBuf) {
        this.centerlineDataBytes = NativeOutput.checkBytesSize(centerlineDataBuf, this.centerlineDataBytes);
        this.centerlineDataFields = NativeOutput.setBuf(centerlineDataBuf, this.centerlineDataBytes);
    }

    void setMultipleDataBuf(ByteBuffer multipleDataBuf, short index) {
        Short key = new Short(index);
        byte[] bytes = (byte[])this.multipleDataBytes.get(key);
        bytes = NativeOutput.checkBytesSize(multipleDataBuf, bytes);
        this.multipleDataBytes.put(key, bytes);
        Map fields = NativeOutput.setBuf(multipleDataBuf, bytes);
        this.multipleDataRecords.put(key, fields);
    }

    private static byte[] checkBytesSize(ByteBuffer buf, byte[] bytes) {
        return bytes == null ? new byte[buf.capacity()] : bytes;
    }

    private static Map setBuf(ByteBuffer buf, byte[] bytes) {
        ByteBufferUtil.copyBuffer(buf, bytes);
        return NativeOutput.fromBytes(bytes);
    }
}

