/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.Street;

public class Range {
    private GeoStan geostan = null;
    private short status = 1;

    Range(GeoStan geostan, short status) {
        this.geostan = geostan;
        this.status = status;
    }

    public Range(Street st) {
        this.geostan = st.getGeostan();
        this.status = st.getStatus();
    }

    Range(GeoStan geostan) {
        this.geostan = geostan;
    }

    GeoStan getMyGeostan() {
        return this.geostan;
    }

    short getMyStatus() {
        return this.status;
    }

    public boolean isValid() {
        return this.geostan != null && this.status == 0;
    }

    public String getData(int field) throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The range is invalid.");
        }
        return this.geostan.getRangeData(this, field);
    }

    public boolean isWithin(String number, String low, String high) throws GeoStanException {
        return this.geostan.testRange(number, low, high);
    }

    public boolean contains(String number) throws GeoStanException {
        String low = this.getData(16);
        String high = this.getData(8);
        return this.isWithin(number, low, high);
    }

    public boolean select(short findOptions) throws GeoStanException {
        return this.geostan.selectRange(this, findOptions);
    }
}

