/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.Range;
import com.centrus.geostan.Segment;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RangeIterator
implements Iterator {
    private GeoStan geostan = null;
    private Segment segment = null;
    private boolean needNext = false;
    private boolean gotFirst = false;
    private Range nextRange = null;

    RangeIterator(GeoStan geostan, Segment segment) {
        this.geostan = geostan;
        this.segment = segment;
        this.needNext = true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Range elements cannot be removed.");
    }

    @Override
    public boolean hasNext() {
        if (this.needNext) {
            this.getNext();
            this.needNext = false;
        }
        return this.nextRange != null && this.nextRange.isValid();
    }

    public Object next() {
        if (this.needNext) {
            this.getNext();
        } else {
            this.needNext = true;
        }
        if (this.nextRange == null || !this.nextRange.isValid()) {
            throw new NoSuchElementException("Invalid Range object");
        }
        return this.nextRange;
    }

    private void getNext() {
        if (this.geostan == null) {
            throw new NoSuchElementException("Invalid GeoStan object");
        }
        try {
            if (!this.gotFirst) {
                if (this.segment == null) {
                    throw new NoSuchElementException("Invalid Segment object");
                }
                this.nextRange = this.geostan.findFirstRange(this.segment);
                this.gotFirst = true;
            } else {
                this.nextRange = this.geostan.findNextRange(this.nextRange);
            }
        }
        catch (GeoStanException ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }
}

