/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.Coordinate;
import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.MinBoundingRect;
import com.centrus.geostan.Range;
import com.centrus.geostan.RangeIterator;

public class Segment {
    private GeoStan geostan = null;
    private short status = 1;
    private Range range = null;

    Segment(GeoStan geostan, short status) {
        this.geostan = geostan;
        this.status = status;
    }

    Segment(GeoStan geostan) {
        this.geostan = geostan;
    }

    public Segment(Range r) {
        this.geostan = r.getMyGeostan();
        this.status = r.getMyStatus();
    }

    public boolean isValid() {
        return this.geostan != null && this.status == 0;
    }

    public String getData(int field) throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The segment is invalid.");
        }
        return this.geostan.getSegmentData(this, field);
    }

    public MinBoundingRect getMinBoundingRect() throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The segment is invalid.");
        }
        return this.geostan.getMinBoundingRectFromSegment(this);
    }

    public Coordinate[] getCoords() throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The segment is invalid");
        }
        return this.geostan.getCoordsFromSegment(this);
    }

    Range findFirstRange() throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The segment is invalid.");
        }
        this.range = this.geostan.findFirstRange(this);
        return this.range;
    }

    Range findNextRange() throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The segment is invalid.");
        }
        if (!this.range.isValid()) {
            throw new GeoStanException("The previous range is invalid");
        }
        this.range = this.geostan.findNextRange(this.range);
        return this.range;
    }

    public RangeIterator createRangeIterator() throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The segment is invalid.");
        }
        return new RangeIterator(this.geostan, this);
    }
}

