/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.MinBoundingRect;
import com.centrus.geostan.Segment;
import com.centrus.geostan.SegmentIterator;

public class Street {
    private GeoStan geostan = null;
    private short status = 1;
    private Segment segment = null;

    public Street(GeoStan geostan, short status, byte[] handle) {
        this.geostan = geostan;
        this.status = status;
    }

    Street(GeoStan geostan) {
        this.geostan = geostan;
    }

    GeoStan getGeostan() {
        return this.geostan;
    }

    short getStatus() {
        return this.status;
    }

    public boolean isValid() {
        return this.geostan != null && this.status == 0;
    }

    public String getData(int field) throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The street is invalid.");
        }
        return this.geostan.getStreetData(this, field);
    }

    Segment findFirstSegment() throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The street is invalid.");
        }
        this.segment = this.geostan.findFirstSegment(this);
        return this.segment;
    }

    Segment findNextSegment() throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The street is invalid.");
        }
        if (!this.segment.isValid()) {
            throw new GeoStanException("The previous segment is invalid");
        }
        this.segment = this.geostan.findNextSegment(this.segment);
        return this.segment;
    }

    public SegmentIterator createSegmentIterator() throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The street is invalid.");
        }
        return new SegmentIterator(this.geostan, this);
    }

    public MinBoundingRect getMinBoundingRect() throws GeoStanException {
        if (!this.isValid()) {
            throw new GeoStanException("The street is invalid.");
        }
        return this.geostan.getMinBoundingRectFromStreet(this);
    }
}

