/*
 * Decompiled with CFR 0.152.
 */
package com.centrus.geostan;

import com.centrus.geostan.GeoStan;
import com.centrus.geostan.GeoStanException;
import com.centrus.geostan.Street;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StreetIterator
implements Iterator {
    private GeoStan geostan = null;
    private short option = 0;
    private String locale = null;
    private String name = null;
    private String number = null;
    private boolean needNext = false;
    private boolean gotFirst = false;
    private Street nextStreet = null;

    StreetIterator(GeoStan geostan, short option, String locale, String name, String number) {
        this.geostan = geostan;
        this.option = option;
        this.locale = locale;
        this.name = name;
        this.number = number == null ? "" : number;
        this.needNext = true;
    }

    public short getOption() {
        return this.option;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Street elements cannot be removed.");
    }

    @Override
    public boolean hasNext() {
        if (this.needNext) {
            this.getNext();
            this.needNext = false;
        }
        return this.nextStreet != null && this.nextStreet.isValid();
    }

    public Object next() {
        if (this.needNext) {
            this.getNext();
        } else {
            this.needNext = true;
        }
        if (this.nextStreet == null || !this.nextStreet.isValid()) {
            throw new NoSuchElementException("Invalid Street object");
        }
        return this.nextStreet;
    }

    private void getNext() {
        if (this.geostan == null) {
            throw new NoSuchElementException("Invalid GeoStan object");
        }
        try {
            if (!this.gotFirst) {
                this.nextStreet = this.geostan.findFirstStreet(this.option, this.locale, this.name, this.number);
                this.gotFirst = true;
            } else {
                this.nextStreet = this.geostan.findNextStreet(this.nextStreet);
            }
        }
        catch (GeoStanException ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }
}

