/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.APAC.utils;

import java.util.ArrayList;

public abstract class APAC_StringUtilities {
    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String removeRepeatedString(String str, String removeStr) {
        if (APAC_StringUtilities.isEmpty(str) || removeStr == null || str.indexOf(removeStr) == -1) {
            return str;
        }
        while (str.indexOf(removeStr + removeStr) != -1) {
            str = str.replaceFirst(removeStr + removeStr, removeStr);
        }
        return str;
    }

    public static String removeIfFirst(String inputString, String removeStr) {
        if (inputString == null || removeStr == null) {
            return inputString;
        }
        if (inputString.startsWith(removeStr)) {
            return inputString.replaceFirst(removeStr, "");
        }
        return inputString;
    }

    public static String removeIfLast(String inputString, String removeStr) {
        if (inputString == null || removeStr == null) {
            return inputString;
        }
        if (inputString.endsWith(removeStr)) {
            return inputString.substring(0, inputString.length() - removeStr.length());
        }
        return inputString;
    }

    public static double extractDouble(String string) {
        if (APAC_StringUtilities.isEmpty(string)) {
            return -1.0;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (!Character.isDigit(ch)) continue;
            sb.append(ch);
        }
        try {
            return new Double(sb.toString());
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public static String[] split(String tokens, String delims, String keepDelims) {
        if (APAC_StringUtilities.isEmpty(tokens) || APAC_StringUtilities.isEmpty(delims) || APAC_StringUtilities.isEmpty(keepDelims)) {
            return new String[0];
        }
        ArrayList<String> tokenList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tokens.length(); ++i) {
            char currentChar = tokens.charAt(i);
            if (!APAC_StringUtilities.isDelimiter(delims, currentChar)) {
                sb.append(currentChar);
            } else {
                if (!APAC_StringUtilities.isBufferEmpty(sb)) {
                    tokenList.add(sb.toString());
                    sb = new StringBuffer();
                }
                if (APAC_StringUtilities.isDelimiter(keepDelims, currentChar)) {
                    tokenList.add(tokens.substring(i, i + 1));
                }
            }
            if (APAC_StringUtilities.isBufferEmpty(sb) || !APAC_StringUtilities.isLastChar(tokens, i)) continue;
            tokenList.add(sb.toString());
        }
        return tokenList.toArray(new String[0]);
    }

    private static boolean isBufferEmpty(StringBuffer sb) {
        return sb.length() == 0;
    }

    private static boolean isLastChar(String tokens, int i) {
        return i + 1 == tokens.length();
    }

    private static boolean isDelimiter(String delims, char currentChar) {
        return delims.indexOf(currentChar) > -1;
    }

    public static int[] extractIntArray(String groupString) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        StringBuffer sb = new StringBuffer();
        boolean intFound = false;
        for (int i = 0; i < groupString.length(); ++i) {
            char ch = groupString.charAt(i);
            if (Character.isDigit(ch)) {
                sb.append(ch);
                intFound = true;
                if (i != groupString.length() - 1) continue;
                results.add(new Integer(sb.toString()));
                sb = new StringBuffer();
                continue;
            }
            if (!intFound) continue;
            results.add(new Integer(sb.toString()));
            sb = new StringBuffer();
            intFound = false;
        }
        int[] intArray = new int[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            intArray[i] = (Integer)results.get(i);
        }
        return intArray;
    }
}

