/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_DictionaryGeographyInfo;
import com.mapinfo.mapmarker.AUS.AUS_InternalDBCandidate;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataManager;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.custom.ICustomGeocoder;
import java.util.ArrayList;
import java.util.List;

public class AUS_CustomGeocoder
implements ICustomGeocoder {
    public static final int GEOCODE_TYPE_DB_AVAILABILITY = 205;

    public GeocodeResult geocodeCustom(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        switch (geocodeType) {
            case 205: {
                List dictInfos;
                IHandler handler = constraints.getHandler();
                GeocodeResult gr = new GeocodeResult();
                ArrayList<AUS_InternalDBCandidate> candList = new ArrayList<AUS_InternalDBCandidate>();
                AUS_InternalDBCandidate cand = new AUS_InternalDBCandidate();
                ICountryGeographyInfo infos = handler.getDataManager().getCountryGeographyInfo();
                if (infos.hasUserDictionaries()) {
                    cand.setDbFlags(4);
                }
                if ((dictInfos = infos.getDictionaryInfos()) != null) {
                    for (AUS_DictionaryGeographyInfo AUSDictInfo : dictInfos) {
                        if (AUSDictInfo.hasStreets()) {
                            cand.setDbFlags(cand.getDbFlags() | 1);
                        }
                        if (AUSDictInfo.hasCentroids()) {
                            cand.setDbFlags(cand.getDbFlags() | 2);
                        }
                        if (!AUSDictInfo.isGNAFDict()) continue;
                        cand.setDbFlags(cand.getDbFlags() | 8);
                    }
                }
                candList.add(cand);
                gr.setNumberCandidates(1);
                handler.setGeocodeResult(gr);
                handler.setMatchResults(candList);
                return gr;
            }
            case 206: {
                return this.geocodePID(constraints);
            }
        }
        throw new MMGeneralGeocoderException(2307);
    }

    private GeocodeResult geocodePID(IConstraints constraints) throws MapMarkerInternalException {
        IRetrievedCandidates retrieved;
        IHandler handler = constraints.getHandler();
        GeocodeResult result = new GeocodeResult();
        AUS_DataManager dataManager = (AUS_DataManager)handler.getDataManager();
        try {
            retrieved = dataManager.retrievePIDCandidates(handler.getInputAddress(), constraints);
        }
        catch (FatalDataAccessException FDAEx) {
            throw new MMGeneralGeocoderException(2102, (Throwable)FDAEx);
        }
        result.setDataLicensed(retrieved.getDataLicensed());
        List candidates = retrieved.getCandidates();
        int candidateCount = candidates.size();
        result.setNumberCandidates(candidateCount);
        result.setNumberCloseCandidates(candidateCount);
        handler.setMatchResults(candidates);
        handler.setGeocodeResult(result);
        return result;
    }
}

