/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_Range;
import com.mapinfo.mapmarker.AUS.AUS_RangeUnit;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_Segment;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.AUS.utils.GNAFAddressClass;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.List;

public class AUS_GNAFInfoData {
    private static final String KEY_GNAF_PID = "GNAF_PID";
    private static final String KEY_MESH_BLOCK = "MESH_BLOCK_ID";
    private static final String KEY_GNAF_CONFIDENCE = "GNAF_CONFIDENCE";
    private static final String KEY_GNAF_RELIABILITY = "GNAF_RELIABILITY";
    private static final String KEY_GNAF_GEOCODE_LEVEL = "GNAF_GEOCODE_LEVEL";
    private static final String KEY_LOT_NUMBER = "LOT_NUMBER";
    private static final String KEY_LOT_PREFIX = "LOT_PREFIX";
    private static final String KEY_LOT_SUFFIX = "LOT_SUFFIX";
    private static final int MAX_ABBR_FOR_STATE = 3;
    private int m_confidence;
    private int m_reliability;
    private int m_geocodeLevel;
    private String m_confidenceStr;
    private String m_reliabilityStr;
    private String m_geocodeLevelStr;
    private String m_meshBlockIDStr;
    private String m_gnafIDStr;
    private String m_lotNumberStr;
    private String m_lotNumberPrefixStr;
    private String m_lotNumberSuffixStr;
    private String m_primaryPIDStr;
    private int m_segmentSide;
    private int m_rangeIndex;
    private String m_geoContainment;
    private String m_geoFeature;
    private GNAFAddressClass m_addressClass;
    private String m_SA1Str;
    private String m_parcelID;

    public AUS_GNAFInfoData(AUS_InternalCandidateAddress cand) {
        this.init();
        if (cand.getSegment() != null) {
            AUS_Segment segment = (AUS_Segment)cand.getSegment();
            if (!StringUtilities.isEmpty((String)segment.getMeshBlockId())) {
                this.m_meshBlockIDStr = segment.getMeshBlockId();
            }
            if (cand.hasMatchingRange()) {
                List rangeList = segment.getRanges(cand.getSegmentSide());
                AUS_Range range = (AUS_Range)((Object)rangeList.get(cand.getMatchedRangeNumber()));
                this.m_geoContainment = range.getGeoContainment() ? "YES" : "NO";
                this.m_geoFeature = range.getGeoFeature();
                this.setGnafMetaData(range);
            } else if (cand.hasClosestRange()) {
                List rangeList = segment.getRanges(cand.getClosestSegmentSide());
                AUS_Range range = (AUS_Range)((Object)rangeList.get(cand.getClosestRangeNumber()));
                this.m_geoContainment = range.getGeoContainment() ? "YES" : "NO";
                this.m_geoFeature = range.getGeoFeature();
                this.setGnafMetaData(range);
            } else if (!segment.hasValidReliability()) {
                boolean bFoundValidRange = this.findFirstValidRangeForGNAFMetadataFromSegment(segment, true);
                if (!bFoundValidRange) {
                    bFoundValidRange = this.findFirstValidRangeForGNAFMetadataFromSegment(segment, false);
                }
                if (bFoundValidRange) {
                    AUS_Range range = (AUS_Range)segment.getRangeAt(this.m_rangeIndex, this.m_segmentSide);
                    if (range.hasValidReliability()) {
                        this.m_reliability = range.getReliability();
                        this.m_reliabilityStr = String.valueOf(this.m_reliability);
                    }
                    this.m_lotNumberStr = range.getLotNumber();
                    this.m_lotNumberPrefixStr = range.getLotPrefix();
                    this.m_lotNumberSuffixStr = range.getLotSuffix();
                }
            }
            if (this.m_reliabilityStr == null && segment.hasValidReliability()) {
                this.m_reliabilityStr = String.valueOf(segment.getReliability());
                this.m_reliability = segment.getReliability();
            }
            if (!"YES".equals(this.m_geoContainment)) {
                String string = this.m_geoContainment = segment.getGeoContainment() ? "YES" : "NO";
            }
            if (this.m_geoFeature == null) {
                this.m_geoFeature = segment.getGeoFeature();
            }
            if (segment.getSA1() != null) {
                this.m_SA1Str = segment.getSA1();
            }
        }
    }

    private boolean findFirstValidRangeForGNAFMetadataFromSegment(Segment segment, boolean bRangeOnly) {
        this.m_rangeIndex = this.findFirstValidRangeForGNAFMetadata(segment.getRanges(0), bRangeOnly);
        if (this.m_rangeIndex != -1) {
            this.m_segmentSide = 0;
            return true;
        }
        this.m_rangeIndex = this.findFirstValidRangeForGNAFMetadata(segment.getRanges(1), bRangeOnly);
        if (this.m_rangeIndex != -1) {
            this.m_segmentSide = 1;
            return true;
        }
        return false;
    }

    private int findFirstValidRangeForGNAFMetadata(List ranges, boolean bRangeOnly) {
        if (ranges == null || ranges.size() == 0) {
            return -1;
        }
        for (int index = 0; index < ranges.size(); ++index) {
            AUS_Range range = (AUS_Range)((Object)ranges.get(index));
            if (!range.hasValidReliability()) continue;
            if (bRangeOnly) {
                if (!range.hasValidConfidence() || !range.hasValidGeocodeLevel()) continue;
                return index;
            }
            List rangeUnits = range.getRangeUnits();
            if (rangeUnits == null || rangeUnits.size() == 0) continue;
            for (AUS_RangeUnit rangeUnit : rangeUnits) {
                if (!rangeUnit.hasValidConfidence() || !rangeUnit.hasValidGeocodeLevel()) continue;
                return index;
            }
        }
        return -1;
    }

    private void setGnafMetaData(AUS_Range range) {
        if (range.hasMatchingRangeUnit()) {
            RangeUnit rangeUnit = range.getRangeUnitAt(range.getMatchingRangeUnit());
            this.setGnafMetaData((AUS_RangeUnit)rangeUnit);
        } else if (range.hasClosestRangeUnit()) {
            RangeUnit rangeUnit = range.getRangeUnitAt(range.getClosestRangeUnit());
            this.setGnafMetaData((AUS_RangeUnit)rangeUnit);
        } else {
            this.m_parcelID = range.getParcelID();
        }
        if (this.m_confidenceStr == null && range.hasValidConfidence()) {
            this.m_confidenceStr = String.valueOf(range.getConfidence());
            this.m_confidence = range.getConfidence();
        }
        if (this.m_geocodeLevelStr == null && range.hasValidGeocodeLevel()) {
            this.m_geocodeLevelStr = String.valueOf(range.getGeocodeLevel());
            this.m_geocodeLevel = range.getGeocodeLevel();
        }
        if (range.hasValidReliability()) {
            this.m_reliabilityStr = String.valueOf(range.getReliability());
            this.m_reliability = range.getReliability();
        }
        if (this.m_gnafIDStr == null && range.getPID() != 0) {
            this.m_gnafIDStr = StringUtilities.intToLeadingZeroString((int)9, (int)range.getPID());
        }
        if (this.m_primaryPIDStr == null && range.getPrimaryPID() != 0) {
            this.m_primaryPIDStr = StringUtilities.intToLeadingZeroString((int)9, (int)range.getPrimaryPID());
        }
        this.m_lotNumberStr = range.getLotNumber();
        this.m_lotNumberPrefixStr = range.getLotPrefix();
        this.m_lotNumberSuffixStr = range.getLotSuffix();
        if (this.m_addressClass == null) {
            this.m_addressClass = range.getAddressClass();
        }
    }

    private void setGnafMetaData(AUS_RangeUnit rangeUnit) {
        if (rangeUnit.hasValidConfidence()) {
            this.m_confidenceStr = String.valueOf(rangeUnit.getConfidence());
            this.m_confidence = rangeUnit.getConfidence();
        }
        if (rangeUnit.hasValidGeocodeLevel()) {
            this.m_geocodeLevelStr = String.valueOf(rangeUnit.getGeocodeLevel());
            this.m_geocodeLevel = rangeUnit.getGeocodeLevel();
        }
        if (rangeUnit.getPID() != 0) {
            this.m_gnafIDStr = StringUtilities.intToLeadingZeroString((int)9, (int)rangeUnit.getPID());
        }
        if (rangeUnit.getPrimaryPID() != 0) {
            this.m_primaryPIDStr = StringUtilities.intToLeadingZeroString((int)9, (int)rangeUnit.getPrimaryPID());
        }
        if (rangeUnit.getAddressClass() != null) {
            this.m_addressClass = rangeUnit.getAddressClass();
        }
        this.m_parcelID = rangeUnit.getParcelID();
    }

    public void addInfoDataIntoAdditionalFields(CandidateAddress cand) {
        if (cand == null) {
            return;
        }
        HashMap fields = cand.getAdditionalFields();
        if (fields == null) {
            return;
        }
        String gnafString = AUS_AddressUtils.buildGnafPIDString(this.m_gnafIDStr, cand.getAreaName1());
        AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, KEY_GNAF_PID, gnafString);
        AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, KEY_MESH_BLOCK, this.m_meshBlockIDStr);
        AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, KEY_GNAF_CONFIDENCE, this.m_confidenceStr);
        AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, KEY_GNAF_RELIABILITY, this.m_reliabilityStr);
        AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, KEY_GNAF_GEOCODE_LEVEL, this.m_geocodeLevelStr);
        AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, "GNAF_PRINCIPAL_PID", AUS_AddressUtils.buildGnafPIDString(this.m_primaryPIDStr, cand.getAreaName1()));
        String lotstr = AUS_AddressUtils.combineNonNullStrings(this.m_lotNumberPrefixStr, this.m_lotNumberStr, this.m_lotNumberSuffixStr);
        if (lotstr != null) {
            AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, KEY_LOT_NUMBER, lotstr);
        }
        AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, "GEOCONTAINMENT", this.m_geoContainment);
        if (this.m_geoFeature != null) {
            AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, "GEOFEATURE", this.m_geoFeature);
        }
        if (this.m_addressClass != null) {
            AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, "GNAF_ADDRESS_CLASS", this.m_addressClass.getAddressClass());
        }
        if (this.m_SA1Str != null) {
            AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, "GNAF_SA1", this.m_SA1Str);
        }
        if (this.m_parcelID != null) {
            AUS_GNAFInfoData.addKeyValuePairIntoMap(fields, "GNAF_PARCEL_ID", this.m_parcelID);
        }
    }

    public int getConfidence() {
        return this.m_confidence;
    }

    public int getReliability() {
        return this.m_reliability;
    }

    public int getGeocodeLevel() {
        return this.m_geocodeLevel;
    }

    public int getSegmentSide() {
        return this.m_segmentSide;
    }

    public int getRangeIndex() {
        return this.m_rangeIndex;
    }

    private void init() {
        this.m_confidence = -2;
        this.m_reliability = 127;
        this.m_geocodeLevel = 0;
        this.m_segmentSide = -1;
        this.m_rangeIndex = -1;
    }

    private static void addKeyValuePairIntoMap(HashMap map, String key, String value) {
        if (StringUtilities.isEmpty((String)key)) {
            return;
        }
        if (map.containsKey(key)) {
            map.remove(key);
        }
        if (StringUtilities.isEmpty((String)value)) {
            return;
        }
        map.put(key, value);
    }

    public boolean equals(AUS_GNAFInfoData other) {
        return this.m_confidence == other.m_confidence && this.m_reliability == other.m_reliability && this.m_geocodeLevel == other.m_geocodeLevel && StringUtilities.equalStrings((String)this.m_gnafIDStr, (String)other.m_gnafIDStr) && StringUtilities.equalStrings((String)this.m_meshBlockIDStr, (String)other.m_meshBlockIDStr) && StringUtilities.equalStrings((String)this.m_primaryPIDStr, (String)other.m_primaryPIDStr) && StringUtilities.equalStrings((String)this.m_geoContainment, (String)other.m_geoContainment) && StringUtilities.equalStrings((String)this.m_geoFeature, (String)other.m_geoFeature) && this.m_addressClass == other.m_addressClass && StringUtilities.equalStrings((String)this.m_SA1Str, (String)other.m_SA1Str) && StringUtilities.equalStrings((String)this.m_parcelID, (String)other.m_parcelID);
    }
}

