/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_IConstraints;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.core.CoreGeocoder;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.address.IAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreAddressGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicGeocoder;
import com.mapinfo.mapmarker.core.parser.ParserException;
import java.util.List;
import java.util.ResourceBundle;

public class AUS_Geocoder
implements IGeocoder {
    CoreGeocoder m_coreGeocoder;

    public AUS_Geocoder(IHandler handler) {
        this.m_coreGeocoder = new CoreGeocoder(handler);
    }

    public GeocodeResult geocode(IConstraints constraints) throws MMInternalFatalException, MapMarkerInternalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(0, constraints);
        }
        if (!constraints.getHandler().isGeocodeSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IAddressGeocoder geo = constraints.getHandler().getAddressGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        AUS_IConstraints ausConstraints = (AUS_IConstraints)constraints;
        GeocodeResult result = geo.geocode((IConstraints)ausConstraints, this.getErrorBundle());
        if (result.getNumberCloseCandidates() == 0) {
            IHandler handler = constraints.getHandler();
            List savedMatchedCandidates = handler.getMatchResults();
            GeocodeResult fallbackResult = this.handleFallback(constraints);
            if (fallbackResult == null) {
                handler.setGeocodeResult(result);
                handler.setMatchResults(savedMatchedCandidates);
            } else {
                result.copy(fallbackResult);
            }
        }
        return result;
    }

    private GeocodeResult handleFallback(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        GeocodeResult fallbackResult;
        boolean bDoPostalFallback = constraints.isFallbackToPostal();
        boolean bDoGeoFallback = constraints.isFallbackToGeographic();
        ((ICoreAddressGeocoder)constraints.getHandler()).setPostalFallbackOccured(false);
        ((ICoreAddressGeocoder)constraints.getHandler()).setGeoFallbackOccured(false);
        if (!bDoPostalFallback && !bDoGeoFallback) {
            return null;
        }
        if (bDoPostalFallback && bDoGeoFallback) {
            CandidateAddress addr;
            GeocodeResult GeoFallBackResult = null;
            GeoFallBackResult = this.tryGeoFallback(constraints);
            if (GeoFallBackResult != null && GeoFallBackResult.getNumberCloseCandidates() > 0 && (addr = this.getIndexedCandidate(0, constraints)) != null && (addr.getLocationPrecision() == 10 || addr.getLocationPrecision() == 11)) {
                return GeoFallBackResult;
            }
            if (((ICoreAddressGeocoder)constraints.getHandler()).preferPostalFallBack()) {
                fallbackResult = this.tryPostalFallback(constraints);
                if (fallbackResult != null) {
                    return fallbackResult;
                }
                bDoPostalFallback = false;
            } else {
                if (GeoFallBackResult != null) {
                    return GeoFallBackResult;
                }
                bDoGeoFallback = false;
            }
        }
        if (bDoPostalFallback && (fallbackResult = this.tryPostalFallback(constraints)) != null) {
            return fallbackResult;
        }
        if (bDoGeoFallback && (fallbackResult = this.tryGeoFallback(constraints)) != null) {
            return fallbackResult;
        }
        return null;
    }

    private GeocodeResult tryPostalFallback(IConstraints preferences) throws MapMarkerInternalException, MMInternalFatalException {
        GeocodeResult fallbackResult = this.geocodePostal(preferences);
        if (fallbackResult.getNumberCloseCandidates() == 0) {
            return null;
        }
        ((ICoreAddressGeocoder)preferences.getHandler()).setPostalFallbackOccured(true);
        return fallbackResult;
    }

    private GeocodeResult tryGeoFallback(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        GeocodeResult fallbackResult = this.geocodeGeographic(constraints);
        if (fallbackResult.getNumberCloseCandidates() == 0) {
            return null;
        }
        ((ICoreAddressGeocoder)constraints.getHandler()).setGeoFallbackOccured(true);
        return fallbackResult;
    }

    public void setErrorBundle(ResourceBundle bundle) {
        this.m_coreGeocoder.setErrorBundle(bundle);
    }

    public GeocodeResult standardize(IConstraints constraints) throws MapMarkerInternalException {
        return this.m_coreGeocoder.standardize(constraints);
    }

    public GeocodeResult geocodePostal(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        return this.m_coreGeocoder.geocodePostal(constraints);
    }

    public GeocodeResult browse(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        return this.m_coreGeocoder.browse(constraints);
    }

    public GeocodeResult geocodeCustom(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        return this.m_coreGeocoder.geocodeCustom(geocodeType, constraints);
    }

    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(4, constraints);
        }
        if (!constraints.getHandler().isGeocodeGeographicSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IGeographicGeocoder geo = constraints.getHandler().getGeographicGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.geocodeGeographic(constraints);
    }

    public CandidateAddress getIndexedCandidate(int i, IConstraints preferences) throws MapMarkerInternalException {
        return this.m_coreGeocoder.getIndexedCandidate(i, preferences);
    }

    public CandidateAddress getIndexedCoords(int candIndex, CandidateRange range, IConstraints preferences) throws MapMarkerInternalException {
        return this.m_coreGeocoder.getIndexedCoords(candIndex, range, preferences);
    }

    public ResourceBundle getErrorBundle() {
        return this.m_coreGeocoder.getErrorBundle();
    }

    public String getLocalStrings() {
        return this.m_coreGeocoder.getLocalStrings();
    }

    public void setLocalStrings(String localStrings) {
        this.m_coreGeocoder.setLocalStrings(localStrings);
    }

    public IConstraints convertConstraints(IConstraints constraints) {
        return this.m_coreGeocoder.convertConstraints(constraints);
    }

    public void prepareAndParse(int geocodeType, IConstraints constraints) throws ParserException, MapMarkerInternalException {
        this.m_coreGeocoder.prepareAndParse(geocodeType, constraints);
    }

    public ICountryGeographyInfo getCountryGeographyInfo() {
        return this.m_coreGeocoder.getCountryGeographyInfo();
    }
}

