/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_Constraints;
import com.mapinfo.mapmarker.AUS.AUS_GNAFInfoData;
import com.mapinfo.mapmarker.AUS.AUS_IConstraints;
import com.mapinfo.mapmarker.AUS.AUS_Range;
import com.mapinfo.mapmarker.AUS.AUS_RangeUnit;
import com.mapinfo.mapmarker.AUS.AUS_ScoringAddress;
import com.mapinfo.mapmarker.AUS.AUS_StreetCandidateAddress;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_GeoInfoRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_Segment;
import com.mapinfo.mapmarker.AUS.parser.AUS_Directionals;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.ParsedRangeScore;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public class AUS_InternalCandidateAddress
extends InternalCandidateAddress {
    public static final int PRE_POST_TYPE_SWAP = 1;
    public static final int PERFECT_AREANAME3_SCORE_FROM_OTHERS = 2;
    public static final int PRE_POST_DIRECTIONAL_SWAP = 4;
    public static final int PERFECT_HOUSE_NUMBER_WITH_MISSING_CHAR = 8;
    public static final int PERFECT_HOUSE_NUMBER_WITH_PARTIAL_RANGE = 16;
    public static final int SHIFT_DIRECTIONAL_TO_AREANAME3 = 32;
    public static final int AREANAME3_SCORE_FROM_OTHERS = 64;
    private static final double AREA_NAME_3B_SCORE_FLOOR = 0.75;
    private static CoordSys ORIGINAL_POINTS_COORDSYS = CoordSysFactory.getDefaultCoordSysFactory().getCoordSys("epsg:4283");
    private double unitNumberScore;
    private AUS_GNAFInfoData m_gnafInfoData;
    private ParsedNumber m_inputLevelNumber;
    private boolean m_bInputContainedLotNumber;
    private String m_levelNumber;
    private String m_levelType;
    private boolean m_bUseTypeAbbrevs;
    private boolean m_adjustS4;

    public AUS_InternalCandidateAddress() {
    }

    public AUS_InternalCandidateAddress(Address addr) {
        super(addr);
    }

    public String getAddressNumber() {
        int num;
        Range range = this.getMatchingOrClosestRange();
        if (range != null && this.fromGNAFDictionary()) {
            if (((AUS_Range)range).isHouseFromLotNumber()) {
                return null;
            }
            return range.getParsedFrom().getCombinedAddressNumber();
        }
        String addrnumber = super.getAddressNumber();
        ParsedNumber pn = super.getParsedAddressNumber();
        if (pn != null) {
            addrnumber = pn.getCombinedAddressNumber();
        }
        if (addrnumber != null && addrnumber.length() > 0 && StringUtilities.isNumeric((String)addrnumber) && (num = addrnumber.indexOf(46)) > 0) {
            addrnumber = addrnumber.substring(0, num);
        }
        return addrnumber;
    }

    public String getAreaName1() {
        Segment segment;
        String areaName1 = super.getAreaName1();
        if (areaName1 == null && (segment = this.getSegment()) != null) {
            return this.checkLeftRight(segment.getLeftAreaName1(), segment.getRightAreaName1());
        }
        return areaName1;
    }

    public String getAreaName2() {
        Segment segment;
        String areaName2 = super.getAreaName2();
        if (areaName2 == null && (segment = this.getSegment()) != null) {
            return this.checkLeftRight(segment.getLeftAreaName2(), segment.getRightAreaName2());
        }
        return areaName2;
    }

    public String getAreaName3() {
        Segment segment;
        String areaName3 = super.getAreaName3();
        if (areaName3 == null && (segment = this.getSegment()) != null) {
            return this.checkLeftRight(segment.getLeftAreaName3(), segment.getRightAreaName3());
        }
        return areaName3;
    }

    public String getPostCode1() {
        Segment segment;
        String postCode1 = super.getPostCode1();
        if (postCode1 == null && (segment = this.getSegment()) != null) {
            postCode1 = this.checkLeftRight(segment.getLeftPostCode1(), segment.getRightPostCode1());
        }
        if (postCode1 != null && postCode1.length() == 3) {
            postCode1 = "0" + postCode1;
        }
        return postCode1;
    }

    public void scorePostalInformation(ScoringAddress scoringAddress) {
        String inputPostCode = scoringAddress.getPostCode1();
        String candidatePostCode = this.getPostCode1();
        double totalScore = 0.1;
        if (inputPostCode == null || candidatePostCode == null) {
            totalScore = inputPostCode == null && candidatePostCode == null ? 1.0 : 0.0;
            this.setPostCode1Score(totalScore);
        } else if (inputPostCode.equals(candidatePostCode)) {
            this.setPostCode1Score(1.0);
        } else {
            if (inputPostCode.charAt(0) == candidatePostCode.charAt(0)) {
                totalScore += 0.3;
            }
            if (inputPostCode.charAt(1) == candidatePostCode.charAt(1)) {
                totalScore += 0.2;
            }
            if (inputPostCode.charAt(2) == candidatePostCode.charAt(2)) {
                totalScore += 0.2;
            }
            if (inputPostCode.charAt(3) == candidatePostCode.charAt(3)) {
                totalScore += 0.2;
            }
            this.setPostCode1Score(totalScore);
        }
    }

    public void scoreAreaNames(ScoringAddress scoringAddress) {
        super.scoreAreaNames(scoringAddress);
        double areaName3Score = this.getAreaName3Score();
        if (areaName3Score != 1.0) {
            double m_areaName3bScore;
            int tokIdx;
            String an3Orig;
            if ("CITY".equalsIgnoreCase(scoringAddress.getAreaName3()) && !StringUtilities.isEmpty((String)this.getAreaName3()) && this.getAreaName3().contains("BRISBANE")) {
                this.setAreaName3Score(0.98);
            }
            this.scoreAltAreaName3(scoringAddress);
            areaName3Score = this.getAreaName3Score();
            if (this.getPostDirectionalScore() != 1.0 && !StringUtilities.isEmpty((String)scoringAddress.getPostDirectional()) && !StringUtilities.isEmpty((String)(an3Orig = this.getAreaName3())) && (tokIdx = an3Orig.indexOf(32)) > 0) {
                String dirString = an3Orig.substring(0, tokIdx);
                String cityString = an3Orig.substring(tokIdx + 1);
                if (StringUtilities.equalStrings((String)scoringAddress.getPostDirectional(), (String)dirString) && AUS_Directionals.isDirection(dirString) && StringUtilities.equalStrings((String)scoringAddress.getAreaName3(), (String)cityString)) {
                    this.setAreaName3Score(1.0);
                    this.setMatchingFlag(32);
                }
            }
            if (areaName3Score != 1.0 && !StringUtilities.isEmpty((String)this.getAreaName2()) && (m_areaName3bScore = scoringAddress.scoreAreaName3(this.getAreaName2())) > areaName3Score && m_areaName3bScore > 0.75) {
                if (m_areaName3bScore == 1.0) {
                    this.setMatchingFlag(2);
                }
                this.setAreaName3Score(m_areaName3bScore);
            }
        }
    }

    public void scoreAddressNumber(ScoringAddress scoringAddress) {
        String fullAddressNumber = scoringAddress.getAddressNumber();
        if (fullAddressNumber != null && fullAddressNumber.indexOf(45) >= 0 && !this.fromGNAFDictionary()) {
            this.scoreAddressNumberAsRanged(scoringAddress);
        } else {
            this.scoreAddressNumberNormally(scoringAddress);
        }
        if (this.fromGNAFDictionary()) {
            this.populateLevelInformation();
        }
    }

    private void populateLevelInformation() {
        if (this.hasMatchingRange()) {
            int segSide = this.getSegmentSide();
            int rngNum = this.getMatchedRangeNumber();
            AUS_Range range = (AUS_Range)this.getSegment().getRangeAt(rngNum, segSide);
            if (range.hasMatchingRangeUnit() || range.getPID() == 0 && range.getRangeUnitCount() != 0) {
                String levelNumber;
                int unitNum;
                AUS_RangeUnit unit;
                if (!range.hasMatchingRangeUnit()) {
                    range.setMatchingRangeUnit(0);
                }
                if (!StringUtilities.isEmpty((String)(unit = (AUS_RangeUnit)range.getRangeUnitAt(unitNum = range.getMatchingRangeUnit())).getLevelType())) {
                    this.m_levelType = AUS_AddressUtils.getFullLevelName(unit.getLevelType());
                }
                if (unit.getLevelNumber() != null && !StringUtilities.isEmpty((String)(levelNumber = unit.getLevelNumber().getCombinedAddressNumber()))) {
                    this.m_levelNumber = levelNumber;
                }
            }
        }
    }

    private void scoreAddressNumberAsRanged(ScoringAddress scoringAddress) {
        int indexOfDash;
        String fullNumber = scoringAddress.getAddressNumber();
        if (fullNumber != null) {
            indexOfDash = fullNumber.indexOf(45);
            if (indexOfDash < 0) {
                this.scoreAddressNumberNormally(scoringAddress);
                return;
            }
        } else {
            this.scoreAddressNumberNormally(scoringAddress);
            return;
        }
        String firstPart = fullNumber.substring(0, indexOfDash);
        String secondPart = fullNumber.substring(indexOfDash + 1, fullNumber.length());
        scoringAddress.setAddressNumber(firstPart);
        this.scoreAddressNumberNormally(scoringAddress);
        int firstNumFlds = this.getInputNumber().getNumFields();
        int firstNumFldsMatched = this.getCntAddressNumberFieldsMatched();
        Range firstRange = null;
        String firstPartMatched = null;
        int firstMatchedSegmentSide = -1;
        int firstMatchedRangeNumber = -1;
        if (this.getMatchedRangeNumber() >= 0) {
            firstRange = this.getMatchingOrClosestRange();
            firstPartMatched = firstRange.getMatchedRangeNumber().getCombinedAddressNumber();
            firstMatchedSegmentSide = this.getSegmentSide();
            firstMatchedRangeNumber = this.getMatchedRangeNumber();
        }
        this.setInputNumber(null);
        this.setMatchedRangeNumber(-1);
        this.setSegmentSide(-1);
        this.setClosestRange(-1);
        this.setClosestSegmentSide(-1);
        this.setMatchingFlag(0);
        this.setCntAddressNumberFieldsMatched(0);
        scoringAddress.setAddressNumber(secondPart);
        this.scoreAddressNumberNormally(scoringAddress);
        int secondNumFlds = this.getInputNumber().getNumFields();
        int secondNumFldsMatched = this.getCntAddressNumberFieldsMatched();
        Range secondRange = null;
        String secondPartMatched = null;
        if (this.getMatchedRangeNumber() >= 0) {
            secondRange = this.getMatchingOrClosestRange();
            secondPartMatched = secondRange.getMatchedRangeNumber().getCombinedAddressNumber();
        }
        this.setInputNumber(null);
        this.setMatchedRangeNumber(-1);
        this.setSegmentSide(-1);
        this.setClosestRange(-1);
        this.setClosestSegmentSide(-1);
        this.setMatchingFlag(0);
        this.setCntAddressNumberFieldsMatched(0);
        scoringAddress.setAddressNumber(fullNumber);
        if (firstRange != null && firstRange == secondRange) {
            this.setAddressNumberScore((double)(firstNumFldsMatched + secondNumFldsMatched) / (double)(firstNumFlds + secondNumFlds));
            this.setInputNumber(scoringAddress.getParsedAddressNumber());
            if (firstPartMatched.indexOf(45) >= 0 && firstPartMatched.equals(secondPartMatched)) {
                firstRange.setMatchedRangeNumber(new ParsedNumber(firstPartMatched));
            } else {
                firstRange.setMatchedRangeNumber(new ParsedNumber(firstPartMatched + "-" + secondPartMatched));
            }
            this.setSegmentSide(firstMatchedSegmentSide);
            this.setMatchedRangeNumber(firstMatchedRangeNumber);
        } else if (firstRange != null) {
            this.setAddressNumberScore(1.0);
            this.setInputNumber(new ParsedNumber(firstPart));
            firstRange.setMatchedRangeNumber(new ParsedNumber(firstPartMatched));
            this.setSegmentSide(firstMatchedSegmentSide);
            this.setMatchedRangeNumber(firstMatchedRangeNumber);
            this.setMatchingFlag(16);
        } else {
            this.scoreAddressNumberNormally(scoringAddress);
        }
    }

    private void scoreAddressNumberNormally(ScoringAddress scoringAddress) {
        Range range;
        Range range2;
        ParsedNumber uNum;
        ParsedNumber addrNum = scoringAddress.getParsedAddressNumber();
        if (addrNum == null && (uNum = scoringAddress.getParsedUnitValue()) != null && !uNum.isEmpty()) {
            addrNum = uNum;
        }
        this.setInputNumber(addrNum);
        if (this.getInputNumber() == null) {
            this.setInputNumberNull(true);
        }
        this.m_inputLevelNumber = ((AUS_ScoringAddress)scoringAddress).getLevelValue();
        this.m_bInputContainedLotNumber = StringUtilities.equalStrings((String)scoringAddress.getUnitType(), (String)"LOT");
        if (!this.m_bInputContainedLotNumber) {
            this.m_bInputContainedLotNumber = StringUtilities.equalStrings((String)scoringAddress.getGenericField4(), (String)"LOT");
        }
        this.setInputUnitId(scoringAddress.getParsedUnitValue());
        this.findBestRange(scoringAddress);
        if (!this.hasMatchingRange()) {
            if (this.hasClosestRange()) {
                range2 = (AUS_Range)this.getSegment().getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide());
                range2.findMatchingRangeUnit(scoringAddress);
                if (!range2.hasMatchingRangeUnit()) {
                    range2.findClosestRangeUnit(scoringAddress);
                }
            }
        } else {
            range2 = this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
            if (range2 != null && !range2.hasMatchingRangeUnit()) {
                range2.findClosestRangeUnit(scoringAddress);
            }
        }
        int numFieldsMatched = this.getCntAddressNumberFieldsMatched();
        if (this.isInputNumberNull() || this.getInputNumber() == null) {
            this.setAddressNumberScore(1.0);
            return;
        }
        int numFields = this.getInputNumber().getNumFields();
        if (numFields == 0) {
            this.setAddressNumberScore(1.0);
        } else if (numFieldsMatched > numFields) {
            this.setAddressNumberScore(1.0);
        } else if (numFields == 3 && this.getInputNumber().isHyphenatedNumber() && numFieldsMatched == 1 && this.getMatchingOrClosestRange() != null && !this.fromGNAFDictionary()) {
            this.setAddressNumberScore(1.0);
        } else if (this.getInputNumber().hasSeparator() && numFieldsMatched == this.getInputNumber().getNumFields() - 1) {
            this.setAddressNumberScore(1.0);
        } else {
            ParsedRangeScore prScore;
            AUS_Range range3;
            this.setAddressNumberScore((double)numFieldsMatched / (double)numFields);
            if (this.fromGNAFDictionary() && this.hasMatchingRange() && (range3 = (AUS_Range)this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide())).wasGNAFMatch()) {
                this.setAddressNumberScore(1.0);
            }
            if (numFieldsMatched == numFields && this.hasMatchingRange() && (range3 = this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide())) != null && !this.fromGNAFDictionary() && (prScore = range3.getParsedRangeScore()) != null && !StringUtilities.isEmpty((String)prScore.getAbsentStringForInputNumber()) && (prScore.isPrefixAbsentFromInputNumber() || prScore.isSuffixAbsentFromInputNumber())) {
                this.setAddressNumberScore(this.getAddressNumberScore() * 0.95);
            }
        }
        if (scoringAddress.getParsedAddressNumber() == null && StringUtilities.isEmpty((String)this.getAddressNumber())) {
            this.setAddressNumberScore(1.0);
        }
        ParsedNumber inputNumber = scoringAddress.getParsedAddressNumber();
        if (!this.fromGNAFDictionary() && inputNumber != null && inputNumber.getAddressSuffix() != null && inputNumber.getAddressSuffix().length() > 0) {
            this.setCntAddressNumberFieldsMatched(this.getCntAddressNumberFieldsMatched() + 1);
            this.setAddressNumberScore(this.getCntAddressNumberFieldsMatched() / numFields);
            if (this.getAddressNumberScore() == 1.0) {
                this.setMatchingFlag(8);
            }
        }
        if (this.fromGNAFDictionary() && (range = this.getMatchingOrClosestRange()) != null && inputNumber != null) {
            ParsedNumber candNumber = range.getParsedFrom();
            ParsedNumber scoringNumber = scoringAddress.getParsedAddressNumber();
            if (candNumber != null && scoringNumber != null) {
                String candSuffix;
                String inputSuffix = scoringNumber.getAddressSuffix();
                if (!StringUtilities.equalStrings((String)inputSuffix, (String)(candSuffix = candNumber.getAddressSuffix()))) {
                    this.setMatchingFlag(8);
                }
                String candPrefix = candNumber.getAddressPrefix();
                String inputPrefix = scoringNumber.getAddressPrefix();
                if (!StringUtilities.equalStrings((String)inputPrefix, (String)candPrefix)) {
                    this.setMatchingFlag(8);
                }
            }
        }
    }

    public void checkSegmentSides(ScoringAddress parsedAddress, int side) {
        if (this.isInputNumberNull() || this.getInputNumber() == null) {
            return;
        }
        Segment segment = this.getSegment();
        AUS_Range bestRange = null;
        double bestRangePlaceNameScore = 0.0;
        double placeMinimum = this.getPlaceInRangeMinimum();
        if (segment == null) {
            return;
        }
        ParsedNumber unitNumber = new ParsedNumber(parsedAddress.getUnitValue());
        String unitType = parsedAddress.getUnitType();
        List rangeList = segment.getRanges(side);
        int inputOddEven = this.getInputNumber().isRangeOddEvenBoth();
        int count = rangeList.size();
        for (int i = 0; i < count; ++i) {
            AUS_Range range = (AUS_Range)((Object)rangeList.get(i));
            int oddEven = range.getOddEven();
            if (oddEven != 0 && (oddEven != 2 || inputOddEven == 1) && (oddEven != 1 || inputOddEven == 2)) continue;
            int fieldsMatched = range.isNumberInRange(this.getInputNumber());
            range.findMatchingRangeUnit(parsedAddress);
            double rangePlaceNameScore = parsedAddress.scorePlaceName(range.getPlaceName());
            if (rangePlaceNameScore < placeMinimum) {
                rangePlaceNameScore = 0.0;
            }
            if (fieldsMatched > this.getCntAddressNumberFieldsMatched()) {
                this.setCntAddressNumberFieldsMatched(fieldsMatched);
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (fieldsMatched <= 0 || fieldsMatched != this.getCntAddressNumberFieldsMatched() || !this.newRangeIsBetter(bestRange, range) && (StringUtilities.isEmpty((String)range.getPlaceName()) || !(rangePlaceNameScore > bestRangePlaceNameScore))) continue;
            this.setMatchedRangeNumber(i);
            bestRange = range;
            bestRangePlaceNameScore = rangePlaceNameScore;
            this.setSegmentSide(side);
        }
    }

    private boolean newRangeIsBetter(Range bestRange, Range newRange) {
        if (bestRange == null) {
            return true;
        }
        if (newRange.hasMatchingRangeUnit() && !bestRange.hasMatchingRangeUnit()) {
            return true;
        }
        if (newRange.hasMatchingRangeUnit() && bestRange.hasMatchingRangeUnit() && newRange.getRangeUnitAt(newRange.getMatchingRangeUnit()).getTypeMatched() && !bestRange.getRangeUnitAt(bestRange.getMatchingRangeUnit()).getTypeMatched()) {
            return true;
        }
        if (this.fromGNAFDictionary()) {
            ParsedNumber inputNumber = this.getInputNumber();
            if (inputNumber.compareTo((Object)newRange.getParsedFrom()) == 0 && inputNumber.compareTo((Object)bestRange.getParsedFrom()) != 0) {
                return true;
            }
            if (((AUS_Range)bestRange).isHouseFromLotNumber() != ((AUS_Range)newRange).isHouseFromLotNumber()) {
                return this.m_bInputContainedLotNumber == ((AUS_Range)newRange).isHouseFromLotNumber();
            }
            if (newRange.hasMatchingRangeUnit() && bestRange.hasMatchingRangeUnit()) {
                AUS_RangeUnit newUnit = (AUS_RangeUnit)newRange.getRangeUnitAt(newRange.getMatchingRangeUnit());
                AUS_RangeUnit bestUnit = (AUS_RangeUnit)bestRange.getRangeUnitAt(bestRange.getMatchingRangeUnit());
                ParsedNumber newUnitLevel = newUnit.getLevelNumber();
                ParsedNumber bestUnitLevel = bestUnit.getLevelNumber();
                if (this.m_inputLevelNumber == null || this.m_inputLevelNumber.isEmpty()) {
                    if (newUnitLevel == null && bestUnitLevel != null) {
                        return true;
                    }
                    if (bestUnitLevel == null && newUnitLevel != null) {
                        return false;
                    }
                } else {
                    if (newUnitLevel == null && bestUnitLevel != null) {
                        return false;
                    }
                    if (bestUnitLevel == null && newUnitLevel != null) {
                        return true;
                    }
                    if (newUnitLevel != null && bestUnitLevel != null && !newUnitLevel.equals((Object)bestUnitLevel)) {
                        if (this.m_inputLevelNumber.equals((Object)newUnit.getLevelNumber())) {
                            return true;
                        }
                        if (this.m_inputLevelNumber.equals((Object)bestUnit.getLevelNumber())) {
                            return false;
                        }
                    }
                }
                ParsedRangeScore score1 = bestUnit.getParsedRangeScore();
                ParsedRangeScore score2 = newUnit.getParsedRangeScore();
                if (score1 != null && score2 != null && score2.getNumberFieldsMatched() > score1.getNumberFieldsMatched()) {
                    return true;
                }
            }
        }
        return newRange.computeAddressesInRange() < bestRange.computeAddressesInRange();
    }

    public void findClosestRangeIgnoreParity() {
        long offset;
        AUS_Range range;
        int i;
        if (this.isInputNumberNull() || this.getInputNumber() == null) {
            return;
        }
        long bestOffset = Long.MAX_VALUE;
        Segment segment = this.getSegment();
        int numRanges = segment.getRangeCount(0);
        List theseRanges = segment.getRanges(0);
        boolean curClosestHouseFromLotNumber = false;
        for (i = 0; i < numRanges; ++i) {
            range = (AUS_Range)((Object)theseRanges.get(i));
            offset = range.computeOffsetFromRange(this.getInputNumber());
            if (curClosestHouseFromLotNumber && !range.isHouseFromLotNumber()) {
                this.setClosestRange(i);
                curClosestHouseFromLotNumber = false;
                this.setClosestSegmentSide(0);
                bestOffset = offset;
            } else if (!curClosestHouseFromLotNumber && this.getClosestRangeNumber() >= 0 && range.isHouseFromLotNumber()) continue;
            if (offset < bestOffset) {
                this.setClosestRange(i);
                curClosestHouseFromLotNumber = range.isHouseFromLotNumber();
                this.setClosestSegmentSide(0);
                bestOffset = offset;
                continue;
            }
            if (offset != bestOffset || offset == Long.MAX_VALUE || !this.fromGNAFDictionary() || !this.newRangeIsBetter(this.getMatchingOrClosestRange(), range)) continue;
            this.setClosestRange(i);
            curClosestHouseFromLotNumber = range.isHouseFromLotNumber();
            this.setClosestSegmentSide(0);
            bestOffset = offset;
        }
        numRanges = segment.getRangeCount(1);
        theseRanges = segment.getRanges(1);
        for (i = 0; i < numRanges; ++i) {
            range = (AUS_Range)((Object)theseRanges.get(i));
            offset = range.computeOffsetFromRange(this.getInputNumber());
            if (offset < bestOffset) {
                this.setClosestRange(i);
                this.setClosestSegmentSide(1);
                bestOffset = offset;
                continue;
            }
            if (offset != bestOffset || offset == Long.MAX_VALUE || !this.fromGNAFDictionary() || !this.newRangeIsBetter(this.getMatchingOrClosestRange(), range)) continue;
            this.setClosestRange(i);
            this.setClosestSegmentSide(0);
            bestOffset = offset;
        }
    }

    public void findClosestRange() {
        long offset;
        int oddEven;
        AUS_Range range;
        int i;
        Segment segment = this.getSegment();
        if (this.isInputNumberNull() || this.getInputNumber() == null) {
            if (!this.fromGNAFDictionary() && segment.isHouseSegment()) {
                this.findClosestPointHouseRangeForNoInputNumber();
            }
            return;
        }
        long bestOffset = Long.MAX_VALUE;
        int numRanges = segment.getRangeCount(0);
        List theseRanges = segment.getRanges(0);
        int inputOddEven = this.getInputNumber().isRangeOddEvenBoth();
        boolean curClosestHouseFromLotNumber = false;
        for (i = 0; i < numRanges; ++i) {
            range = (AUS_Range)((Object)theseRanges.get(i));
            oddEven = range.getOddEven();
            if (oddEven != 0 && inputOddEven != oddEven) continue;
            offset = range.computeOffsetFromRange(this.getInputNumber());
            if (curClosestHouseFromLotNumber && !range.isHouseFromLotNumber()) {
                this.setClosestRange(i);
                curClosestHouseFromLotNumber = false;
                this.setClosestSegmentSide(0);
                bestOffset = offset;
            } else if (!curClosestHouseFromLotNumber && this.getClosestRangeNumber() >= 0 && range.isHouseFromLotNumber()) continue;
            if (offset < bestOffset) {
                this.setClosestRange(i);
                curClosestHouseFromLotNumber = range.isHouseFromLotNumber();
                this.setClosestSegmentSide(0);
                bestOffset = offset;
                continue;
            }
            if (offset != bestOffset || offset == Long.MAX_VALUE || !this.fromGNAFDictionary() || !this.newRangeIsBetter(this.getMatchingOrClosestRange(), range)) continue;
            this.setClosestRange(i);
            curClosestHouseFromLotNumber = range.isHouseFromLotNumber();
            this.setClosestSegmentSide(0);
            bestOffset = offset;
        }
        numRanges = segment.getRangeCount(1);
        theseRanges = segment.getRanges(1);
        for (i = 0; i < numRanges; ++i) {
            range = (AUS_Range)((Object)theseRanges.get(i));
            oddEven = range.getOddEven();
            if (oddEven != 0 && inputOddEven != oddEven) continue;
            offset = range.computeOffsetFromRange(this.getInputNumber());
            if (curClosestHouseFromLotNumber && !range.isHouseFromLotNumber()) {
                this.setClosestRange(i);
                curClosestHouseFromLotNumber = false;
                this.setClosestSegmentSide(0);
                bestOffset = offset;
            } else if (!curClosestHouseFromLotNumber && this.getClosestRangeNumber() >= 0 && range.isHouseFromLotNumber()) continue;
            if (offset < bestOffset) {
                this.setClosestRange(i);
                curClosestHouseFromLotNumber = range.isHouseFromLotNumber();
                this.setClosestSegmentSide(1);
                bestOffset = offset;
                continue;
            }
            if (offset != bestOffset || offset == Long.MAX_VALUE || !this.fromGNAFDictionary() || !this.newRangeIsBetter(this.getMatchingOrClosestRange(), range)) continue;
            this.setClosestRange(i);
            curClosestHouseFromLotNumber = range.isHouseFromLotNumber();
            this.setClosestSegmentSide(0);
            bestOffset = offset;
        }
        if (this.fromGNAFDictionary() && this.getClosestRangeNumber() < 0) {
            this.findClosestRangeIgnoreParity();
        }
    }

    private void scoreAltAreaName3(ScoringAddress scoringAddress) {
        Segment segment = this.getSegment();
        if (segment != null && segment.getGeoInfoRecord() != null) {
            this.setHighestAreaName3Score(scoringAddress, ((AUS_GeoInfoRecord)segment.getGeoInfoRecord()).getAreaName3Alternates());
        }
    }

    private void setHighestAreaName3Score(ScoringAddress scoringAddress, String[] altAreaName3) {
        if (altAreaName3 != null) {
            double bestScore = this.getAreaName3Score();
            for (int i = 0; i < altAreaName3.length && bestScore != 1.0; ++i) {
                double areaName3bScore = scoringAddress.scoreAreaName3(altAreaName3[i]);
                if (!(areaName3bScore > bestScore)) continue;
                bestScore = areaName3bScore;
                this.setAreaName3Score(areaName3bScore);
                if (areaName3bScore == 1.0) {
                    this.setMatchingFlag(2);
                    continue;
                }
                this.setMatchingFlag(64);
            }
        }
    }

    public String getFormattedStreetAddress() {
        if (this.m_adjustS4) {
            this.setAddressNumber(this.getInputNumber());
            String newFIA = AUS_AddressUtils.getFormattedStreetAddress((Address)this, false, true, this.fromGNAFDictionary(), this.getUseTypeAbbrevs());
            this.setAddressNumber(null);
            return newFIA;
        }
        AUS_Range range = (AUS_Range)this.getMatchingOrClosestRange();
        if (range != null && range.isHouseFromLotNumber()) {
            this.setAddressNumber(null);
        }
        return AUS_AddressUtils.getFormattedStreetAddress((Address)this, false, true, this.fromGNAFDictionary(), this.getUseTypeAbbrevs());
    }

    private String checkLeftRight(String left, String right) {
        if (left != null && right != null) {
            if (left.equals(right)) {
                return left;
            }
            return right;
        }
        if (left == null) {
            return right;
        }
        return left;
    }

    public String buildPrecisionCode(CandidateAddress cand) {
        boolean bHouseFromLot;
        StringBuffer tempGeoResult = new StringBuffer();
        switch (cand.getLocationPrecision()) {
            case 16: {
                tempGeoResult.append("S8");
                break;
            }
            case 17: {
                tempGeoResult.append("S7");
                break;
            }
            case 1: {
                tempGeoResult.append("S5");
                break;
            }
            case 2: {
                tempGeoResult.append("S4");
                break;
            }
            case 18: {
                tempGeoResult.append("SC");
                break;
            }
            case 10: {
                tempGeoResult.append("SG");
                break;
            }
            case 0: {
                tempGeoResult.append("S0");
                break;
            }
            default: {
                tempGeoResult.append("--");
            }
        }
        AUS_Range range = (AUS_Range)this.getMatchingOrClosestRange();
        boolean bl = bHouseFromLot = range != null && range.isHouseFromLotNumber();
        if (cand.doesAddressNumberMatch() && this.getInputNumber() != null && !this.getInputNumber().isEmpty() && !bHouseFromLot) {
            tempGeoResult.append("H");
        } else {
            tempGeoResult.append("-");
            if (bHouseFromLot) {
                cand.setAddressNumber((ParsedNumber)null);
            }
        }
        if (cand.doesPreDirectionalMatch()) {
            tempGeoResult.append("P");
        } else {
            tempGeoResult.append("-");
        }
        if (this.getMainAddressScore() == 1.0) {
            tempGeoResult.append("N");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.doesThoroughfareTypeMatch()) {
            tempGeoResult.append("T");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.doesPostDirectionalMatch() || this.isMatchingFlagSet(32)) {
            tempGeoResult.append("S");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.doesAreaName3Match() || this.isMatchingFlagSet(32)) {
            tempGeoResult.append("C");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.doesPostalCode1Match()) {
            tempGeoResult.append("Z");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.fromUserDictionary()) {
            tempGeoResult.append("U");
        } else if (this.fromGNAFDictionary()) {
            tempGeoResult.append("G");
        } else {
            tempGeoResult.append("A");
        }
        return tempGeoResult.toString();
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        this.setUseTypeAbbrevs(((AUS_IConstraints)constraints).isReturnStreetTypeAbbrevs());
        int originalRangeRequest = 0;
        AUS_Range range = (AUS_Range)this.getMatchingOrClosestRange();
        if (range != null && range.isHouseFromLotNumber()) {
            this.setAddressNumber(null);
        }
        if (constraints.getMaxRanges() != 0) {
            originalRangeRequest = constraints.getMaxRanges();
            constraints.setMaxRanges(0);
        }
        AUS_StreetCandidateAddress savedStreet = null;
        int currentMatchFlags = this.getMatchingFlags();
        if (this.fromGNAFDictionary()) {
            savedStreet = (AUS_StreetCandidateAddress)this.getStreetCandidateAddress();
            this.setStreetCandidateAddress(savedStreet.createGNAFOutputAddress());
            this.setMatchingFlags(currentMatchFlags);
        }
        CandidateAddress newAddr = super.toCandidateAddress(input, constraints);
        AUS_AddressUtils.adjustCandidateStreetTypes((Address)newAddr, this.fromGNAFDictionary(), ((AUS_IConstraints)constraints).isReturnStreetTypeAbbrevs());
        if (!StringUtilities.isEmpty((String)input.getPlaceName()) && StringUtilities.isEmpty((String)newAddr.getPlaceName())) {
            newAddr.setPlaceName(input.getPlaceName());
        }
        if (originalRangeRequest != 0) {
            newAddr.setNumberOfReturnableRanges(originalRangeRequest);
            constraints.setMaxRanges(originalRangeRequest);
            this.populateCandidateRanges(newAddr, input, (AUS_IConstraints)constraints);
        }
        this.adjustCandidateAddress(input, newAddr);
        AUS_GNAFInfoData gnafInfoData = this.getGNAFInfoData();
        if (gnafInfoData != null) {
            if (!this.isCloseMatch() && StringUtilities.isEmpty((String)input.getMainAddress()) && !StringUtilities.isEmpty((String)input.getPlaceName())) {
                String str = AUS_AddressUtils.getPlaceAndUnitForNonClosePlaceCandidate(this, newAddr);
                if (str != null) {
                    newAddr.setPlaceName(str);
                }
                StringBuffer buf = null;
                if (!StringUtilities.isEmpty((String)this.getUnitType())) {
                    buf = new StringBuffer(this.getUnitType());
                }
                if (!StringUtilities.isEmpty((String)this.getUnitValue())) {
                    if (buf != null) {
                        buf.append(' ');
                    } else {
                        buf = new StringBuffer();
                    }
                    buf.append(this.getUnitValue());
                    buf.append(' ');
                    buf.append(newAddr.getFormattedStreetAddress());
                    newAddr.setFormattedStreetAddress(buf.toString());
                }
            }
            gnafInfoData.addInfoDataIntoAdditionalFields(newAddr);
        }
        if (!StringUtilities.isEmpty((String)this.getLevelNumber())) {
            newAddr.addKeyValueToAdditionalFields("LEVEL_NUMBER", this.getLevelNumber());
        }
        if (!StringUtilities.isEmpty((String)this.getLevelType())) {
            newAddr.addKeyValueToAdditionalFields("LEVEL_TYPE", this.getLevelType());
        }
        if (range != null && !StringUtilities.isEmpty((String)range.getUDOriginalLatitude()) && !StringUtilities.isEmpty((String)range.getUDOriginalLongitude())) {
            newAddr.addKeyValueToAdditionalFields("UD_ORIGINAL_LATITUDE", range.getUDOriginalLatitude());
            newAddr.addKeyValueToAdditionalFields("UD_ORIGINAL_LONGITUDE", range.getUDOriginalLongitude());
        }
        if (savedStreet != null) {
            this.setStreetCandidateAddress(savedStreet);
            this.setMatchingFlags(currentMatchFlags);
        }
        if (!this.fromGNAFDictionary() && newAddr.getPrecisionCode().startsWith("S4") && StringUtilities.isEmpty((String)newAddr.getAddressNumber()) && this.getInputNumber() != null && !StringUtilities.isEmpty((String)this.getInputNumber().getCombinedAddressNumber())) {
            this.m_adjustS4 = true;
            newAddr.setFormattedStreetAddress(this.getFormattedStreetAddress());
            newAddr.setAddressNumber(this.getInputNumber().getCombinedAddressNumber());
        }
        newAddr.addKeyValueToAdditionalFields("INPUT_MATCH_SCORE", String.valueOf(this.inputMatchScore));
        return newAddr;
    }

    private void populateCandidateRanges(CandidateAddress candidate, Address input, AUS_IConstraints constraints) {
        CandidateRange candRange;
        AUS_Range range;
        int i;
        ParsedNumber num = new ParsedNumber(input.getAddressNumber());
        ParsedNumber unitNum = new ParsedNumber(input.getUnitValue());
        AUS_Segment segment = (AUS_Segment)this.getSegment();
        int numLeftRanges = segment.getRangeCount(0);
        int numRightRanges = segment.getRangeCount(1);
        for (i = 0; i < numLeftRanges; ++i) {
            range = (AUS_Range)segment.getRangeAt(i, 0);
            candRange = range.toCandidateRange(num, 1, unitNum, constraints, this.getGNAFOriginalCoordinates(range.getRangeNumber(), constraints), candidate.getAreaName1(), constraints.getMaxRangeUnits());
            candidate.addCandidateRange(candRange);
        }
        for (i = 0; i < numRightRanges; ++i) {
            range = (AUS_Range)segment.getRangeAt(i, 1);
            candRange = range.toCandidateRange(num, 2, unitNum, constraints, this.getGNAFOriginalCoordinates(range.getRangeNumber(), constraints), candidate.getAreaName1(), constraints.getMaxRangeUnits());
            candidate.addCandidateRange(candRange);
        }
    }

    LongPoint getGNAFOriginalCoordinates(int rangeIndex, AUS_IConstraints constraints) {
        if (!constraints.returnGNAFOriginal()) {
            return null;
        }
        if (!this.fromGNAFDictionary()) {
            return null;
        }
        if (!this.getSegment().isHouseSegment()) {
            return null;
        }
        return ((AUS_Segment)this.getSegment()).getOriginalPoint(rangeIndex);
    }

    private void adjustCandidateAddress(Address input, CandidateAddress candidate) throws MapMarkerInternalException {
        boolean bPreDirMatched;
        boolean bl = this.fieldExists(input.getPreDirectional()) ? this.getPreDirectionalScore() == 1.0 : (bPreDirMatched = true);
        boolean bPostDirMatched = this.fieldExists(input.getPostDirectional()) ? this.getPostDirectionalScore() == 1.0 : true;
        boolean bOldPreDirMatched = candidate.doesPreDirectionalMatch();
        boolean bOldPostDirMatched = candidate.doesPostDirectionalMatch();
        if (bPreDirMatched != bOldPreDirMatched || bPostDirMatched != bOldPostDirMatched) {
            candidate.setPreDirectionalMatched(bPreDirMatched);
            candidate.setPostDirectionalMatched(bPostDirMatched);
            HashMap fields = candidate.getAdditionalFields();
            String geoResultCode = (String)fields.get("RESULT_CODE");
            if (geoResultCode.length() == 10) {
                StringBuffer buf = new StringBuffer(geoResultCode.length());
                for (int index = 0; index < geoResultCode.length(); ++index) {
                    if (index == 3 && bPreDirMatched != bOldPreDirMatched) {
                        buf.append(bPreDirMatched ? (char)'P' : '-');
                        continue;
                    }
                    if (index == 6 && bPostDirMatched != bOldPostDirMatched) {
                        buf.append(bPostDirMatched ? (char)'S' : '-');
                        continue;
                    }
                    buf.append(geoResultCode.charAt(index));
                }
                fields.put("RESULT_CODE", buf.toString());
            }
        }
    }

    public void computeScores(ScoringAddress scoringAddress, String charsToIgnore) {
        super.computeScores(scoringAddress, charsToIgnore);
        this.scoreUnitNumber(scoringAddress);
    }

    public void scoreUnitType(ScoringAddress scoringAddress) {
        if (StringUtilities.isEmpty((String)this.getUnitType()) && StringUtilities.isEmpty((String)scoringAddress.getUnitType()) && StringUtilities.isEmpty((String)this.getUnitValue()) && StringUtilities.isEmpty((String)scoringAddress.getUnitValue())) {
            this.setUnitTypeScore(1.0);
        } else if (StringUtilities.isEmpty((String)this.getUnitType()) && !StringUtilities.isEmpty((String)this.getUnitValue()) && !StringUtilities.isEmpty((String)scoringAddress.getUnitValue())) {
            this.setUnitTypeScore(0.95);
        } else {
            super.scoreUnitType(scoringAddress);
        }
    }

    public void scoreUnitNumber(ScoringAddress scoringAddress) {
        double scoringUnitNumber = AUS_StringUtilities.extractDouble(scoringAddress.getUnitValue());
        double unitNumber = AUS_StringUtilities.extractDouble(this.getUnitValue());
        if (scoringUnitNumber == -1.0 && unitNumber == -1.0) {
            this.setUnitNumberScore(1.0);
        }
        if (scoringUnitNumber != -1.0 && unitNumber != -1.0) {
            double score = 0.0;
            score = scoringUnitNumber < unitNumber ? scoringUnitNumber / unitNumber : scoringUnitNumber / (scoringUnitNumber + (scoringUnitNumber - unitNumber));
            this.setUnitNumberScore(score);
        }
    }

    public int compareTo(Object o2) {
        double score2;
        AUS_InternalCandidateAddress cand2 = (AUS_InternalCandidateAddress)((Object)o2);
        boolean bCand1Match = this.isCloseMatch();
        boolean bCand2Match = cand2.isCloseMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        if (bCand1Match && bCand2Match && this.hasDictionaryBonus() != cand2.hasDictionaryBonus()) {
            if (this.hasDictionaryBonus()) {
                return 1;
            }
            return -1;
        }
        bCand1Match = this.isPerfectMatch();
        bCand2Match = cand2.isPerfectMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        double score1 = this.getCombinedAddressScore();
        if (score1 == (score2 = cand2.getCombinedAddressScore())) {
            score1 = this.getCombinedAdditionalFieldScore();
            if (score1 < (score2 = cand2.getCombinedAdditionalFieldScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getPostCode1Score();
            if (score1 < (score2 = cand2.getPostCode1Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getPlaceNameScore();
            if (score1 < (score2 = cand2.getPlaceNameScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getMainAddressScore();
            if (score1 < (score2 = cand2.getMainAddressScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            if (!this.isMatchingFlagSet(2) && cand2.isMatchingFlagSet(2)) {
                return 1;
            }
            if (this.isMatchingFlagSet(2) && !cand2.isMatchingFlagSet(2)) {
                return -1;
            }
            if (!this.isMatchingFlagSet(64) && cand2.isMatchingFlagSet(64)) {
                return 1;
            }
            if (this.isMatchingFlagSet(64) && !cand2.isMatchingFlagSet(64)) {
                return -1;
            }
            if (!this.isMatchingFlagSet(32) && cand2.isMatchingFlagSet(32)) {
                return 1;
            }
            if (this.isMatchingFlagSet(32) && !cand2.isMatchingFlagSet(32)) {
                return -1;
            }
            if (!this.hasMatchingRange() && !cand2.hasMatchingRange()) {
                if (this.hasClosestRange() && cand2.hasClosestRange()) {
                    long cand2Offset;
                    Range cand1Closest = this.getSegment().getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide());
                    Range cand2Closest = cand2.getSegment().getRangeAt(cand2.getClosestRangeNumber(), cand2.getClosestSegmentSide());
                    long cand1Offset = cand1Closest.getRangeOffset();
                    if (cand1Offset < (cand2Offset = cand2Closest.getRangeOffset())) {
                        return 1;
                    }
                    if (cand1Offset > cand2Offset) {
                        return -1;
                    }
                    score1 = this.getUnitNumberScore();
                    if (score1 < (score2 = cand2.getUnitNumberScore())) {
                        return -1;
                    }
                    if (score1 > score2) {
                        return 1;
                    }
                    if (!AUS_StringUtilities.isEmpty(this.getUnitValue()) && !AUS_StringUtilities.isEmpty(cand2.getUnitValue())) {
                        return this.compareAsIntegers(cand2);
                    }
                } else {
                    if (this.hasClosestRange()) {
                        return 1;
                    }
                    if (cand2.hasClosestRange()) {
                        return -1;
                    }
                }
            } else if (this.hasMatchingRange() && cand2.hasMatchingRange()) {
                long cand2AddressesCount;
                long cand1AddressesCount;
                Range cand1Matched = this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
                Range cand2Matched = cand2.getSegment().getRangeAt(cand2.getMatchedRangeNumber(), cand2.getSegmentSide());
                boolean bUnitMatch1 = cand1Matched.hasMatchingRangeUnit();
                boolean bUnitMatch2 = cand2Matched.hasMatchingRangeUnit();
                if (bUnitMatch1 && !bUnitMatch2) {
                    return 1;
                }
                if (!bUnitMatch1 && bUnitMatch2) {
                    return -1;
                }
                if (bUnitMatch1 && bUnitMatch2) {
                    AUS_RangeUnit unit1Matched = (AUS_RangeUnit)cand1Matched.getRangeUnitAt(cand1Matched.getMatchingRangeUnit());
                    AUS_RangeUnit unit2Matched = (AUS_RangeUnit)cand2Matched.getRangeUnitAt(cand2Matched.getMatchingRangeUnit());
                    ParsedNumber unitLevel1 = unit1Matched.getLevelNumber();
                    ParsedNumber unitLevel2 = unit2Matched.getLevelNumber();
                    if (unitLevel1 == null && unitLevel2 != null) {
                        if (this.m_inputLevelNumber == null) {
                            return 1;
                        }
                        return -1;
                    }
                    if (unitLevel1 != null && unitLevel2 == null) {
                        if (this.m_inputLevelNumber == null) {
                            return -1;
                        }
                        return 1;
                    }
                    if (unitLevel1 != null && unitLevel2 != null && this.m_inputLevelNumber != null && !unitLevel1.equals((Object)unitLevel2)) {
                        long dist2;
                        int divisionFactor = 1;
                        long dist1 = this.m_inputLevelNumber.computeDifference(unitLevel1, divisionFactor);
                        if (dist1 < (dist2 = this.m_inputLevelNumber.computeDifference(unitLevel2, divisionFactor))) {
                            return 1;
                        }
                        if (dist1 > dist2) {
                            return -1;
                        }
                    }
                }
                if ((cand1AddressesCount = cand1Matched.computeAddressesInRange()) < (cand2AddressesCount = cand2Matched.computeAddressesInRange())) {
                    return 1;
                }
                if (cand1AddressesCount > cand2AddressesCount) {
                    return -1;
                }
                score1 = this.getUnitNumberScore();
                if (score1 < (score2 = cand2.getUnitNumberScore())) {
                    return -1;
                }
                if (score1 > score2) {
                    return 1;
                }
            } else {
                if (this.hasMatchingRange()) {
                    return 1;
                }
                if (cand2.hasMatchingRange()) {
                    return -1;
                }
            }
            if (this.hasDictionaryBonus() != cand2.hasDictionaryBonus()) {
                if (this.hasDictionaryBonus()) {
                    return 1;
                }
                return -1;
            }
            ParsedNumber lowest1 = this.getLowestHouseNumber();
            ParsedNumber lowest2 = cand2.getLowestHouseNumber();
            if (lowest1 != null && lowest2 != null) {
                if (lowest1.compareTo((Object)lowest2) < 0) {
                    return 1;
                }
                if (lowest1.compareTo((Object)lowest2) > 0) {
                    return -1;
                }
            } else {
                if (lowest1 == null && lowest2 != null) {
                    return 1;
                }
                if (lowest2 == null && lowest1 != null) {
                    return -1;
                }
            }
            if (cand2.getUserDictionaryPriority() - this.getUserDictionaryPriority() > 0) {
                return 1;
            }
            if (cand2.getUserDictionaryPriority() - this.getUserDictionaryPriority() < 0) {
                return -1;
            }
            return 0;
        }
        if (score1 < score2) {
            return -1;
        }
        return 1;
    }

    private int compareAsIntegers(InternalCandidateAddress cand2) {
        StringBuffer thisUnitValue = new StringBuffer(this.getUnitValue());
        StringBuffer compareUnitValue = new StringBuffer(cand2.getUnitValue());
        this.removeChars(thisUnitValue);
        this.removeChars(compareUnitValue);
        String thisUnitString = thisUnitValue.toString();
        String compareUnitString = compareUnitValue.toString();
        if (!AUS_StringUtilities.isEmpty(thisUnitString) && !AUS_StringUtilities.isEmpty(compareUnitString)) {
            try {
                return new Integer(compareUnitString).compareTo(new Integer(thisUnitString));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getUnitValue().compareTo(cand2.getUnitValue());
    }

    private void removeChars(StringBuffer str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            str.deleteCharAt(i);
        }
    }

    public double getUnitNumberScore() {
        return this.unitNumberScore;
    }

    public void setUnitNumberScore(double unitNumberScore) {
        this.unitNumberScore = unitNumberScore;
    }

    public boolean fromGNAFDictionary() {
        return ((AUS_StreetCandidateAddress)this.getStreetCandidateAddress()).getFromGNAFData();
    }

    public AUS_GNAFInfoData getGNAFInfoData() {
        if (this.fromGNAFDictionary() && this.m_gnafInfoData == null && this.getSegment() != null) {
            this.m_gnafInfoData = new AUS_GNAFInfoData(this);
        }
        return this.m_gnafInfoData;
    }

    protected DirectPosition getAddressNumberHousePoint() {
        int housePointNumber;
        if (this.fromGNAFDictionary() && (housePointNumber = this.getGNAFRangeIndex()) >= 0) {
            return this.getSegment().getHousePoint(housePointNumber);
        }
        return super.getAddressNumberHousePoint();
    }

    private int getGNAFRangeIndex() {
        Segment segment = this.getSegment();
        if (this.hasMatchingRange()) {
            return segment.getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide()).getRangeNumber();
        }
        if (this.hasClosestRange()) {
            return segment.getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide()).getRangeNumber();
        }
        if (this.fromGNAFDictionary()) {
            AUS_GNAFInfoData gnafData = this.getGNAFInfoData();
            if (segment != null && gnafData != null && gnafData.getReliability() < 4 && gnafData.getRangeIndex() != -1) {
                Range range = segment.getRangeAt(gnafData.getRangeIndex(), gnafData.getSegmentSide());
                return range.getRangeNumber();
            }
        }
        return -1;
    }

    public void setGeocodedPoint(CandidateAddress candidate, int debugLevel, IConstraints constraints, ResourceBundle errorBundle) {
        AUS_IConstraints AUSConstraints = (AUS_IConstraints)constraints;
        boolean bFoundPoint = false;
        if (!this.fromGNAFDictionary() || AUSConstraints.returnStreetFrontagePoints()) {
            super.setGeocodedPoint(candidate, debugLevel, constraints, errorBundle);
            bFoundPoint = true;
        }
        if (this.fromGNAFDictionary()) {
            AUS_GNAFInfoData gnafInfo;
            if (AUSConstraints.returnGNAFOriginal() || !AUSConstraints.returnStreetFrontagePoints()) {
                LongPoint originalPoint;
                AUS_Segment segment = (AUS_Segment)this.getSegment();
                int rangeNumber = this.getGNAFRangeIndex();
                if (!(rangeNumber < 0 && segment.isHouseSegment() || (originalPoint = segment.getOriginalPoint(rangeNumber)) == null)) {
                    AUS_AddressUtils.OriginalCoordinatesStrings strings = AUS_AddressUtils.createOriginalCoordinatesStrings(originalPoint);
                    if (AUSConstraints.returnGNAFOriginal()) {
                        candidate.addKeyValueToAdditionalFields("ORIGINAL_LONGITUDE", strings.getLongitude());
                        candidate.addKeyValueToAdditionalFields("ORIGINAL_LATITUDE", strings.getLatitude());
                    }
                    if (!AUSConstraints.returnStreetFrontagePoints()) {
                        DirectPosition point = new DirectPosition(Double.parseDouble(strings.getLongitude()), Double.parseDouble(strings.getLatitude()));
                        candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)constraints.getClientCoordinateSystemObject(), (DirectPosition)CoordConvertor.transformPointToWGS84((CoordSys)ORIGINAL_POINTS_COORDSYS, (DirectPosition)point)));
                        candidate.setCoordSysString(MidevConversionUtils.getSRSname((CoordSys)constraints.getClientCoordinateSystemObject()));
                        bFoundPoint = true;
                    }
                }
            }
            if (!bFoundPoint) {
                super.setGeocodedPoint(candidate, debugLevel, constraints, errorBundle);
            }
            if ((gnafInfo = this.getGNAFInfoData()) != null) {
                int precisionCode = 0;
                switch (gnafInfo.getReliability()) {
                    case 1: {
                        precisionCode = 16;
                        break;
                    }
                    case 2: {
                        precisionCode = 16;
                        break;
                    }
                    case 3: {
                        precisionCode = 17;
                        break;
                    }
                    case 4: {
                        precisionCode = 2;
                        break;
                    }
                    case 5: {
                        precisionCode = 10;
                        break;
                    }
                    case 6: {
                        precisionCode = 10;
                        break;
                    }
                }
                candidate.setLocationPrecision(precisionCode);
            }
        }
    }

    private Range getMatchingOrClosestRange() {
        if (this.hasMatchingRange()) {
            return this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
        }
        if (this.hasClosestRange()) {
            return this.getSegment().getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide());
        }
        return null;
    }

    private RangeUnit getMatchingOrClosestRangeUnit(Range bestRange) {
        if (bestRange.hasMatchingRangeUnit()) {
            return bestRange.getRangeUnitAt(bestRange.getMatchingRangeUnit());
        }
        if (bestRange.hasClosestRangeUnit()) {
            return bestRange.getRangeUnitAt(bestRange.getClosestRangeUnit());
        }
        return null;
    }

    public String getPlaceName() {
        Range range = this.getMatchingOrClosestRange();
        if (range != null) {
            String unitPlaceName;
            AUS_RangeUnit unit;
            if (range.hasMatchingRangeUnit()) {
                unit = (AUS_RangeUnit)range.getRangeUnitAt(range.getMatchingRangeUnit());
                unitPlaceName = unit.getPlaceName();
                if (unit.getPID() != 0 || unitPlaceName != null && unitPlaceName.length() > 0) {
                    return unitPlaceName;
                }
            }
            if (range.hasClosestRangeUnit()) {
                unit = (AUS_RangeUnit)range.getRangeUnitAt(range.getClosestRangeUnit());
                unitPlaceName = unit.getPlaceName();
                if (unit.getPID() != 0 || unitPlaceName != null && unitPlaceName.length() > 0) {
                    return unitPlaceName;
                }
            }
        }
        return super.getPlaceName();
    }

    public String getLevelNumber() {
        return this.m_levelNumber;
    }

    public String getLevelType() {
        return this.m_levelType;
    }

    protected String buildRGResultCode(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        AUS_GNAFInfoData gnafInfo;
        if (this.fromGNAFDictionary() && (gnafInfo = this.getGNAFInfoData()) != null) {
            switch (gnafInfo.getReliability()) {
                case 1: 
                case 2: {
                    return "RS8G";
                }
                case 3: {
                    return "RS7G";
                }
                case 4: {
                    return "RS4G";
                }
                case 5: 
                case 6: {
                    return "RSGG";
                }
            }
        }
        return super.buildRGResultCode(location, constraints);
    }

    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        AUS_StreetCandidateAddress savedStreet = null;
        if (this.fromGNAFDictionary()) {
            AUS_Range range = (AUS_Range)this.getMatchingOrClosestRange();
            if (range != null && range.getPID() == 0 && range.getRangeUnitCount() != 0 && this.getMatchingOrClosestRangeUnit(range) == null) {
                range.setMatchingRangeUnit(0);
            }
            savedStreet = (AUS_StreetCandidateAddress)this.getStreetCandidateAddress();
            this.setStreetCandidateAddress(savedStreet.createGNAFOutputAddress());
        }
        ReverseGeocodeCandidateAddress result = super.toCandidateAddress(location, constraints);
        AUS_Constraints tempConstraints = new AUS_Constraints();
        tempConstraints.setReturnStreetTypeAbbrevs(Boolean.parseBoolean(constraints.getCustomString("KEY_RETURN_STREET_TYPE_ABBREVS")));
        AUS_AddressUtils.adjustCandidateStreetTypes((Address)result, this.fromGNAFDictionary(), tempConstraints.isReturnStreetTypeAbbrevs());
        CandidateAddress geocodeCand = this.toCandidateAddress((Address)new AddressImpl(), tempConstraints);
        result.setFormattedStreetAddress(geocodeCand.getFormattedStreetAddress());
        result.setPlaceName(geocodeCand.getPlaceName());
        AUS_GNAFInfoData gnafInfoData = this.getGNAFInfoData();
        if (gnafInfoData != null) {
            gnafInfoData.addInfoDataIntoAdditionalFields(geocodeCand);
        }
        HashMap fields = geocodeCand.getAdditionalFields();
        fields.remove("RESULT_CODE");
        fields.put("RESULT_CODE", result.getAdditionalFieldForKey("RESULT_CODE"));
        result.setAdditionalFields(fields);
        if (savedStreet != null) {
            this.setStreetCandidateAddress(savedStreet);
        }
        return result;
    }

    protected void populateRGRanges(ReverseGeocodeCandidateAddress candidate, ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        if (this.getMatchedRangeNumber() >= 0) {
            candidate.setNumberOfReturnableRanges(1);
            AUS_Range range = (AUS_Range)this.getSegment().getRangeAt(this.getMatchedRangeNumber(), this.getSegmentSide());
            CandidateRange candRange = range.toCandidateRange(this.getParsedAddressNumber(), this.getSegmentSide(), null, null, null, candidate.getAreaName1(), constraints.getMaxRangeUnits());
            candidate.addCandidateRange(candRange);
        }
    }

    protected void adjustReverseGeocodePointConstraints(IConstraints constraints) {
        ((AUS_Constraints)constraints).setReturnStreetFrontagePoints(true);
    }

    public DirectPosition getCenterlineOffsetLocation(DirectPosition point, List<InternalCandidateAddress> candidates, IConstraints constraints) {
        if (this.fromGNAFDictionary()) {
            return null;
        }
        return super.getCenterlineOffsetLocation(point, candidates, constraints);
    }

    public ParsedNumber getInputLevelNumber() {
        return this.m_inputLevelNumber;
    }

    public void setInputLevelNumber(ParsedNumber number) {
        this.m_inputLevelNumber = new ParsedNumber(number);
    }

    protected void setStreetCandidateAddress(StreetCandidateAddress address) {
        super.setStreetCandidateAddress(address);
    }

    protected StreetCandidateAddress getStreetCandidateAddress() {
        return super.getStreetCandidateAddress();
    }

    private ParsedNumber getLowestHouseNumber() {
        ParsedNumber rngLow;
        Range rng;
        int i;
        ParsedNumber lowest = null;
        for (i = 0; i < this.getSegment().getRangeCount(0); ++i) {
            rng = this.getSegment().getRangeAt(i, 0);
            ParsedNumber parsedNumber = rngLow = rng.getRangeDirection() == 1 ? rng.getParsedTo() : rng.getParsedFrom();
            if (lowest != null && rngLow.compareTo((Object)lowest) >= 0) continue;
            lowest = rngLow;
        }
        for (i = 0; i < this.getSegment().getRangeCount(1); ++i) {
            rng = this.getSegment().getRangeAt(i, 1);
            ParsedNumber parsedNumber = rngLow = rng.getRangeDirection() == 1 ? rng.getParsedTo() : rng.getParsedFrom();
            if (lowest != null && rngLow.compareTo((Object)lowest) >= 0) continue;
            lowest = rngLow;
        }
        return lowest;
    }

    private void setUseTypeAbbrevs(boolean flag) {
        this.m_bUseTypeAbbrevs = flag;
    }

    private boolean getUseTypeAbbrevs() {
        return this.m_bUseTypeAbbrevs;
    }
}

