/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.dp.binary.AUS_GeoInfoRecord;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.StringScorer;
import java.util.Locale;

public class AUS_InternalGeographicCandidate
extends InternalGeographicCandidate {
    private static final StringScorer m_scorer = new StringScorer(false, Locale.ENGLISH, null, true);
    private String m_postcode;
    private double m_postcodeScore;
    private boolean m_matchedAlternate = false;

    public AUS_InternalGeographicCandidate() {
        this.setCountry("AUS");
    }

    public StringScorer getStringScorer() {
        return m_scorer;
    }

    public String toString() {
        return "\nAUS_InternalGeographicCandidate:" + super.toString();
    }

    public void setCode(String code) {
        this.m_postcode = code;
    }

    public String getCode() {
        return this.m_postcode;
    }

    public boolean getMatchedAlternate() {
        return this.m_matchedAlternate;
    }

    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) {
        int len;
        CandidateAddress candidate = super.toCandidateAddress(inputAddress, constraints);
        candidate.setPostCode1(this.getCode());
        if (this.getPostCodeScore() == 1.0) {
            candidate.setPostalCode1Matched();
        }
        StringBuffer str = new StringBuffer();
        String tmp = this.getAreaName3();
        if (tmp != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getAreaName1()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getCode()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        candidate.setFormattedLocationAddress(str.toString());
        return candidate;
    }

    public void setPostCodeScore(double postcodeScore) {
        this.m_postcodeScore = postcodeScore;
    }

    public double getPostCodeScore() {
        return this.m_postcodeScore;
    }

    public void scoreCandidate(Address inputAddress, String charsToIgnore) {
        super.scoreCandidate(inputAddress, charsToIgnore);
        this.scorePostCode(inputAddress);
    }

    public void scoreAreaName1(Address inputAddress) {
        String inputAreaName3Upper = null;
        if (inputAddress.getAreaName1() != null) {
            inputAreaName3Upper = inputAddress.getAreaName1().toUpperCase();
        }
        this.setAreaName1Score(this.getStringScorer().scoreString(this.getAreaName1(), inputAreaName3Upper));
    }

    public void scoreAreaName3(Address inputAddress) {
        String[] alternates;
        AUS_GeoInfoRecord geoInfo;
        String inputAreaName3 = inputAddress.getAreaName3();
        String inputAreaName3Upper = null;
        if (inputAreaName3 != null) {
            inputAreaName3Upper = inputAreaName3.toUpperCase();
        }
        double bestScore = m_scorer.scoreString(this.getAreaName3(), inputAreaName3Upper);
        this.setAreaName3Score(bestScore);
        this.m_matchedAlternate = false;
        if (bestScore != 1.0 && (geoInfo = (AUS_GeoInfoRecord)this.getGeoInfoRecord()) != null && (alternates = geoInfo.getAreaName3Alternates()) != null) {
            for (int i = 0; i < alternates.length && bestScore != 1.0; ++i) {
                double score = m_scorer.scoreString(alternates[i], inputAreaName3Upper);
                if (!(score > bestScore)) continue;
                bestScore = score;
                this.setAreaName3Score(score);
                this.m_matchedAlternate = true;
            }
        }
    }

    public void scorePostCode(Address inputAddress) {
        String inStr1 = inputAddress.getPostCode1();
        String inStr2 = this.getCode();
        double totalScore = 0.1;
        if (inStr1 == null || inStr2 == null || inStr1.length() == 0 || inStr2.length() == 0) {
            totalScore = !(inStr1 != null && inStr1.length() != 0 || inStr2 != null && inStr2.length() != 0) ? 1.0 : 0.0;
            this.setPostCodeScore(totalScore);
            return;
        }
        if (inStr1.equalsIgnoreCase(inStr2)) {
            this.setPostCodeScore(1.0);
            return;
        }
        if (inStr1.length() == 3) {
            inStr1 = "0" + inStr1;
        }
        if (inStr2.length() == 3) {
            inStr2 = "0" + inStr2;
        }
        if (inStr1.charAt(0) == inStr2.charAt(0)) {
            totalScore += 0.4;
        }
        if (inStr1.charAt(1) == inStr2.charAt(1)) {
            totalScore += 0.2;
        }
        if (inStr1.charAt(2) == inStr2.charAt(2)) {
            totalScore += 0.2;
        }
        if (inStr1.charAt(3) == inStr2.charAt(3)) {
            totalScore += 0.2;
        }
        this.setPostCodeScore(totalScore);
    }

    public int compareTo(Object o2) {
        AUS_InternalGeographicCandidate candidate2 = (AUS_InternalGeographicCandidate)((Object)o2);
        if (this.isCloseMatch() != candidate2.isCloseMatch()) {
            if (this.isCloseMatch()) {
                return 1;
            }
            return -1;
        }
        if (this.isCloseMatch() && candidate2.isCloseMatch() && this.hasDictionaryBonus() != candidate2.hasDictionaryBonus()) {
            if (this.hasDictionaryBonus()) {
                return 1;
            }
            return -1;
        }
        if (this.getCombinedScore() > candidate2.getCombinedScore()) {
            return 1;
        }
        if (this.getCombinedScore() < candidate2.getCombinedScore()) {
            return -1;
        }
        if (this.getAreaName1Score() > candidate2.getAreaName1Score()) {
            return 1;
        }
        if (this.getAreaName1Score() < candidate2.getAreaName1Score()) {
            return -1;
        }
        if (this.getAreaName2Score() > candidate2.getAreaName2Score()) {
            return 1;
        }
        if (this.getAreaName2Score() < candidate2.getAreaName2Score()) {
            return -1;
        }
        if (this.getAreaName3Score() > candidate2.getAreaName3Score()) {
            return 1;
        }
        if (this.getAreaName3Score() < candidate2.getAreaName3Score()) {
            return -1;
        }
        if (this.getAreaName4Score() > candidate2.getAreaName4Score()) {
            return 1;
        }
        if (this.getAreaName4Score() < candidate2.getAreaName4Score()) {
            return -1;
        }
        if (this.getPostCodeScore() > candidate2.getPostCodeScore()) {
            return 1;
        }
        if (this.getPostCodeScore() < candidate2.getPostCodeScore()) {
            return -1;
        }
        if (this.getCountryScore() > candidate2.getCountryScore()) {
            return 1;
        }
        if (this.getCountryScore() > candidate2.getCountryScore()) {
            return -1;
        }
        if (this.getPrecision() > candidate2.getPrecision()) {
            return 1;
        }
        if (this.getPrecision() < candidate2.getPrecision()) {
            return -1;
        }
        if (this.getMatchedAlternate() != candidate2.getMatchedAlternate()) {
            if (this.getMatchedAlternate()) {
                return -1;
            }
            return 1;
        }
        if (this.hasDictionaryBonus() != candidate2.hasDictionaryBonus()) {
            if (this.hasDictionaryBonus()) {
                return 1;
            }
            return -1;
        }
        return candidate2.getUserDictionaryPriority() - this.getUserDictionaryPriority();
    }
}

