/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_ParsedAddress;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_PostOfficeRecord;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;

public class AUS_InternalPostOfficeCandidateAddress
implements ICandidate {
    private static final String PO_BOX = "PO BOX ";
    private static final double AN3_CUTOFF = 0.75;
    private static final double PERFECT_SCORE = 1.0;
    private AUS_PostOfficeRecord m_record;
    private double m_postCodeScore = 0.0;
    private double m_areaName1Score = 0.0;
    private double m_areaName3Score = 0.0;
    private boolean m_bCloseMatch;

    public AUS_InternalPostOfficeCandidateAddress(AUS_PostOfficeRecord record) {
        this.m_record = record;
    }

    public void score(ScoringAddress addr, IConstraints constraints) {
        this.m_postCodeScore = StringUtilities.isEmpty((String)addr.getPostCode1()) ? 1.0 : addr.scorePostCode1(this.m_record.getPostCode());
        this.m_areaName1Score = StringUtilities.isEmpty((String)addr.getAreaName1()) ? 1.0 : addr.scoreAreaName1(this.m_record.getAreaName1());
        this.m_areaName3Score = StringUtilities.isEmpty((String)addr.getAreaName3()) ? 1.0 : addr.scoreAreaName3(this.m_record.getAreaName3());
        this.determineCloseMatch(addr, constraints);
    }

    private void determineCloseMatch(ScoringAddress addr, IConstraints constraints) {
        if (this.getAreaName1Score() == 1.0 && (this.getPostCodeScore() == 1.0 || this.getAreaName3Score() >= 0.75)) {
            this.setIsCloseMatch(true);
        }
        if (constraints.isMustMatchArea3() && this.getAreaName3Score() < 1.0) {
            this.setIsCloseMatch(false);
        }
        if (constraints.isMustMatchPostalCode() && this.getPostCodeScore() < 1.0) {
            this.setIsCloseMatch(false);
        }
    }

    public double getPostCodeScore() {
        return this.m_postCodeScore;
    }

    public double getAreaName1Score() {
        return this.m_areaName1Score;
    }

    public double getAreaName3Score() {
        return this.m_areaName3Score;
    }

    public void setIsCloseMatch(boolean bCloseMatch) {
        this.m_bCloseMatch = bCloseMatch;
    }

    public boolean isCloseMatch() {
        return this.m_bCloseMatch;
    }

    public CandidateAddress toCandidateAddress(Address addr, IConstraints constraints) {
        CandidateAddress candidate = new CandidateAddress();
        candidate.setCountry("AUS");
        candidate.setCountryMatched();
        candidate.setPostCode1(this.m_record.getPostCode());
        candidate.setAreaName1(this.m_record.getAreaName1());
        candidate.setAreaName3(this.m_record.getAreaName3());
        if (this.m_bCloseMatch) {
            candidate.setCloseMatch();
        }
        if (this.m_postCodeScore == 1.0) {
            candidate.setPostalCode1Matched();
        }
        if (this.m_areaName1Score == 1.0) {
            candidate.setAreaName1Matched();
        }
        if (this.m_areaName3Score == 1.0) {
            candidate.setAreaName3Matched();
        }
        candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)constraints.getClientCoordinateSystemObject(), (DirectPosition)this.m_record.getLocation()));
        candidate.setCoordSysString(MidevConversionUtils.getSRSname((CoordSys)constraints.getClientCoordinateSystemObject()));
        candidate.setLocationPrecision(12);
        candidate.setFormattedStreetAddress(PO_BOX + ((AUS_ParsedAddress)addr).getPOBoxNumber());
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        candidate.setAddressNumberMatched();
        candidate.setPreDirectionalMatched();
        candidate.setStreetNameMatched();
        candidate.setThoroughfareTypeMatched();
        candidate.setPostDirectionalMatched();
        if (this.getPostCodeScore() == 1.0) {
            candidate.setPostalCode1Matched();
        }
        if (this.getAreaName1Score() == 1.0) {
            candidate.setAreaName1Matched();
        }
        if (this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        return candidate;
    }

    private String buildPrecisionCode(CandidateAddress cand) {
        StringBuffer tempGeoResult = new StringBuffer("SP");
        if (cand.doesAddressNumberMatch()) {
            tempGeoResult.append('H');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesPreDirectionalMatch()) {
            tempGeoResult.append('P');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesStreetNameMatch()) {
            tempGeoResult.append('N');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesThoroughfareTypeMatch()) {
            tempGeoResult.append('T');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesPostDirectionalMatch()) {
            tempGeoResult.append('S');
        } else {
            tempGeoResult.append('-');
        }
        if (cand.doesAreaName3Match()) {
            tempGeoResult.append("C");
        } else {
            tempGeoResult.append("-");
        }
        if (cand.doesPostalCode1Match()) {
            tempGeoResult.append("Z");
        } else {
            tempGeoResult.append("-");
        }
        tempGeoResult.append("A");
        cand.addKeyValueToAdditionalFields("LEGACY_RESULT_CODE", tempGeoResult.toString());
        return "B1";
    }

    private String getFormattedLocationAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.m_record.getAreaName3();
        if (tmp != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.m_record.getAreaName1()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.m_record.getPostCode()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }
}

