/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_ParsedAddress;
import com.mapinfo.mapmarker.AUS.parser.AUS_ParsePostAddressRule;
import com.mapinfo.mapmarker.AUS.parser.AUS_ThoroughfareTypes;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CoreParsedInputAddressHelper;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import com.mapinfo.mapmarker.common.ParsedInputAddressUtils;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class AUS_ParsedInputAddressHelper
extends CoreParsedInputAddressHelper {
    public Address AdjustParsedInputAddress(Address parsedAddr) {
        String UnitType;
        String type;
        String LevelType = null;
        ParsedNumber levelNum = null;
        if (parsedAddr instanceof AUS_ParsedAddress) {
            LevelType = ((AUS_ParsedAddress)parsedAddr).getLevelType();
            levelNum = ((AUS_ParsedAddress)parsedAddr).getLevelValue();
        }
        String LevelVal = null;
        if (levelNum != null && levelNum != null && !levelNum.isEmpty()) {
            LevelVal = levelNum.getCombinedAddressNumber();
        }
        Address newAddr = super.AdjustParsedInputAddress(parsedAddr);
        String preAddr = newAddr.getPreAddress();
        String genFld2 = newAddr.getGenericField2();
        newAddr.setPreAddress(null);
        newAddr.setGenericField2(null);
        if (newAddr.getAdditionalFields().containsKey(AUS_ParsePostAddressRule.POSSIBLE_PIA_SL_STATE) && StringUtilities.isEmpty((String)newAddr.getAreaName1())) {
            newAddr.setAreaName1(((ParsedInputAddress)newAddr).getAdditionalFieldForKey(AUS_ParsePostAddressRule.POSSIBLE_PIA_SL_STATE));
        }
        String inMain = (String)newAddr.getAdditionalFields().get("input_mainaddress");
        StringBuilder mainaddr = new StringBuilder();
        String mainstr = newAddr.getMainAddress();
        if (!StringUtilities.isEmpty((String)preAddr)) {
            mainaddr.append(ParsedInputAddressUtils.upperCase((String)preAddr.trim()));
            mainaddr.append(' ');
        }
        if (mainstr != null) {
            mainaddr.append(mainstr);
        }
        newAddr.setMainAddress(mainaddr.toString());
        if (newAddr.hasAdditionalFields() && newAddr.getAdditionalFields().containsKey("POSSIBLE_PLACE_NAME")) {
            if (StringUtilities.isEmpty((String)newAddr.getPlaceName())) {
                newAddr.setPlaceName(((ParsedInputAddress)newAddr).getAdditionalFieldForKey("POSSIBLE_PLACE_NAME"));
            }
            newAddr.getAdditionalFields().remove("POSSIBLE_PLACE_NAME");
        }
        if ((type = AUS_ThoroughfareTypes.lookupProperName(newAddr.getPostThoroughfareType())) != null) {
            newAddr.setPostThoroughfareType(type);
        }
        if ((UnitType = newAddr.getUnitType()) != null && UnitType.equals("U")) {
            newAddr.setUnitType("UNIT");
        }
        if (inMain != null && UnitType == null && inMain.contains("UNIT ") && newAddr.getParsedAddressNumber() != null && !newAddr.getParsedAddressNumber().isEmpty() && newAddr.getParsedAddressNumber().getSuffixNumberExists()) {
            newAddr.setUnitType("UNIT");
            String uv = String.valueOf(newAddr.getParsedAddressNumber().getAddressNumber());
            newAddr.setUnitValue(uv);
            newAddr.setAddressNumber(new ParsedNumber(newAddr.getParsedAddressNumber().getSuffixNumberAsString()));
        }
        String savedUnitType = newAddr.getUnitType();
        String savedUnitVal = newAddr.getUnitValue();
        boolean doLevel = false;
        String levelstr = null;
        if (LevelType != null && LevelVal != null) {
            StringBuilder levelStr = new StringBuilder(AUS_AddressUtils.getFullLevelName(LevelType));
            levelStr.append(" ");
            levelStr.append(LevelVal);
            levelstr = levelStr.toString();
            doLevel = true;
            if (newAddr.getUnitType() != null) {
                newAddr.setUnitType(null);
            }
            if (newAddr.getUnitValue() != null) {
                newAddr.setUnitValue(null);
            }
        } else if (genFld2 != null && genFld2.contains("LEVEL ")) {
            doLevel = true;
            levelstr = genFld2;
            genFld2 = null;
            if (newAddr.getUnitType() != null) {
                newAddr.setUnitType(null);
            }
            if (newAddr.getUnitValue() != null) {
                newAddr.setUnitValue(null);
            }
        }
        newAddr.getAdditionalFields().put("FormattedInputStreet", ParsedInputAddressUtils.makeFormattedInputStreet((Address)newAddr, (boolean)true, (boolean)false, (boolean)true));
        if (genFld2 != null) {
            StringBuilder newFIA = new StringBuilder(genFld2.trim().toUpperCase());
            newFIA.append(' ');
            newFIA.append(((ParsedInputAddress)newAddr).getFormattedInputStreet());
            ((ParsedInputAddress)newAddr).setFormattedInputStreet(newFIA.toString());
        }
        if (doLevel) {
            StringBuilder sb = new StringBuilder();
            if (savedUnitType != null) {
                newAddr.setUnitType(savedUnitType);
                sb.append(savedUnitType);
                sb.append(' ');
            }
            if (savedUnitVal != null) {
                newAddr.setUnitValue(savedUnitVal);
                sb.append(savedUnitVal);
                sb.append(' ');
            }
            sb.append(levelstr);
            sb.append(' ');
            sb.append(newAddr.getAdditionalFields().get("FormattedInputStreet"));
            newAddr.getAdditionalFields().put("FormattedInputStreet", sb.toString().trim());
        }
        return newAddr;
    }
}

