/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.AUS.utils.GNAFAddressClass;
import com.mapinfo.mapmarker.CandidateRangeUnit;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class AUS_RangeUnit
extends RangeUnit {
    private byte m_confidence = (byte)-2;
    private byte m_geocodeLevel = 0;
    private int m_PID;
    private ParsedNumber m_levelNumber;
    private String m_levelType;
    private int m_primaryPID;
    private GNAFAddressClass m_addressClass;
    private String m_parcelID;

    public AUS_RangeUnit() {
    }

    public AUS_RangeUnit(String lowUnit, String highUnit, String unitType) {
        super(lowUnit, highUnit, unitType);
    }

    public AUS_RangeUnit(AUS_RangeUnit unit) {
        super((RangeUnit)unit);
        this.m_confidence = unit.m_confidence;
        this.m_geocodeLevel = unit.m_geocodeLevel;
        this.m_PID = unit.m_PID;
        this.m_primaryPID = unit.m_primaryPID;
        this.m_addressClass = unit.m_addressClass;
        this.m_parcelID = unit.m_parcelID;
    }

    public void setConfidence(byte confidence) {
        this.m_confidence = confidence;
    }

    public boolean hasValidConfidence() {
        return this.m_confidence != -2;
    }

    public byte getConfidence() {
        return this.m_confidence;
    }

    public void setGeocodeLevel(byte geocodeLevel) {
        this.m_geocodeLevel = geocodeLevel;
    }

    public boolean hasValidGeocodeLevel() {
        return this.m_geocodeLevel != 0;
    }

    public byte getGeocodeLevel() {
        return this.m_geocodeLevel;
    }

    public void setPID(int PID) {
        this.m_PID = PID;
    }

    public int getPID() {
        return this.m_PID;
    }

    public void setLevelNumber(ParsedNumber levelNumber) {
        this.m_levelNumber = levelNumber;
    }

    public ParsedNumber getLevelNumber() {
        return this.m_levelNumber;
    }

    public void setLevelType(String levelType) {
        this.m_levelType = levelType;
    }

    public String getLevelType() {
        return this.m_levelType;
    }

    public CandidateRangeUnit toCandidateRangeUnit(ParsedNumber inputUnitNumber) {
        throw new UnsupportedOperationException();
    }

    public CandidateRangeUnit toCandidateRangeUnit(ParsedNumber inputUnitNumber, String areaName1) {
        String levelType;
        CandidateRangeUnit unit = super.toCandidateRangeUnit(inputUnitNumber);
        if (this.m_levelNumber != null) {
            unit.setAdditionalField("LEVEL_NUMBER", (Object)this.m_levelNumber.getCombinedAddressNumber());
        }
        if ((levelType = this.getLevelType()) != null) {
            unit.setAdditionalField("LEVEL_TYPE", (Object)levelType);
        }
        if (this.m_confidence != -2) {
            unit.setAdditionalField("GNAF_CONFIDENCE", (Object)String.valueOf(this.m_confidence));
        }
        if (this.m_geocodeLevel != 0) {
            unit.setAdditionalField("GNAF_GEOCODE_LEVEL", (Object)String.valueOf(this.m_geocodeLevel));
        }
        if (this.m_PID != 0) {
            unit.setAdditionalField("GNAF_PID", (Object)AUS_AddressUtils.buildGnafPIDString(String.valueOf(this.m_PID), areaName1));
        }
        if (this.m_primaryPID != 0) {
            unit.setAdditionalField("GNAF_PRINCIPAL_PID", (Object)AUS_AddressUtils.buildGnafPIDString(String.valueOf(this.m_primaryPID), areaName1));
        }
        if (this.m_addressClass != null) {
            unit.setAdditionalField("GNAF_ADDRESS_CLASS", (Object)this.m_addressClass.getAddressClass());
        }
        if (this.m_parcelID != null) {
            unit.setAdditionalField("GNAF_PARCEL_ID", (Object)this.m_parcelID);
        }
        return unit;
    }

    public boolean matchesLevel(String levelType, ParsedNumber levelValue) {
        String internalType = this.getLevelType();
        boolean bTypesMatch = false;
        if (StringUtilities.isEmpty((String)levelType) && StringUtilities.isEmpty((String)internalType) || "L".equalsIgnoreCase(internalType)) {
            bTypesMatch = true;
        }
        if (!bTypesMatch && !StringUtilities.isEmpty((String)levelType) && StringUtilities.isEmpty((String)internalType) && this.getLevelNumber() != null) {
            internalType = "L";
        }
        if (!bTypesMatch && !StringUtilities.equalStrings((String)levelType, (String)internalType)) {
            return false;
        }
        if ((levelValue == null || levelValue.isEmpty()) && (this.getLevelNumber() == null || this.getLevelNumber().isEmpty())) {
            return true;
        }
        return levelValue != null && !levelValue.isEmpty() && this.getLevelNumber() != null && levelValue.equals((Object)this.getLevelNumber());
    }

    public void setPrimaryPID(int primaryPID) {
        this.m_primaryPID = primaryPID;
    }

    public int getPrimaryPID() {
        return this.m_primaryPID;
    }

    public void setAddressClass(GNAFAddressClass addressClass) {
        this.m_addressClass = addressClass;
    }

    public GNAFAddressClass getAddressClass() {
        return this.m_addressClass;
    }

    public void setParcelID(String parcelID) {
        this.m_parcelID = parcelID;
    }

    public String getParcelID() {
        return this.m_parcelID;
    }
}

