/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_IntersectionRetryManager;
import com.mapinfo.mapmarker.AUS.AUS_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataDictionary;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataManager;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.DictionarySearchOrder;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.address.CoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.CoreStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetIntersectionGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;
import java.util.List;

public class AUS_StreetGeocoder
implements IStreetGeocoder {
    private IStreetGeocoder m_coreStreetGeocoder;

    public AUS_StreetGeocoder(IHandler handler) {
        this.m_coreStreetGeocoder = new CoreStreetGeocoder(handler);
        ((ICoreStreetGeocoder)handler).setStreetIntersectionGeocoder((IStreetIntersectionGeocoder)new CoreStreetIntersectionGeocoder());
        ((ICoreStreetGeocoder)handler).setStreetSingleAddressGeocoder((IStreetSingleAddressGeocoder)new AUS_StreetSingleAddressGeocoder(handler));
    }

    public IRetrievedCandidates getStreetCandidates(Address inputAddress, ScoringAddress scoringAddress, IConstraints constraints, int debugLevel) throws MapMarkerInternalException, MMInternalFatalException {
        return this.m_coreStreetGeocoder.getStreetCandidates(inputAddress, scoringAddress, constraints, debugLevel);
    }

    public List handleStreetMatching(ScoringAddress inputAddress, IRetrievedCandidates candidates, IConstraints constraints, int debugLevel) throws MapMarkerInternalException {
        return this.m_coreStreetGeocoder.handleStreetMatching(inputAddress, candidates, constraints, debugLevel);
    }

    public void geocodeIntersection(IConstraints constraints, int debugLevel, GeocodeResult geocodeResult) throws MapMarkerInternalException, MMInternalFatalException {
        AUS_DataManager dataManager = (AUS_DataManager)constraints.getHandler().getDataManager();
        IDictionarySearchOrder origOrder = constraints.getDictionarySearchOrder();
        if (dataManager.hasGnafDictionary()) {
            IDictionarySearchOrder order = constraints.getDictionarySearchOrder();
            if (order == null) {
                int count = dataManager.getDictionaryCount();
                DictionarySearchOrder newSearchOrder = new DictionarySearchOrder(count);
                for (int index = 0; index < count; ++index) {
                    AUS_DataDictionary dataDict = (AUS_DataDictionary)dataManager.getDictionary(index);
                    newSearchOrder.addDictionary(index + 1, !dataDict.isGNAFDictionary(), null, index + 1, dataDict.isUserDictionary());
                }
                constraints.setDictionarySearchOrder((IDictionarySearchOrder)newSearchOrder);
            } else {
                DictionarySearchOrder newSearchOrder = new DictionarySearchOrder(order);
                for (int index = 0; index < newSearchOrder.getDictionaryCount(); ++index) {
                    AUS_DataDictionary dataDict = (AUS_DataDictionary)dataManager.getDictionary(index);
                    if (!dataDict.isGNAFDictionary()) continue;
                    newSearchOrder.setDictionaryAvailableForSearch(index + 1, false);
                }
                constraints.setDictionarySearchOrder((IDictionarySearchOrder)newSearchOrder);
            }
        }
        boolean bContinue = false;
        IDictionarySearchOrder order = constraints.getDictionarySearchOrder();
        if (order == null) {
            bContinue = true;
        } else {
            for (int index = 0; index < order.getDictionaryCount(); ++index) {
                if (!order.isDictionaryAvailableForSearch(index + 1)) continue;
                bContinue = true;
                break;
            }
        }
        if (!bContinue) {
            geocodeResult.setIntersectionStatus(true);
            geocodeResult.setDataLicensed(true);
            IHandler handler = constraints.getHandler();
            handler.setGeocodeResult(geocodeResult);
            handler.setMatchResults(null);
            constraints.setDictionarySearchOrder(origOrder);
            return;
        }
        String firstAddressNumber = this.stripInputHouseNumbers(((ICoreStreetGeocoder)constraints.getHandler()).getFirstParsedAddress());
        String secondAddressNumber = this.stripInputHouseNumbers(((ICoreStreetGeocoder)constraints.getHandler()).getSecondParsedAddress());
        this.m_coreStreetGeocoder.geocodeIntersection(constraints, debugLevel, geocodeResult);
        this.replaceInputHouseNumbers(((ICoreStreetGeocoder)constraints.getHandler()).getFirstParsedAddress(), firstAddressNumber);
        this.replaceInputHouseNumbers(((ICoreStreetGeocoder)constraints.getHandler()).getSecondParsedAddress(), secondAddressNumber);
        if (geocodeResult.getNumberCloseCandidates() == 0) {
            AUS_IntersectionRetryManager retryManager = new AUS_IntersectionRetryManager();
            retryManager.geocodeWithVariations(constraints, debugLevel, geocodeResult, this);
        }
        constraints.setDictionarySearchOrder(origOrder);
    }

    private void replaceInputHouseNumbers(Address address, String addressNumber) {
        address.setAddressNumber(addressNumber);
    }

    private String stripInputHouseNumbers(Address input) {
        String result = input.getAddressNumber();
        input.setAddressNumber("");
        return result;
    }

    public void geocodeSingleAddress(IConstraints constraints, int debugLevel, GeocodeResult geocodeResult) throws MapMarkerInternalException, MMInternalFatalException {
        this.m_coreStreetGeocoder.geocodeSingleAddress(constraints, debugLevel, geocodeResult);
    }
}

