/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS;

import com.mapinfo.mapmarker.AUS.AUS_Constraints;
import com.mapinfo.mapmarker.AUS.AUS_ParsedAddress;
import com.mapinfo.mapmarker.AUS.parser.AUS_Directionals;
import com.mapinfo.mapmarker.AUS.parser.AUS_ParseMainAddressRule;
import com.mapinfo.mapmarker.AUS.parser.AUS_ThoroughfareTypes;
import com.mapinfo.mapmarker.AUS.parser.AUS_UnitTypes;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.IScoringHelper;
import com.mapinfo.mapmarker.core.address.CoreStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IResettableStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.parser.CoreParser;
import com.mapinfo.mapmarker.utils.EnglishVerbalNumber;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.List;

public class AUS_StreetSingleAddressGeocoder
implements IResettableStreetSingleAddressGeocoder {
    private final IStreetSingleAddressGeocoder m_coreStreetSingleAddressGeocoder = new CoreStreetSingleAddressGeocoder();
    private IHandler m_handler;
    private IScoringHelper m_scoringHandler;
    private boolean m_resetSearchParsedAddress;
    private boolean m_resetParsedAddress;
    private Address m_savedParsedAddress = null;
    Address m_originalParsedAddress;
    private int _currentCase = 0;
    private boolean _resetConstraints;

    public AUS_StreetSingleAddressGeocoder(IHandler handler) {
        this.m_handler = handler;
        this.m_scoringHandler = ((ICoreStreetGeocoder)handler).getScoringHelper();
    }

    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        if (this.m_originalParsedAddress == null) {
            this.m_originalParsedAddress = this.m_scoringHandler.makeParsedAddressCopy(this.m_handler.getParsedAddress());
        }
        boolean tryAgain = false;
        AUS_Constraints ausConstraints = (AUS_Constraints)constraints;
        boolean matchingPOBox = Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false"));
        boolean wasPlacenameOnlySearch = false;
        if (this._resetConstraints) {
            wasPlacenameOnlySearch = constraints.getCustomObject((Object)"search.placename.only") != null;
            constraints.removeCustomObject((Object)"KEY_AUS_ALTERNATE_SOUNDEX_CODES");
            constraints.removeCustomObject((Object)"search.placename.only");
            this._resetConstraints = false;
        }
        if (!wasPlacenameOnlySearch && !ausConstraints.foundSacs() && ausConstraints.isStrictFirstPass()) {
            ausConstraints.setStrictFirstPass(false);
            this.resetRetrys();
            return true;
        }
        boolean exactStreet = false;
        if (this._currentCase == 0) {
            exactStreet = constraints.isMustMatchMainAddress();
        }
        if (this.m_resetParsedAddress) {
            this.m_handler.setParsedAddress(this.m_savedParsedAddress);
            this.m_resetParsedAddress = false;
        }
        if (this.m_resetSearchParsedAddress) {
            ((ICoreStreetGeocoder)this.m_handler).setSearchParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(this.m_handler.getParsedAddress()));
            this.m_resetSearchParsedAddress = false;
        }
        Address spa = ((ICoreStreetGeocoder)this.m_handler).getSearchParsedAddress();
        switch (this._currentCase) {
            case 0: {
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && spa.getPlaceName() != null && spa.getPlaceName().length() > 0) {
                    this._resetConstraints = true;
                    constraints.setCustomObject((Object)"search.placename.only", (Object)Boolean.TRUE);
                    tryAgain = true;
                    break;
                }
            }
            case 1: {
                ++this._currentCase;
                if (!matchingPOBox && !exactStreet) {
                    this._resetConstraints = true;
                    constraints.setCustomObject((Object)"KEY_AUS_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(32));
                    tryAgain = true;
                    break;
                }
            }
            case 2: {
                ++this._currentCase;
                if (!matchingPOBox && !exactStreet) {
                    this._resetConstraints = true;
                    constraints.setCustomObject((Object)"KEY_AUS_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(1));
                    tryAgain = true;
                    break;
                }
            }
            case 3: {
                ++this._currentCase;
                if (!matchingPOBox && !exactStreet) {
                    this._resetConstraints = true;
                    constraints.setCustomObject((Object)"KEY_AUS_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(16));
                    tryAgain = true;
                    break;
                }
            }
            case 4: {
                ++this._currentCase;
                if (!matchingPOBox && !exactStreet) {
                    this._resetConstraints = true;
                    constraints.setCustomObject((Object)"KEY_AUS_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(8));
                    tryAgain = true;
                    break;
                }
            }
            case 5: {
                ++this._currentCase;
                if (!matchingPOBox && !exactStreet) {
                    this._resetConstraints = true;
                    constraints.setCustomObject((Object)"KEY_AUS_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(2));
                    tryAgain = true;
                    break;
                }
            }
            case 6: {
                ++this._currentCase;
                if (!matchingPOBox && !exactStreet) {
                    this._resetConstraints = true;
                    constraints.setCustomObject((Object)"KEY_AUS_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(4));
                    tryAgain = true;
                    break;
                }
            }
            case 7: {
                int pos;
                ++this._currentCase;
                if (!matchingPOBox && !constraints.isMustMatchMainAddress() && spa.getMainAddress() != null && (pos = spa.getMainAddress().indexOf(" AND ")) > 0) {
                    String buf = spa.getMainAddress().substring(0, pos);
                    StringWithTokens toks = new StringWithTokens(buf);
                    String type = AUS_ThoroughfareTypes.lookupPreferredName(toks.getLastToken());
                    if (type != null) {
                        spa.setPostThoroughfareType(type);
                        toks.removeLast();
                    }
                    spa.setMainAddress(toks.toString());
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 8: {
                Address pa;
                int index;
                StringWithTokens tokens;
                ++this._currentCase;
                String type = null;
                String singleLineInput = constraints.getCustomString("ORIGINAL_SINGLE_LINE");
                if (!matchingPOBox && singleLineInput == null || singleLineInput != null && spa.getAreaName3() != null && !constraints.isMustMatchMainAddress() && spa.getMainAddress() != null && spa.getPostThoroughfareType() != null) {
                    tokens = new StringWithTokens(spa.getMainAddress());
                    boolean found = false;
                    index = 0;
                    while (!found && index < tokens.size()) {
                        String tok = tokens.getToken(index);
                        type = AUS_ThoroughfareTypes.lookupPreferredName(tok);
                        if (type != null && index != 0) {
                            found = true;
                            int idx = index;
                            while (idx < tokens.size()) {
                                tokens.remove(idx);
                            }
                            continue;
                        }
                        ++index;
                    }
                    if (found) {
                        spa.setMainAddress(tokens.toString());
                        spa.setPreThoroughfareType(null);
                        spa.setPostThoroughfareType(type);
                        this.m_resetSearchParsedAddress = true;
                        pa = this.m_handler.getParsedAddress();
                        this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                        this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                        this.m_resetParsedAddress = true;
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 9: {
                String stTypeProperName;
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && spa.getGenericField2() != null && spa.getPostThoroughfareType() != null && AUS_ParseMainAddressRule.isBuildingType(stTypeProperName = AUS_ThoroughfareTypes.lookupProperName(spa.getPostThoroughfareType()))) {
                    String mainAddress = spa.getMainAddress();
                    spa.setMainAddress(spa.getGenericField2());
                    spa.setPostThoroughfareType(null);
                    spa.setGenericField2(null);
                    String newMainAddress = AUS_AddressUtils.getFormattedStreetAddress(spa, true, false);
                    AUS_AddressUtils.cleanStreetItemsFromAddress(spa);
                    spa.setMainAddress(newMainAddress);
                    ((CoreParser)((CoreHandler)this.m_handler).getParser()).reparseByIndividualRule(1, spa, constraints);
                    StringBuffer buf = new StringBuffer();
                    buf.append(mainAddress);
                    buf.append(' ');
                    buf.append(stTypeProperName);
                    spa.setGenericField2(buf.toString());
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            case 10: {
                String mainAddress;
                int lastSpaceIndex;
                Address pa;
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && spa.getGenericField2() != null && spa.getPostThoroughfareType() == null && (lastSpaceIndex = (mainAddress = spa.getMainAddress()).lastIndexOf(32)) > 0 && lastSpaceIndex < mainAddress.length() - 1 && AUS_ParseMainAddressRule.isBuildingType(mainAddress.substring(lastSpaceIndex + 1))) {
                    spa.setMainAddress(spa.getGenericField2());
                    spa.setGenericField2(null);
                    String newMainAddress = AUS_AddressUtils.getFormattedStreetAddress(spa, true, false);
                    AUS_AddressUtils.cleanStreetItemsFromAddress(spa);
                    spa.setMainAddress(newMainAddress);
                    ((CoreParser)((CoreHandler)this.m_handler).getParser()).reparseByIndividualRule(1, spa, constraints);
                    spa.setGenericField2(mainAddress);
                    this.m_resetSearchParsedAddress = true;
                    pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            case 11: {
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && spa.getPostThoroughfareType() != null) {
                    StringBuffer buf = new StringBuffer(spa.getMainAddress());
                    buf.append(' ');
                    buf.append(AUS_ThoroughfareTypes.lookupProperName(spa.getPostThoroughfareType()));
                    spa.setMainAddress(buf.toString());
                    spa.setPostThoroughfareType(null);
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            case 12: {
                Address pa;
                int index;
                StringWithTokens tokens;
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && !exactStreet && StringUtilities.isEmpty((String)spa.getAddressNumber())) {
                    tokens = new StringWithTokens(spa.getMainAddress(), " ");
                    String firstToken = tokens.getFirstToken();
                    if (tokens.size() > 0 && firstToken.length() != 0 && Character.isDigit(firstToken.charAt(0))) {
                        for (index = 0; index < firstToken.length() && Character.isDigit(firstToken.charAt(index)); ++index) {
                        }
                        if (index != 0 && index < firstToken.length()) {
                            spa.setAddressNumber(firstToken.substring(0, index));
                            tokens.removeFirst();
                            tokens.insert(0, firstToken.substring(index));
                            spa.setMainAddress(tokens.toStringWithSep(' '));
                            this.m_resetSearchParsedAddress = true;
                            pa = this.m_handler.getParsedAddress();
                            this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                            this.m_resetParsedAddress = true;
                            this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                            tryAgain = true;
                            break;
                        }
                    }
                }
            }
            case 13: {
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && StringUtilities.isEmpty((String)spa.getPostThoroughfareType()) && StringUtilities.isEmpty((String)spa.getPreAddress()) && StringUtilities.isEmpty((String)spa.getGenericField2()) && !StringUtilities.isEmpty((String)spa.getAddressNumber()) && AUS_ThoroughfareTypes.lookupType(spa.getMainAddress()) != null) {
                    String oldMainStreet = spa.getMainAddress();
                    spa.setMainAddress(spa.getAddressNumber());
                    if ("LOT".equals(spa.getUnitType()) && AUS_ParseMainAddressRule.isValidHouseNumber(spa.getUnitValue())) {
                        spa.setAddressNumber(spa.getUnitValue());
                        spa.setUnitValue(null);
                    } else {
                        spa.setAddressNumber((String)null);
                    }
                    spa.setPostThoroughfareType(AUS_ThoroughfareTypes.lookupPreferredName(oldMainStreet));
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            case 14: {
                ++this._currentCase;
                if (!matchingPOBox && !exactStreet && spa.getMainAddress() != null && StringUtilities.isEmpty((String)spa.getPreAddress()) && "THE".equals(spa.getMainAddress()) && StringUtilities.isEmpty((String)spa.getPreThoroughfareType()) && !StringUtilities.isEmpty((String)spa.getPostThoroughfareType())) {
                    spa.setPreAddress(spa.getMainAddress());
                    spa.setMainAddress(AUS_ThoroughfareTypes.lookupProperName(spa.getPostThoroughfareType()));
                    spa.setPostThoroughfareType(null);
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            case 15: {
                Address pa;
                int index;
                StringWithTokens tokens;
                ++this._currentCase;
                if (!matchingPOBox && !StringUtilities.isEmpty((String)spa.getMainAddress()) && !StringUtilities.isEmpty((String)spa.getAddressNumber()) && AUS_ParseMainAddressRule.isValidHouseNumber((tokens = new StringWithTokens(spa.getMainAddress(), " ")).getFirstToken())) {
                    boolean bChanged = false;
                    tokens.insert(0, spa.getAddressNumber());
                    for (index = 0; index < tokens.size(); ++index) {
                        String[] values = AUS_UnitTypes.separateUnitTypeAndValue(tokens.getToken(index));
                        if (values == null) continue;
                        tokens.remove(index);
                        tokens.insert(index, values[0]);
                        tokens.insert(++index, values[1]);
                        bChanged = true;
                    }
                    if (bChanged) {
                        spa.setAddressNumber((String)null);
                        spa.setMainAddress(tokens.toStringWithSep(' '));
                        String newMainAddress = AUS_AddressUtils.getFormattedStreetAddress(spa, true, false);
                        AUS_AddressUtils.cleanStreetItemsFromAddress(spa);
                        spa.setMainAddress(newMainAddress);
                        ((CoreParser)((CoreHandler)this.m_handler).getParser()).reparseByIndividualRule(1, spa, constraints);
                        this.m_resetSearchParsedAddress = true;
                        pa = this.m_handler.getParsedAddress();
                        this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                        this.m_resetParsedAddress = true;
                        this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 16: {
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && StringUtilities.isEmpty((String)spa.getGenericField2()) && spa.getPostThoroughfareType() != null) {
                    boolean bFoundNewStreetType = false;
                    int indexForNewStreetType = Integer.MAX_VALUE;
                    StringWithTokens tokens = new StringWithTokens(spa.getMainAddress(), " ");
                    for (int index = tokens.size() - 1; index >= 0; --index) {
                        if (AUS_ThoroughfareTypes.lookupType(tokens.getToken(index)) == null || index == 0 && StringUtilities.isEmpty((String)spa.getPreDirectional())) continue;
                        bFoundNewStreetType = true;
                        indexForNewStreetType = index;
                        break;
                    }
                    if (bFoundNewStreetType) {
                        boolean bContinue = false;
                        if (indexForNewStreetType == 0) {
                            if (!StringUtilities.isEmpty((String)spa.getPreDirectional())) {
                                spa.setPostThoroughfareType(AUS_ThoroughfareTypes.lookupPreferredName(tokens.getFirstToken()));
                                spa.setMainAddress(AUS_Directionals.getFullName(spa.getPreDirectional()));
                                spa.setPreDirectional(null);
                                bContinue = true;
                            }
                        } else {
                            int delta = tokens.size() - indexForNewStreetType - 1;
                            for (int count = 0; count < delta; ++count) {
                                tokens.removeLast();
                            }
                            spa.setPostThoroughfareType(AUS_ThoroughfareTypes.lookupPreferredName(tokens.getLastToken()));
                            tokens.removeLast();
                            spa.setMainAddress(tokens.toStringWithSep(' '));
                            bContinue = true;
                        }
                        if (bContinue) {
                            this.m_resetSearchParsedAddress = true;
                            Address pa = this.m_handler.getParsedAddress();
                            this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                            this.m_resetParsedAddress = true;
                            this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                            tryAgain = true;
                            break;
                        }
                    }
                }
            }
            case 17: {
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && StringUtilities.isEmpty((String)spa.getGenericField2()) && spa.getPostThoroughfareType() != null) {
                    boolean bFoundNewStreetType = false;
                    int indexForNewStreetType = Integer.MIN_VALUE;
                    StringWithTokens tokens = new StringWithTokens(spa.getMainAddress(), " ");
                    for (int index = tokens.size() - 1; index >= 0; --index) {
                        if (AUS_ThoroughfareTypes.lookupType(tokens.getToken(index)) == null || index == 0) continue;
                        bFoundNewStreetType = true;
                        indexForNewStreetType = index;
                        break;
                    }
                    if (bFoundNewStreetType) {
                        for (int count = 0; count <= indexForNewStreetType; ++count) {
                            tokens.removeFirst();
                        }
                        spa.setMainAddress(tokens.toStringWithSep(' '));
                        this.m_resetSearchParsedAddress = true;
                        Address pa = this.m_handler.getParsedAddress();
                        this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                        this.m_resetParsedAddress = true;
                        this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 18: {
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && StringUtilities.isEmpty((String)spa.getGenericField2()) && !StringUtilities.isEmpty((String)spa.getAddressNumber())) {
                    boolean bFoundNewHouseNumber = false;
                    int indexForNewHouseNumber = Integer.MIN_VALUE;
                    StringWithTokens tokens = new StringWithTokens(spa.getMainAddress(), " ");
                    for (int index = tokens.size() - 1; index >= 0; --index) {
                        boolean isValidHouseNumber;
                        boolean bl = isValidHouseNumber = AUS_ParseMainAddressRule.isValidHouseNumber(tokens.getToken(index)) || AUS_ParseMainAddressRule.isValidHouseNumberRange(tokens.getToken(index));
                        if (!isValidHouseNumber || index == tokens.size() - 1) continue;
                        bFoundNewHouseNumber = true;
                        indexForNewHouseNumber = index;
                        break;
                    }
                    if (bFoundNewHouseNumber) {
                        for (int count = 0; count < indexForNewHouseNumber; ++count) {
                            tokens.removeFirst();
                        }
                        spa.setAddressNumber(tokens.getFirstToken());
                        tokens.removeFirst();
                        spa.setMainAddress(tokens.toStringWithSep(' '));
                        this.m_resetSearchParsedAddress = true;
                        Address pa = this.m_handler.getParsedAddress();
                        this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                        this.m_resetParsedAddress = true;
                        this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 19: {
                String currentMainAddress;
                ++this._currentCase;
                ParsedNumber number = spa.getParsedAddressNumber();
                if (!matchingPOBox && number != null && number.isPureNumeric() && !StringUtilities.isEmpty((String)(currentMainAddress = spa.getMainAddress())) && currentMainAddress.length() > 1 && !Character.isDigit(currentMainAddress.charAt(0)) && currentMainAddress.indexOf(" ") == 1) {
                    StringBuffer numberBuffer = new StringBuffer(number.getCombinedAddressNumber());
                    numberBuffer.append(currentMainAddress.charAt(0));
                    ParsedNumber newNumber = new ParsedNumber(numberBuffer.toString());
                    spa.setMainAddress(currentMainAddress.substring(2));
                    spa.setAddressNumber(newNumber);
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 20: {
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null) {
                    StringWithTokens tokens = new StringWithTokens(spa.getMainAddress(), " ");
                    boolean bContinue = false;
                    if (tokens.size() > 1) {
                        for (int index = 0; index < tokens.size(); ++index) {
                            String token = tokens.getToken(index);
                            AUS_Directionals.Directional dir = AUS_Directionals.getDirectional(token);
                            if (dir == null) continue;
                            tokens.remove(index);
                            if (dir.getFullName().equals(token)) {
                                tokens.insert(index, dir.getAbbreviation());
                            } else {
                                tokens.insert(index, dir.getFullName());
                            }
                            bContinue = true;
                        }
                    }
                    if (bContinue) {
                        spa.setMainAddress(tokens.toStringWithSep(' '));
                        this.m_resetSearchParsedAddress = true;
                        Address pa = this.m_handler.getParsedAddress();
                        this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                        this.m_resetParsedAddress = true;
                        this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 21: {
                ++this._currentCase;
                if (!matchingPOBox && spa.getMainAddress() != null && !StringUtilities.isEmpty((String)spa.getPostThoroughfareType()) && StringUtilities.isEmpty((String)spa.getPostDirectional())) {
                    boolean bContinue;
                    StringWithTokens tokens = new StringWithTokens(spa.getMainAddress(), " ");
                    boolean bl = bContinue = tokens.size() > 1 && AUS_Directionals.isDirection(tokens.getLastToken());
                    if (bContinue) {
                        spa.setPostDirectional(tokens.getLastToken());
                        tokens.removeLast();
                        spa.setMainAddress(tokens.toStringWithSep(' '));
                        this.m_resetSearchParsedAddress = true;
                        Address pa = this.m_handler.getParsedAddress();
                        this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                        this.m_resetParsedAddress = true;
                        this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 22: {
                ++this._currentCase;
                if (!(matchingPOBox || spa.getMainAddress() == null || StringUtilities.isEmpty((String)spa.getPostThoroughfareType()) || StringUtilities.isEmpty((String)spa.getPostDirectional()))) {
                    StringBuffer buf = new StringBuffer(spa.getMainAddress());
                    buf.append(' ');
                    buf.append(AUS_Directionals.getFullName(spa.getPostDirectional()));
                    spa.setPostDirectional(null);
                    spa.setMainAddress(buf.toString());
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            case 23: {
                ++this._currentCase;
                if (!(matchingPOBox || spa.getMainAddress() == null || StringUtilities.isEmpty((String)spa.getPostThoroughfareType()) || StringUtilities.isEmpty((String)spa.getPostDirectional()))) {
                    StringBuffer buf = new StringBuffer(spa.getMainAddress());
                    buf.append(' ');
                    buf.append(AUS_Directionals.getAbbreviation(spa.getPostDirectional()));
                    spa.setPostDirectional(null);
                    spa.setMainAddress(buf.toString());
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            case 24: {
                int last;
                String mainAddress;
                int first;
                ++this._currentCase;
                if (!(matchingPOBox || constraints.isMustMatchInput() || constraints.isMustMatchMainAddress() || spa.getMainAddress() == null || (first = (mainAddress = spa.getMainAddress()).indexOf("(")) <= 0 || (last = mainAddress.lastIndexOf(")")) <= first)) {
                    StringBuffer fixed = new StringBuffer(mainAddress.substring(0, first));
                    if (last != mainAddress.length() - 1) {
                        fixed.append(mainAddress.substring(last));
                    }
                    spa.setMainAddress(fixed.toString().trim());
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            case 25: {
                Address input;
                ++this._currentCase;
                if (!matchingPOBox && !StringUtilities.isEmpty((String)spa.getPostDirectional()) && !StringUtilities.isEmpty((String)spa.getAreaName3()) && !StringUtilities.isEmpty((String)constraints.getCustomString("ORIGINAL_SINGLE_LINE")) && (input = constraints.getHandler().getInputAddress()).getMainAddress().endsWith(spa.getPostDirectional()) && input.getPostAddress() != null && input.getPostAddress().startsWith(spa.getAreaName3())) {
                    StringBuilder sb = new StringBuilder(spa.getPostDirectional());
                    sb.append(' ');
                    sb.append(spa.getAreaName3());
                    spa.setAreaName3(sb.toString());
                    spa.setPostDirectional(null);
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 26: {
                ++this._currentCase;
                if (!matchingPOBox && !StringUtilities.isEmpty((String)spa.getAddressNumber()) && !StringUtilities.isEmpty((String)spa.getUnitValue()) && ("LOT".equals(spa.getUnitType()) || StringUtilities.isEmpty((String)spa.getUnitType())) && AUS_ParseMainAddressRule.isValidHouseNumber(spa.getUnitValue())) {
                    StringBuilder updatedMainAddress = new StringBuilder(spa.getAddressNumber());
                    updatedMainAddress.append(' ');
                    updatedMainAddress.append(spa.getMainAddress());
                    spa.setMainAddress(updatedMainAddress.toString());
                    spa.setAddressNumber(spa.getUnitValue());
                    spa.setUnitValue(null);
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            case 27: {
                String genFld2AsNumber;
                ++this._currentCase;
                AUS_ThoroughfareTypes.KeyInfo typeInfo = AUS_ThoroughfareTypes.lookupType(spa.getMainAddress());
                if (!matchingPOBox && typeInfo != null && StringUtilities.isEmpty((String)spa.getPostThoroughfareType()) && StringUtilities.isEmpty((String)spa.getPreThoroughfareType()) && !StringUtilities.isEmpty((String)spa.getGenericField2()) && StringUtilities.isEmpty((String)spa.getPreAddress()) && !(genFld2AsNumber = EnglishVerbalNumber.convertVerbalToNumericStreetString((String)spa.getGenericField2())).equals(spa.getGenericField2())) {
                    spa.setMainAddress(genFld2AsNumber);
                    spa.setPreAddress(typeInfo.getProperTypeName());
                    spa.setGenericField2(null);
                    this.m_resetSearchParsedAddress = true;
                    Address pa = this.m_handler.getParsedAddress();
                    this.m_savedParsedAddress = new AUS_ParsedAddress(pa);
                    this.m_resetParsedAddress = true;
                    this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(spa));
                    tryAgain = true;
                    break;
                }
            }
            default: {
                if (!ausConstraints.isStrictFirstPass()) break;
                ausConstraints.setStrictFirstPass(false);
                this.resetRetrys();
                tryAgain = true;
            }
        }
        return tryAgain;
    }

    private void resetRetrys() {
        this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(this.m_originalParsedAddress));
        ((ICoreStreetGeocoder)this.m_handler).setSearchParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(this.m_originalParsedAddress));
        this._currentCase = 0;
        this.m_resetSearchParsedAddress = false;
        this.m_resetParsedAddress = false;
        this.m_savedParsedAddress = null;
    }

    public void resetRetryCases(IConstraints constraints) {
        this.m_originalParsedAddress = this.m_scoringHandler.makeParsedAddressCopy(this.m_savedParsedAddress);
        this.resetRetrys();
    }

    public void combineCandidateLists(List savedCandidates, List newCandidates) {
        this.m_coreStreetSingleAddressGeocoder.combineCandidateLists(savedCandidates, newCandidates);
    }

    public void removeDuplicateCandidates(List candidates) {
        this.m_coreStreetSingleAddressGeocoder.removeDuplicateCandidates(candidates);
    }
}

