/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp;

import com.mapinfo.mapmarker.AUS.dp.binary.AUSGeo2SacRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.AUSGeoBase;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.utils.AbbreviationHandler;
import com.mapinfo.mapmarker.utils.FileUtilities;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AUS_Geo2SacDataSourceRecordConvertorImpl
extends Geo2SacDataSourceRecordConvertorImpl {
    private static Pattern m_nestedParenthesisPattern = Pattern.compile("([^\\(]+)\\(([^\\)]+)\\)");
    static final Map ABBREVIATIONS;

    public AUS_Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Soundex soundex) {
        super(dataProperties, soundex);
    }

    public Object convert(IDataSourceRecord source) throws DataCreationException {
        try {
            return super.convert(source);
        }
        catch (IllegalStateException ISEx) {
            throw new DataCreationException(701, (Throwable)ISEx);
        }
    }

    protected MMJGeo2SacRecord makeGeo2SacRecord(int sac, IGeoBase base) {
        return new AUSGeo2SacRecord(sac, (AUSGeoBase)base);
    }

    protected IGeoBase[] makeGeoBases(IGeo2SacDataSourceRecord input) throws DataSourceException {
        HashSet bases = new HashSet();
        if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
            this.addBasesForName(bases, input.getAreaName3());
            if (input.hasAlternateAreaName3() && this.stringExists(input.getAlternateAreaName3())) {
                this.makeAltGeoBases(bases, input.getAlternateAreaName3(), false);
            }
            if (input.hasAlternateAreaName4() && this.stringExists(input.getAlternateAreaName4())) {
                this.makeAltGeoBases(bases, input.getAlternateAreaName4(), true);
            }
            return bases.toArray(new IGeoBase[bases.size()]);
        }
        return null;
    }

    private void addBasesForName(Set bases, String s) {
        List values = AbbreviationHandler.applyAbbreviations((Map)ABBREVIATIONS, (String)s, (String)" ()");
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            bases.add(new AUSGeoBase((MiSoundexKey)this.makeSoundexKey((String)iterator.next())));
        }
    }

    private void makeAltGeoBases(Set bases, String delimitedAlternates, boolean evalNestedParenthesis) {
        StringTokenizer alternates = new StringTokenizer(delimitedAlternates, ";");
        while (alternates.hasMoreTokens()) {
            Matcher m;
            String alt = alternates.nextToken();
            this.addBasesForName(bases, alt);
            if (!evalNestedParenthesis || !(m = m_nestedParenthesisPattern.matcher(alt)).matches()) continue;
            this.addBasesForName(bases, m.group(1));
            this.addBasesForName(bases, m.group(2));
        }
    }

    static {
        HashMap<String, String> map = null;
        try {
            Properties props = FileUtilities.loadProperties((String)"com/mapinfo/mapmarker/AUS/dp/geo2sac_abb.properties");
            map = new HashMap<String, String>();
            for (String string : props.keySet()) {
                String val = props.getProperty(string);
                StringTokenizer tokens = new StringTokenizer(val, ",");
                String abbr = tokens.nextToken().trim();
                boolean bReverse = "true".equalsIgnoreCase(tokens.nextToken().trim());
                map.put(string, abbr);
                if (!bReverse) continue;
                map.put(abbr, string);
            }
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to load geo2sac.abb");
        }
        ABBREVIATIONS = map == null ? null : Collections.unmodifiableMap(map);
    }
}

