/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_Range;
import com.mapinfo.mapmarker.AUS.AUS_RangeUnit;
import com.mapinfo.mapmarker.AUS.AUS_StreetCandidateAddress;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_GeoInfoRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_Segment;
import com.mapinfo.mapmarker.AUS.dp.binary.GNAFOriginalPointsCompressedSegment;
import com.mapinfo.mapmarker.AUS.utils.GNAFAddressClass;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.binary.GenericAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.Properties;

public class AUS_AddressFetcher
extends GenericAddressFetcher {
    private boolean m_bForGNAF;

    public AUS_AddressFetcher(Properties localSettings, Properties localStrings, boolean bForGNAF) {
        super(localSettings, localStrings);
        this.m_bForGNAF = bForGNAF;
    }

    protected StreetCandidateAddress getStreetCandidateAddressObject() {
        return new AUS_StreetCandidateAddress(this.m_bForGNAF);
    }

    protected InternalCandidateAddress makeInternalCandidateAddress(StreetCandidateAddress street, IConstraints constraints) {
        return new AUS_InternalCandidateAddress((Address)street);
    }

    protected void populateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        GenericStreet streetItem;
        super.populateCandidateFromData(cand, street, streetOffset, metadata);
        cand.setCountry("AUS");
        if (this.m_bForGNAF && (streetItem = (GenericStreet)street).hasBlob(33)) {
            ((AUS_StreetCandidateAddress)cand).getGNAFStreetInfo().decode(GenericDataItemAccessor.getDataBlob((int)33, (GenericDataItem)streetItem));
        }
    }

    protected Segment makeSegment() {
        return new AUS_Segment();
    }

    protected void populateSegmentFromData(Segment segment, GenericSegment genericSegment, long segmentOffset, MMJDataFileMetadata metadata, IDataDictionary dict, Segment lastSegment) throws LocalizationException, IOException {
        short postVal;
        super.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
        if (genericSegment.hasShort(32)) {
            postVal = GenericDataItemAccessor.getDataShort((int)32, (GenericDataItem)genericSegment);
            String postCode = StringUtilities.intToLeadingZeroString((int)4, (int)postVal);
            segment.setLeftPostCode1(postCode);
            segment.setRightPostCode1(postCode);
        } else {
            if (genericSegment.hasShort(33)) {
                postVal = GenericDataItemAccessor.getDataShort((int)33, (GenericDataItem)genericSegment);
                segment.setLeftPostCode1(StringUtilities.intToLeadingZeroString((int)4, (int)postVal));
            }
            if (genericSegment.hasShort(34)) {
                postVal = GenericDataItemAccessor.getDataShort((int)34, (GenericDataItem)genericSegment);
                segment.setRightPostCode1(StringUtilities.intToLeadingZeroString((int)4, (int)postVal));
            }
        }
        AUS_GeoInfoRecord geoRecord = null;
        if (genericSegment.hasLong(0)) {
            long geoOffset = GenericDataItemAccessor.getDataLong((int)0, (GenericDataItem)genericSegment);
            IGeoInfoFetcher geoFetcher = dict.getGeoInfoFetcher();
            geoRecord = (AUS_GeoInfoRecord)geoFetcher.getGeoInfoRecord(geoOffset);
            segment.setLeftAreaName1(geoRecord.getAreaName1());
            segment.setRightAreaName1(geoRecord.getAreaName1());
            segment.setLeftAreaName2(geoRecord.getAreaName2());
            segment.setRightAreaName2(geoRecord.getAreaName2());
            segment.setLeftAreaName3(geoRecord.getAreaName3());
            segment.setRightAreaName3(geoRecord.getAreaName3());
            segment.setLeftAreaName4(geoRecord.getAreaName4());
            segment.setRightAreaName4(geoRecord.getAreaName4());
            segment.setGeoInfoRecord((GeoInfoRecord)geoRecord);
        }
        AUS_Segment AUSSegment = (AUS_Segment)segment;
        if (genericSegment.hasInteger(35)) {
            if (geoRecord != null) {
                byte stateNumber = geoRecord.getStateNumber();
                AUSSegment.setMeshBlockId((long)stateNumber * 10000000000L + (long)GenericDataItemAccessor.getDataInt((int)35, (GenericDataItem)genericSegment));
            }
        } else if (genericSegment.hasLong(32)) {
            AUSSegment.setMeshBlockId(GenericDataItemAccessor.getDataLong((int)32, (GenericDataItem)genericSegment));
        }
        if (genericSegment.hasByte(32)) {
            AUSSegment.setReliability(GenericDataItemAccessor.getDataByte((int)32, (GenericDataItem)genericSegment));
        }
        if (genericSegment.hasBlob(32)) {
            AUSSegment.setOriginalPoints(new GNAFOriginalPointsCompressedSegment(GenericDataItemAccessor.getDataBlob((int)32, (GenericDataItem)genericSegment)));
        } else if (genericSegment.hasLong(33) && genericSegment.hasLong(34)) {
            AUSSegment.setOriginalPoint(new LongPoint(GenericDataItemAccessor.getDataLong((int)33, (GenericDataItem)genericSegment), GenericDataItemAccessor.getDataLong((int)34, (GenericDataItem)genericSegment)));
        }
        if (genericSegment.hasBoolean(33)) {
            AUSSegment.setGeoContainment();
        }
        if (genericSegment.hasString(59)) {
            AUSSegment.setGeoFeature(GenericDataItemAccessor.getDataString((int)59, (GenericDataItem)genericSegment));
        }
        if (genericSegment.hasLong(35)) {
            AUSSegment.setSA1(GenericDataItemAccessor.getDataLong((int)35, (GenericDataItem)genericSegment));
        }
    }

    public InternalBrowseAddress makeBrowseAddress(StreetCandidateAddress street, SeekableDataInput file, MMJDataFileMetadata metadata, IDataDictionary dict, IConstraints constraints) throws LocalizationException, IOException, MMJEDataCorruptedException {
        return super.makeBrowseAddress(street, file, metadata, dict, constraints);
    }

    protected Range makeRange() {
        return new AUS_Range(this.m_bForGNAF);
    }

    protected void populateRangeFromData(Range range, GenericRange genericRange, MMJDataFileMetadata metadata, IDataDictionary dict, Range lastRange) throws LocalizationException, IOException {
        super.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
        if (genericRange.hasUnsignedByte(32)) {
            ParsedNumber house = new ParsedNumber((long)GenericDataItemAccessor.getDataUnsignedByte((int)32, (GenericDataItem)genericRange));
            range.setFrom(house);
            range.setTo(house);
        } else if (genericRange.hasUnsignedShort(32)) {
            ParsedNumber house = new ParsedNumber((long)GenericDataItemAccessor.getDataUnsignedShort((int)32, (GenericDataItem)genericRange));
            range.setFrom(house);
            range.setTo(house);
        } else if (genericRange.hasInteger(32)) {
            ParsedNumber house = new ParsedNumber((long)GenericDataItemAccessor.getDataInt((int)32, (GenericDataItem)genericRange));
            range.setFrom(house);
            range.setTo(house);
        } else if (genericRange.hasString(32)) {
            ParsedNumber house = new ParsedNumber(GenericDataItemAccessor.getDataString((int)32, (GenericDataItem)genericRange));
            range.setFrom(house);
            range.setTo(house);
        } else {
            boolean bSecondShort;
            boolean bFirstByte = genericRange.hasUnsignedByte(33);
            boolean bFirstShort = !bFirstByte && genericRange.hasUnsignedShort(33);
            boolean bSecondByte = (bFirstByte || bFirstShort) && genericRange.hasUnsignedByte(34);
            boolean bl = bSecondShort = (bFirstByte || bFirstShort) && !bSecondByte && genericRange.hasUnsignedShort(34);
            if (bSecondByte || bSecondShort) {
                int first = bFirstByte ? GenericDataItemAccessor.getDataUnsignedByte((int)33, (GenericDataItem)genericRange) : GenericDataItemAccessor.getDataUnsignedShort((int)33, (GenericDataItem)genericRange);
                int second = bSecondByte ? GenericDataItemAccessor.getDataUnsignedByte((int)34, (GenericDataItem)genericRange) : GenericDataItemAccessor.getDataUnsignedShort((int)34, (GenericDataItem)genericRange);
                StringBuffer buffer = new StringBuffer();
                buffer.append(first);
                buffer.append('-');
                buffer.append(second);
                ParsedNumber house = new ParsedNumber(buffer.toString());
                range.setFrom(house);
                range.setTo(house);
            }
        }
        AUS_Range AUSRange = (AUS_Range)range;
        if (genericRange.hasByte(32)) {
            AUSRange.setReliability(GenericDataItemAccessor.getDataByte((int)32, (GenericDataItem)genericRange));
        }
        if (genericRange.hasByte(33)) {
            AUSRange.setConfidence(GenericDataItemAccessor.getDataByte((int)33, (GenericDataItem)genericRange));
        }
        if (genericRange.hasByte(34)) {
            AUSRange.setGeocodeLevel(GenericDataItemAccessor.getDataByte((int)34, (GenericDataItem)genericRange));
        }
        if (genericRange.hasInteger(33)) {
            AUSRange.setPID(GenericDataItemAccessor.getDataInt((int)33, (GenericDataItem)genericRange));
        }
        if (genericRange.hasInteger(34)) {
            AUSRange.setPrimaryPID(GenericDataItemAccessor.getDataInt((int)34, (GenericDataItem)genericRange));
        }
        if (genericRange.hasString(35)) {
            AUSRange.setLotNumber(GenericDataItemAccessor.getDataString((int)35, (GenericDataItem)genericRange));
        }
        if (genericRange.hasString(36)) {
            AUSRange.setLotPrefix(GenericDataItemAccessor.getDataString((int)36, (GenericDataItem)genericRange));
        }
        if (genericRange.hasString(37)) {
            AUSRange.setLotSuffix(GenericDataItemAccessor.getDataString((int)37, (GenericDataItem)genericRange));
        }
        if (genericRange.hasBoolean(32)) {
            AUSRange.setHouseFromLotNumber(GenericDataItemAccessor.getDataBool((int)32, (GenericDataItem)genericRange));
        }
        if (genericRange.hasString(33) && genericRange.hasString(34)) {
            AUSRange.setUDOriginalLatitude(GenericDataItemAccessor.getDataString((int)33, (GenericDataItem)genericRange));
            AUSRange.setUDOriginalLongitude(GenericDataItemAccessor.getDataString((int)34, (GenericDataItem)genericRange));
        }
        if (genericRange.hasBoolean(33)) {
            AUSRange.setGeoContainment();
        }
        if (genericRange.hasString(38)) {
            AUSRange.setGeoFeature(GenericDataItemAccessor.getDataString((int)38, (GenericDataItem)genericRange));
        }
        if (genericRange.hasByte(35)) {
            AUSRange.setAddressClass(GNAFAddressClass.values()[GenericDataItemAccessor.getDataByte((int)35, (GenericDataItem)genericRange)]);
        }
        if (genericRange.hasString(39)) {
            AUSRange.setParcelID(GenericDataItemAccessor.getDataString((int)39, (GenericDataItem)genericRange));
        }
    }

    protected RangeUnit makeRangeUnit() {
        return new AUS_RangeUnit();
    }

    protected void populateRangeUnitFromData(RangeUnit unit, GenericUnit genericUnit, MMJDataFileMetadata metadata, IDataDictionary dict, RangeUnit lastUnit) throws LocalizationException, IOException {
        super.populateRangeUnitFromData(unit, genericUnit, metadata, dict, lastUnit);
        if (genericUnit.hasUnsignedByte(32)) {
            short number = GenericDataItemAccessor.getDataUnsignedByte((int)32, (GenericDataItem)genericUnit);
            unit.setLowUnit((int)number);
            unit.setHighUnit((int)number);
        } else if (genericUnit.hasUnsignedShort(32)) {
            int number = GenericDataItemAccessor.getDataUnsignedShort((int)32, (GenericDataItem)genericUnit);
            unit.setLowUnit(number);
            unit.setHighUnit(number);
        } else if (genericUnit.hasInteger(32)) {
            int number = GenericDataItemAccessor.getDataInt((int)32, (GenericDataItem)genericUnit);
            unit.setLowUnit(number);
            unit.setHighUnit(number);
        } else if (genericUnit.hasString(32)) {
            String number = GenericDataItemAccessor.getDataString((int)32, (GenericDataItem)genericUnit);
            unit.setLowUnit(number);
            unit.setHighUnit(number);
        }
        AUS_RangeUnit AUSUnit = (AUS_RangeUnit)unit;
        if (genericUnit.hasByte(32)) {
            AUSUnit.setConfidence(GenericDataItemAccessor.getDataByte((int)32, (GenericDataItem)genericUnit));
        }
        if (genericUnit.hasByte(33)) {
            AUSUnit.setGeocodeLevel(GenericDataItemAccessor.getDataByte((int)33, (GenericDataItem)genericUnit));
        }
        if (genericUnit.hasInteger(33)) {
            AUSUnit.setPID(GenericDataItemAccessor.getDataInt((int)33, (GenericDataItem)genericUnit));
        }
        if (genericUnit.hasInteger(35)) {
            AUSUnit.setPrimaryPID(GenericDataItemAccessor.getDataInt((int)35, (GenericDataItem)genericUnit));
        }
        String levelPrefix = null;
        if (genericUnit.hasByte(34)) {
            levelPrefix = String.valueOf((char)GenericDataItemAccessor.getDataByte((int)34, (GenericDataItem)genericUnit));
        } else if (genericUnit.hasString(34)) {
            levelPrefix = GenericDataItemAccessor.getDataString((int)34, (GenericDataItem)genericUnit);
        }
        int levelNumber = 0;
        if (genericUnit.hasUnsignedByte(33)) {
            levelNumber = GenericDataItemAccessor.getDataUnsignedByte((int)33, (GenericDataItem)genericUnit);
        } else if (genericUnit.hasUnsignedShort(33)) {
            levelNumber = GenericDataItemAccessor.getDataUnsignedShort((int)33, (GenericDataItem)genericUnit);
        } else if (genericUnit.hasInteger(34)) {
            levelNumber = GenericDataItemAccessor.getDataInt((int)34, (GenericDataItem)genericUnit);
        }
        String levelSuffix = null;
        if (genericUnit.hasByte(35)) {
            levelSuffix = String.valueOf((char)GenericDataItemAccessor.getDataByte((int)35, (GenericDataItem)genericUnit));
        } else if (genericUnit.hasString(35)) {
            levelSuffix = GenericDataItemAccessor.getDataString((int)35, (GenericDataItem)genericUnit);
        }
        ParsedNumber level = null;
        if (levelPrefix != null || levelSuffix != null) {
            if (levelPrefix != null && levelNumber == 0 && levelSuffix == null) {
                level = new ParsedNumber(levelPrefix);
            } else if (levelPrefix == null && levelNumber == 0 && levelSuffix != null) {
                level = new ParsedNumber(levelSuffix);
            } else {
                StringBuffer levelBuffer = new StringBuffer();
                if (levelPrefix != null) {
                    levelBuffer.append(levelPrefix);
                }
                if (levelNumber != 0) {
                    levelBuffer.append(levelNumber);
                }
                if (levelSuffix != null) {
                    levelBuffer.append(levelSuffix);
                }
                level = new ParsedNumber(levelBuffer.toString());
            }
        } else if (levelNumber != 0) {
            level = new ParsedNumber((long)levelNumber);
        }
        AUSUnit.setLevelNumber(level);
        if (genericUnit.hasByte(36)) {
            AUSUnit.setLevelType(String.valueOf((char)GenericDataItemAccessor.getDataByte((int)36, (GenericDataItem)genericUnit)));
        } else if (genericUnit.hasString(33)) {
            AUSUnit.setLevelType(GenericDataItemAccessor.getDataString((int)33, (GenericDataItem)genericUnit));
        }
        if (genericUnit.hasByte(37)) {
            AUSUnit.setAddressClass(GNAFAddressClass.values()[GenericDataItemAccessor.getDataByte((int)37, (GenericDataItem)genericUnit)]);
        }
        if (genericUnit.hasString(36)) {
            AUSUnit.setParcelID(GenericDataItemAccessor.getDataString((int)36, (GenericDataItem)genericUnit));
        }
    }
}

