/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.AUS.dp.binary.AUS_AbstractAuxillaryDataWriter;
import com.mapinfo.mapmarker.AUS.dp.tab.AUS_TabPostOfficeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import java.util.Properties;

public class AUS_TabAuxillaryDataWriter
extends AUS_AbstractAuxillaryDataWriter {
    private static final String POSTOFFICE_INPUT_TABLE_KEY = "postOffice_inputTable";

    public AUS_TabAuxillaryDataWriter(Properties props) {
        super(props);
    }

    @Override
    protected IDataSource getDataSource(Properties props) throws DataCreationException {
        TabFileDataSource postOfficeDataSource = new TabFileDataSource(this.m_properties);
        try {
            String[] dataSourceArgs = new String[]{this.getProperty(POSTOFFICE_INPUT_TABLE_KEY)};
            postOfficeDataSource.open(dataSourceArgs);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(2001, (Throwable)DSEx);
        }
        return postOfficeDataSource;
    }

    @Override
    protected IDataSourceRecord getNextDataSourceRecord(IDataSource source) throws DataCreationException {
        try {
            TabDataSourceRecordObjects objects = (TabDataSourceRecordObjects)source.getNextDataSourceRecordObjects();
            if (objects == null) {
                return null;
            }
            return new AUS_TabPostOfficeDataSourceRecord(objects);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(2001, (Throwable)DSEx);
        }
    }
}

