/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary;

import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GNAFStreetInfo {
    private static final int HAS_MAIN_ADDRESS = 1;
    private static final int HAS_TYPE = 2;
    private static final int HAS_SUFFIX = 4;
    private static final int TYPE_ATTACHED = 8;
    private static final int DIR_ATTACHED = 16;
    private static final int TYPE_ABBREV = 32;
    private static final int TYPE_IS_SUFFIX = 64;
    private static final int GENERIC_2_NOT_SUFFIX = 128;
    private String m_originalMainAddress;
    private boolean m_bStreetTypeAttached;
    private String m_streetType;
    private boolean m_bPostDirectionalAttached;
    private String m_streetSuffix;
    private boolean m_bTypeIsSuffix;
    private boolean m_bGenericField2NotSuffix;
    private String m_streetTypeAbbreviation;

    public void setOriginalMainAddress(String originalMainAddress) {
        this.m_originalMainAddress = originalMainAddress;
    }

    public String getOriginalMainAddress() {
        return this.m_originalMainAddress;
    }

    public void setStreetTypeAttached() {
        this.m_bStreetTypeAttached = true;
    }

    public boolean getStreetTypeAttached() {
        return this.m_bStreetTypeAttached;
    }

    public void setStreetType(String streetType) {
        this.m_streetType = streetType;
    }

    public String getStreetType() {
        return this.m_streetType;
    }

    public void setPostDirectionalAttached() {
        this.m_bPostDirectionalAttached = true;
    }

    public boolean getPostDirectionalAttached() {
        return this.m_bPostDirectionalAttached;
    }

    public void setStreetSuffix(String suffix) {
        this.m_streetSuffix = suffix;
    }

    public String getStreetSuffix() {
        return this.m_streetSuffix;
    }

    public void setTypeIsSuffix() {
        this.m_bTypeIsSuffix = true;
    }

    public boolean getTypeIsSuffix() {
        return this.m_bTypeIsSuffix;
    }

    public void setGenericField2NotSuffix() {
        this.m_bGenericField2NotSuffix = true;
    }

    public boolean getGenericField2NotSuffix() {
        return this.m_bGenericField2NotSuffix;
    }

    public void setStreetTypeAbbreviation(String streetTypeAbbreviation) {
        this.m_streetTypeAbbreviation = streetTypeAbbreviation;
    }

    public String getStreetTypeAbbreviation() {
        return this.m_streetTypeAbbreviation;
    }

    public boolean getSpecialHandlingRequired() {
        return this.m_bPostDirectionalAttached || this.m_bStreetTypeAttached || !StringUtilities.isEmpty((String)this.m_originalMainAddress) || !StringUtilities.isEmpty((String)this.m_streetSuffix) || !StringUtilities.isEmpty((String)this.m_streetType) || !StringUtilities.isEmpty((String)this.m_streetTypeAbbreviation) || this.m_bTypeIsSuffix || this.m_bGenericField2NotSuffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GNAFStreetInfo that = (GNAFStreetInfo)o;
        if (this.m_bGenericField2NotSuffix != that.m_bGenericField2NotSuffix) {
            return false;
        }
        if (this.m_bPostDirectionalAttached != that.m_bPostDirectionalAttached) {
            return false;
        }
        if (this.m_bStreetTypeAttached != that.m_bStreetTypeAttached) {
            return false;
        }
        if (this.m_bTypeIsSuffix != that.m_bTypeIsSuffix) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)this.m_originalMainAddress, (String)that.m_originalMainAddress)) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)this.m_streetSuffix, (String)that.m_streetSuffix)) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)this.m_streetType, (String)that.m_streetType)) {
            return false;
        }
        return StringUtilities.equalStrings((String)this.m_streetTypeAbbreviation, (String)that.m_streetTypeAbbreviation);
    }

    public int hashCode() {
        int result = this.m_originalMainAddress != null ? this.m_originalMainAddress.hashCode() : 0;
        result = 31 * result + (this.m_bStreetTypeAttached ? 1 : 0);
        result = 31 * result + (this.m_streetType != null ? this.m_streetType.hashCode() : 0);
        result = 31 * result + (this.m_bPostDirectionalAttached ? 1 : 0);
        result = 31 * result + (this.m_streetSuffix != null ? this.m_streetSuffix.hashCode() : 0);
        result = 31 * result + (this.m_bTypeIsSuffix ? 1 : 0);
        result = 31 * result + (this.m_bGenericField2NotSuffix ? 1 : 0);
        result = 31 * result + (this.m_streetTypeAbbreviation != null ? this.m_streetTypeAbbreviation.hashCode() : 0);
        return result;
    }

    public byte[] encode() throws IOException {
        if (!this.getSpecialHandlingRequired()) {
            throw new IllegalStateException();
        }
        int mask = 0;
        if (!StringUtilities.isEmpty((String)this.m_originalMainAddress)) {
            mask |= 1;
        }
        if (!StringUtilities.isEmpty((String)this.m_streetType)) {
            mask |= 2;
        }
        if (!StringUtilities.isEmpty((String)this.m_streetSuffix)) {
            mask |= 4;
        }
        if (this.m_bStreetTypeAttached) {
            mask |= 8;
        }
        if (this.m_bPostDirectionalAttached) {
            mask |= 0x10;
        }
        if (!StringUtilities.isEmpty((String)this.m_streetTypeAbbreviation)) {
            mask |= 0x20;
        }
        if (this.m_bTypeIsSuffix) {
            mask |= 0x40;
        }
        if (this.m_bGenericField2NotSuffix) {
            mask |= 0x80;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream outputSteam = new DataOutputStream(stream);
        outputSteam.writeByte(mask);
        if (this.bitSet(mask, 1)) {
            outputSteam.writeUTF(this.m_originalMainAddress);
        }
        if (this.bitSet(mask, 2)) {
            outputSteam.writeUTF(this.m_streetType);
        }
        if (this.bitSet(mask, 4)) {
            outputSteam.writeUTF(this.m_streetSuffix);
        }
        if (this.bitSet(mask, 32)) {
            outputSteam.writeUTF(this.m_streetTypeAbbreviation);
        }
        return stream.toByteArray();
    }

    public void decode(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException();
        }
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
        int mask = stream.readUnsignedByte();
        if (this.bitSet(mask, 1)) {
            this.m_originalMainAddress = stream.readUTF();
        }
        if (this.bitSet(mask, 2)) {
            this.m_streetType = stream.readUTF();
        }
        if (this.bitSet(mask, 4)) {
            this.m_streetSuffix = stream.readUTF();
        }
        if (this.bitSet(mask, 32)) {
            this.m_streetTypeAbbreviation = stream.readUTF();
        }
        this.m_bStreetTypeAttached = this.bitSet(mask, 8);
        this.m_bPostDirectionalAttached = this.bitSet(mask, 16);
        this.m_bTypeIsSuffix = this.bitSet(mask, 64);
        this.m_bGenericField2NotSuffix = this.bitSet(mask, 128);
    }

    private boolean bitSet(int mask, int bit) {
        return (mask & bit) != 0;
    }
}

