/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary.gnaf;

import com.mapinfo.mapmarker.AUS.utils.GNAFAddressClass;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class AUS_GNAFMMJRangeUnitRecord
extends MMJRangeUnitRecord {
    private byte m_confidence = (byte)-2;
    private byte m_geocodeLevel = (byte)-1;
    private String m_PID;
    private String m_levelType;
    private int m_levelNumber;
    private String m_levelPrefix;
    private String m_levelSuffix;
    private String m_primaryPID;
    private GNAFAddressClass m_addressClass;
    private String m_parcelID;

    public void setConfidence(byte confidence) {
        this.m_confidence = confidence;
    }

    public boolean hasValidConfidence() {
        return this.m_confidence != -2;
    }

    public byte getConfidence() {
        return this.m_confidence;
    }

    public void setGeocodeLevel(byte level) {
        this.m_geocodeLevel = level;
    }

    public boolean hasValidGeocodeLevel() {
        return this.m_geocodeLevel != -1;
    }

    public byte getGeocodeLevel() {
        return this.m_geocodeLevel;
    }

    public void setPID(String PID) {
        this.m_PID = PID;
    }

    public String getPID() {
        return this.m_PID;
    }

    public boolean hasPID() {
        return this.m_PID != null;
    }

    public int getUniquePIDValue() throws NumberFormatException {
        return Integer.parseInt(this.m_PID.substring(5));
    }

    public void setLevelType(String levelType) {
        this.m_levelType = this.emptyToNull(levelType);
    }

    public boolean hasLevelType() {
        return this.m_levelType != null;
    }

    public String getLevelType() {
        return this.m_levelType;
    }

    public void setLevelNumber(int levelNumber) {
        this.m_levelNumber = levelNumber;
    }

    public boolean hasLevelNumber() {
        return this.m_levelNumber != 0;
    }

    public int getLevelNumber() {
        return this.m_levelNumber;
    }

    public void setLevelPrefix(String levelPrefix) {
        this.m_levelPrefix = this.emptyToNull(levelPrefix);
    }

    public boolean hasLevelPrefix() {
        return this.m_levelPrefix != null;
    }

    public String getLevelPrefix() {
        return this.m_levelPrefix;
    }

    public void setLevelSuffix(String levelSuffix) {
        this.m_levelSuffix = this.emptyToNull(levelSuffix);
    }

    public boolean hasLevelSuffix() {
        return this.m_levelSuffix != null;
    }

    public String getLevelSuffix() {
        return this.m_levelSuffix;
    }

    public boolean hasLevelInfo() {
        return this.hasLevelType() || this.hasLevelNumberInfo();
    }

    public boolean hasLevelNumberInfo() {
        return this.hasLevelNumber() || this.hasLevelPrefix() || this.hasLevelSuffix();
    }

    private String emptyToNull(String str) {
        if (str != null) {
            if (str.length() == 0) {
                return null;
            }
            if ((str = str.trim()).length() == 0) {
                return null;
            }
        }
        return str;
    }

    public void setPrimaryPID(String primaryPID) {
        this.m_primaryPID = !StringUtilities.isEmpty((String)primaryPID) ? primaryPID : null;
    }

    public boolean hasPrimaryPID() {
        return this.m_primaryPID != null;
    }

    public String getPrimaryPID() {
        return this.m_primaryPID;
    }

    public int getUniquePrimaryPIDValue() throws NumberFormatException {
        return Integer.parseInt(this.m_primaryPID.substring(5));
    }

    public void setAddressClass(GNAFAddressClass addressClass) {
        this.m_addressClass = addressClass;
    }

    public GNAFAddressClass getAddressClass() {
        return this.m_addressClass;
    }

    public void setParcelID(String parcelID) {
        this.m_parcelID = StringUtilities.isEmpty((String)parcelID) ? null : parcelID;
    }

    public String getParcelID() {
        return this.m_parcelID;
    }
}

