/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary.gnaf;

import com.mapinfo.mapmarker.AUS.dp.binary.GNAFStreetInfo;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJSegmentRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import java.util.Iterator;

public class AUS_GNAFMultiSegmentStreet
extends MultiSegmentStreet {
    private MMJSegmentComparer m_segmentComparer;
    private GNAFStreetInfo m_info;

    public AUS_GNAFMultiSegmentStreet(MMJStreetRecord street, MMJSegmentComparer segmentComparer) {
        super(street, segmentComparer);
        this.m_segmentComparer = segmentComparer;
        this.m_info = ((AUS_GNAFMMJStreetRecord)street).getGNAFStreetInfo();
    }

    public GNAFStreetInfo getGNAFStreetInfo() {
        return this.m_info;
    }

    public boolean areSameStreet(MMJStreetRecord that) {
        return super.areSameStreet(that) && this.m_info.equals(((AUS_GNAFMMJStreetRecord)that).getGNAFStreetInfo());
    }

    public void addSegment(MMJSegmentRecord segment) {
        AUS_GNAFMMJSegmentRecord previousSegment = this.getCombinableSegment((AUS_GNAFMMJSegmentRecord)segment);
        if (previousSegment == null) {
            this.getSegments().add(segment);
        } else {
            this.combine((AUS_GNAFMMJSegmentRecord)segment, previousSegment);
        }
    }

    private AUS_GNAFMMJSegmentRecord getCombinableSegment(AUS_GNAFMMJSegmentRecord segment) {
        boolean parcelSegment = !segment.hasValidReliability();
        for (AUS_GNAFMMJSegmentRecord previousSegment : this.getSegments()) {
            if (!(parcelSegment && !previousSegment.hasValidReliability() ? this.m_segmentComparer.segmentsCompare((MMJSegmentRecord)segment, (MMJSegmentRecord)previousSegment) : !parcelSegment && previousSegment.hasValidReliability() && segment.getReliability() == previousSegment.getReliability() && segment.getPoints().equals(previousSegment.getPoints()) && this.m_segmentComparer.segmentsCompare((MMJSegmentRecord)segment, (MMJSegmentRecord)previousSegment))) continue;
            return previousSegment;
        }
        return null;
    }

    private void combine(AUS_GNAFMMJSegmentRecord segment, AUS_GNAFMMJSegmentRecord previousSegment) {
        Iterator rangeIterator = segment.getRanges().iterator();
        while (rangeIterator.hasNext()) {
            previousSegment.addRange((MMJRangeRecord)rangeIterator.next());
        }
    }
}

