/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary.gnaf;

import com.mapinfo.mapmarker.AUS.AUS_CandidateConstants;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_GenericStreetBuilder;
import com.mapinfo.mapmarker.AUS.dp.binary.GNAFOriginalPointsCompressedSegment;
import com.mapinfo.mapmarker.AUS.dp.binary.GNAFStreetInfo;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeUnitRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJSegmentRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMultiSegmentStreet;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.LongPoint;
import java.io.IOException;
import java.util.List;

public class AUS_GNAFStreetBuilder
extends AUS_GenericStreetBuilder {
    protected void populateLocalStreetInfo(MultiSegmentStreet record, IDataFileDataItem street, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        super.populateLocalStreetInfo(record, street, metadata);
        GNAFStreetInfo info = ((AUS_GNAFMultiSegmentStreet)record).getGNAFStreetInfo();
        if (info.getSpecialHandlingRequired()) {
            try {
                ((GenericStreet)street).putBlob(33, info.encode());
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate local street info.");
                DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
                throw new DataCreationException(101, (Throwable)IOEx);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate local street info.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
                throw new DataCreationException(101, (Throwable)MMJETASEEx);
            }
        }
    }

    protected void storeHousePoints(MMJSegmentRecord segmentRecord, IDataFileDataItem segment, MMJDataFileMetadata metadata) throws DataCreationException {
        super.storeHousePoints(segmentRecord, segment, metadata);
        AUS_GNAFMMJSegmentRecord AUSSegment = (AUS_GNAFMMJSegmentRecord)segmentRecord;
        List originalPoints = AUSSegment.getOriginalPointsGeometry();
        if (originalPoints != null) {
            GNAFOriginalPointsCompressedSegment compressed = new GNAFOriginalPointsCompressedSegment(originalPoints.toArray(new LongPoint[originalPoints.size()]));
            try {
                ((GenericSegment)segment).putBlob(32, compressed.toBytes());
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate segment original points.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
                throw new DataCreationException(106, (Throwable)MMJETASEEx);
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to convert compressed to bytes.");
                DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
                throw new DataCreationException(106, (Throwable)IOEx);
            }
        } else if (AUSSegment.getOriginalPoint() != null) {
            LongPoint originalPoint = AUSSegment.getOriginalPoint();
            try {
                ((GenericSegment)segment).putLong(33, originalPoint.getX());
                ((GenericSegment)segment).putLong(34, originalPoint.getY());
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate segment original points.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
                throw new DataCreationException(106, (Throwable)MMJETASEEx);
            }
        } else {
            DataCreationLogger.getLogger().logInternalError("Segment has no original point info.");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void populateLocalSegmentInfo(MMJSegmentRecord segmentRecord, IDataFileDataItem segmentItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        segment = (GenericSegment)segmentItem;
        AUSSegment = (AUS_GNAFMMJSegmentRecord)segmentRecord;
        if (AUSSegment.getLocalityPID() != null && (index = this.getGeoInfoIndex()) != null) {
            key = new MiStringIndexKey(AUSSegment.getLocalityPID());
            try {
                val = (MapMarkerIndexSingleValue)index.search((MapMarkerIndexKey)key);
            }
            catch (Exception e1) {
                DataCreationLogger.getLogger().logInternalError("Problem building generic segment.  Unable to lookup localityPID: " + AUSSegment.getLocalityPID() + " in geoinfo.");
                throw new DataCreationException(301, (Throwable)e1);
            }
            if (val != null && val.getOffset() > 0L) {
                AUSSegment.setLeftAreaName1(null);
                AUSSegment.setLeftAreaName2(null);
                AUSSegment.setLeftAreaName3(null);
                AUSSegment.setLeftAreaName4(null);
                AUSSegment.setRightAreaName1(null);
                AUSSegment.setRightAreaName2(null);
                AUSSegment.setRightAreaName3(null);
                AUSSegment.setRightAreaName4(null);
                geoOffset = val.getOffset();
                try {
                    segment.putLong(0, geoOffset);
                    segment.removeString(16);
                    segment.removeString(14);
                    if (!segment.hasString(15)) ** GOTO lbl37
                    segment.removeString(15);
                }
                catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                    DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
                    DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                    DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
                    throw new DataCreationException(106, (Throwable)MMJETASEEx);
                }
            } else {
                DataCreationLogger.getLogger().logInternalError("Unable to get geoinfo record for: " + AUSSegment.getLocalityPID());
            }
        }
lbl37:
        // 5 sources

        super.populateLocalSegmentInfo(segmentRecord, segmentItem, metadata);
        try {
            if (AUSSegment.hasValidMeshBlock()) {
                meshBlock = AUSSegment.getMeshBlock();
                if ((int)(meshBlock / 1000000000L) == 10 * AUS_CandidateConstants.getStateNumber(AUSSegment.getLeftAreaName1())) {
                    segment.putInt(35, (int)(meshBlock % 1000000000L));
                } else {
                    segment.putLong(32, AUSSegment.getMeshBlock());
                }
            }
            if (AUSSegment.hasValidReliability()) {
                segment.putByte(32, AUSSegment.getReliability());
            }
            if (AUSSegment.getGeoContainment()) {
                segment.putBoolean(33, true);
            }
            if (AUSSegment.getGeoFeature() != null) {
                segment.putString(59, AUSSegment.getGeoFeature());
            }
            if (AUSSegment.hasSA1()) {
                segment.putLong(35, AUSSegment.getSA1());
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(106, (Throwable)MMJETASEEx);
        }
    }

    protected void populateLocalRangeInfo(MMJRangeRecord record, IDataFileDataItem rangeItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        AUS_GNAFMMJRangeRecord AUSRange = (AUS_GNAFMMJRangeRecord)record;
        GenericRange range = (GenericRange)rangeItem;
        try {
            ParsedNumber from;
            if (AUSRange.hasValidReliability()) {
                range.putByte(32, AUSRange.getReliability());
            }
            if (AUSRange.hasValidGeocodeLevel()) {
                range.putByte(34, AUSRange.getGeocodeLevel());
            }
            if (AUSRange.hasValidConfidence()) {
                range.putByte(33, AUSRange.getConfidence());
            }
            if (AUSRange.hasPID()) {
                range.putInt(33, AUSRange.getUniquePIDValue());
            }
            if (AUSRange.hasLotNumber()) {
                range.putString(35, AUSRange.getLotNumber());
            }
            if (AUSRange.hasLotPrefix()) {
                range.putString(36, AUSRange.getLotPrefix());
            }
            if (AUSRange.hasLotSuffix()) {
                range.putString(37, AUSRange.getLotSuffix());
            }
            if (AUSRange.isUsedLotForHouse()) {
                range.putBoolean(32, true);
            }
            if (AUSRange.hasPrimaryPID()) {
                range.putInt(34, AUSRange.getUniquePrimaryPIDValue());
            }
            if (AUSRange.getGeoContainment()) {
                range.putBoolean(33, true);
            }
            if (AUSRange.getGeoFeature() != null) {
                range.putString(38, AUSRange.getGeoFeature());
            }
            if (AUSRange.getAddressClass() != null) {
                range.putByte(35, (byte)AUSRange.getAddressClass().ordinal());
            }
            if (AUSRange.getParcelID() != null) {
                range.putString(39, AUSRange.getParcelID());
            }
            if ((from = record.getFromHouse()) != null && from.equals((Object)record.getToHouse())) {
                this.removeHouseNumbers(range);
                if (from.isPureNumeric()) {
                    long value = from.getAddressNumber();
                    if (value >= 0L && value <= 255L) {
                        range.putUnsignedByte(32, (short)value);
                    } else if (value >= 0L && value <= 65535L) {
                        range.putUnsignedShort(32, (int)value);
                    } else {
                        range.putInt(32, (int)value);
                    }
                } else {
                    boolean bHouseStored = false;
                    if (from.getNumFields() == 3 && from.getAddressNumberExists() && from.getSuffixNumberExists() && from.hasNumberSeparator() && "-".equals(from.getNumberSeparator())) {
                        long firstValue = from.getAddressNumber();
                        long secondValue = from.getSuffixNumber();
                        if (firstValue >= 0L && secondValue >= 0L) {
                            boolean bFirstByte = false;
                            boolean bFirstShort = false;
                            boolean bSecondByte = false;
                            boolean bSecondShort = false;
                            if (firstValue <= 255L) {
                                bFirstByte = true;
                            } else if (firstValue <= 65535L) {
                                bFirstShort = true;
                            }
                            if (secondValue <= 255L) {
                                bSecondByte = true;
                            } else if (secondValue <= 65535L) {
                                bSecondShort = true;
                            }
                            if ((bFirstByte || bFirstShort) && (bSecondByte || bSecondShort)) {
                                bHouseStored = true;
                                if (bFirstByte) {
                                    range.putUnsignedByte(33, (short)firstValue);
                                } else {
                                    range.putUnsignedShort(33, (int)firstValue);
                                }
                                if (bSecondByte) {
                                    range.putUnsignedByte(34, (short)secondValue);
                                } else {
                                    range.putUnsignedShort(34, (int)secondValue);
                                }
                            }
                        }
                    }
                    if (!bHouseStored) {
                        range.putString(32, from.getCombinedAddressNumber());
                    }
                }
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range data.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(107, (Throwable)MMJETASEEx);
        }
    }

    private void removeHouseNumbers(GenericRange range) throws MMJETypeArraySizeExceededException {
        if (range.hasUnsignedByte(1)) {
            range.removeUnsignedByte(1);
        } else if (range.hasUnsignedShort(1)) {
            range.removeUnsignedShort(1);
        } else if (range.hasInteger(0)) {
            range.removeInt(0);
        } else if (range.hasString(1)) {
            range.removeString(1);
        }
        if (range.hasUnsignedByte(2)) {
            range.removeUnsignedByte(2);
        } else if (range.hasUnsignedShort(2)) {
            range.removeUnsignedShort(2);
        } else if (range.hasInteger(1)) {
            range.removeInt(1);
        } else if (range.hasString(0)) {
            range.removeString(0);
        }
    }

    protected void populateLocalRangeUnitInfo(MMJRangeUnitRecord record, IDataFileDataItem unitItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        AUS_GNAFMMJRangeUnitRecord AUSUnit = (AUS_GNAFMMJRangeUnitRecord)record;
        GenericUnit unit = (GenericUnit)unitItem;
        try {
            if (AUSUnit.hasValidConfidence()) {
                unit.putByte(32, AUSUnit.getConfidence());
            }
            if (AUSUnit.hasValidGeocodeLevel()) {
                unit.putByte(33, AUSUnit.getGeocodeLevel());
            }
            if (AUSUnit.hasPID()) {
                unit.putInt(33, AUSUnit.getUniquePIDValue());
            }
            if (AUSUnit.hasPrimaryPID()) {
                unit.putInt(35, AUSUnit.getUniquePrimaryPIDValue());
            }
            if (AUSUnit.getAddressClass() != null) {
                unit.putByte(37, (byte)AUSUnit.getAddressClass().ordinal());
            }
            if (AUSUnit.getParcelID() != null) {
                unit.putString(36, AUSUnit.getParcelID());
            }
            String lowUnit = record.getLowUnit();
            String highUnit = record.getHighUnit();
            if (lowUnit != null && lowUnit.equals(highUnit)) {
                this.removeUnitNumbers(unit);
                ParsedNumber unitNumber = new ParsedNumber(lowUnit);
                if (unitNumber.isPureNumeric()) {
                    long value = unitNumber.getAddressNumber();
                    if (value >= 0L && value <= 255L) {
                        unit.putUnsignedByte(32, (short)value);
                    } else if (value >= 0L && value <= 65535L) {
                        unit.putUnsignedShort(32, (int)value);
                    } else {
                        unit.putInt(32, (int)value);
                    }
                } else {
                    unit.putString(32, lowUnit);
                }
            }
            if (AUSUnit.hasLevelType()) {
                String levelType = AUSUnit.getLevelType();
                if (levelType.length() == 1) {
                    unit.putByte(36, (byte)levelType.charAt(0));
                } else {
                    unit.putString(33, levelType);
                }
            }
            if (AUSUnit.hasLevelNumber()) {
                if (AUSUnit.getLevelNumber() <= 255) {
                    unit.putUnsignedByte(33, (short)AUSUnit.getLevelNumber());
                } else if (AUSUnit.getLevelNumber() <= 65535) {
                    unit.putUnsignedShort(33, AUSUnit.getLevelNumber());
                } else {
                    unit.putInt(34, AUSUnit.getLevelNumber());
                }
            }
            if (AUSUnit.hasLevelPrefix()) {
                String prefix = AUSUnit.getLevelPrefix();
                if (prefix.length() == 1) {
                    unit.putByte(34, (byte)prefix.charAt(0));
                } else {
                    unit.putString(34, prefix);
                }
            }
            if (AUSUnit.hasLevelSuffix()) {
                String suffix = AUSUnit.getLevelSuffix();
                if (suffix.length() == 1) {
                    unit.putByte(35, (byte)suffix.charAt(0));
                } else {
                    unit.putString(35, suffix);
                }
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate unit data.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataCreationException(108, (Throwable)MMJETASEEx);
        }
    }

    private void removeUnitNumbers(GenericUnit unit) throws MMJETypeArraySizeExceededException {
        if (unit.hasUnsignedByte(0)) {
            unit.removeUnsignedByte(0);
        } else if (unit.hasUnsignedShort(0)) {
            unit.removeUnsignedShort(0);
        } else if (unit.hasString(0)) {
            unit.removeString(0);
        }
        if (unit.hasUnsignedByte(1)) {
            unit.removeUnsignedByte(1);
        } else if (unit.hasUnsignedShort(1)) {
            unit.removeUnsignedShort(1);
        } else if (unit.hasString(1)) {
            unit.removeString(1);
        }
    }
}

