/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.binary.index;

import com.mapinfo.mapmarker.AUS.AUSLanguageSoundex;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class AUS_GeoInfoSoundexIndexer
extends GeoInfoSoundexIndexer {
    public AUS_GeoInfoSoundexIndexer() {
        this.sndx = new AUSLanguageSoundex();
    }

    private String getAreaName3(GeoInfoDataItem item) {
        String ret = null;
        if (item != null && item.hasString(2)) {
            try {
                ret = item.getString(2);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                System.err.println("ERROR: unable to get areaName3 from geoInfo item.");
                System.err.println(MMJETASEEx.getMessage());
                MMJETASEEx.printStackTrace(System.err);
                System.exit(1);
            }
        }
        return this.cleanAreaNameString(ret);
    }

    private String cleanAreaNameString(String areaName) {
        if (areaName == null || areaName.length() == 0) {
            return null;
        }
        return areaName;
    }

    protected ArrayList makeKeys(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        ArrayList list = new ArrayList();
        if (item != null) {
            this.addAreaName3KeyIfExists(item, list);
            this.addAltAreaName3KeysIfExists(item, list);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private void addAltAreaName3KeysIfExists(GeoInfoDataItem item, ArrayList list) throws DataCreationException {
        if (item.hasString(6)) {
            try {
                String altSuburb = item.getString(6);
                StringTokenizer altSuburbTokens = new StringTokenizer(altSuburb, ";");
                while (altSuburbTokens.hasMoreTokens()) {
                    String alternateSuburb = altSuburbTokens.nextToken();
                    ISoundexKey altSoundex = this.sndx.getSoundex(alternateSuburb);
                    if (list.contains(altSoundex)) continue;
                    DataCreationLogger.getLogger().logStatus("    Adding alternate suburb index [" + alternateSuburb + "].");
                    list.add(altSoundex);
                }
            }
            catch (MMJETypeArraySizeExceededException ex) {
                throw new DataCreationException((Throwable)ex);
            }
        }
    }

    private void addAreaName3KeyIfExists(GeoInfoDataItem item, ArrayList list) {
        String areaName3 = this.getAreaName3(item);
        ISoundexKey area3Key = null;
        if (areaName3 != null && areaName3.length() > 0) {
            area3Key = this.sndx.getSoundex(areaName3);
        }
        if (area3Key != null) {
            list.add(area3Key);
        }
    }

    public static final void main(String[] args) {
        if (args == null || args.length < 1) {
            System.err.println("AUS_GeoInfoSoundexIndexer <geoinfo data file>");
            System.exit(1);
        }
        AUS_GeoInfoSoundexIndexer indexer = new AUS_GeoInfoSoundexIndexer();
        String geoInfoFileName = args[0];
        int extensionStart = geoInfoFileName.indexOf(".");
        if (extensionStart > 0) {
            geoInfoFileName = geoInfoFileName.substring(0, extensionStart);
            System.out.println("GeoInfo base name: " + geoInfoFileName);
        }
        try {
            indexer.processGeoInfoFile(geoInfoFileName);
        }
        catch (DataCreationException DCEx) {
            System.err.println("ERROR: Unable to index geoInfo file.");
            System.err.println(DCEx.getMessage());
            DCEx.printStackTrace(System.err);
            System.exit(1);
        }
        System.out.println("Finished processing.");
    }
}

