/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.intermediate.gnaf;

import com.mapinfo.mapmarker.AUS.dp.binary.GNAFStreetInfo;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeUnitRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJSegmentRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJStreetRecord;
import com.mapinfo.mapmarker.AUS.dp.intermediate.gnaf.AUS_IntermediateStreetDataItem;
import com.mapinfo.mapmarker.AUS.utils.GNAFAddressClass;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateSegmentDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateUnitDataItem;
import com.mapinfo.mapmarker.utils.LongPoint;
import java.io.IOException;

public class AUS_GNAFIntermediateStreetDataFileFormatHandler
extends IntermediateStreetDataFileFormatHandler {
    public AUS_GNAFIntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected IntermediateStreetDataItem getIntermediateStreetDataItemType() {
        return new AUS_IntermediateStreetDataItem();
    }

    protected MMJStreetRecord getStreetRecordType() {
        return new AUS_GNAFMMJStreetRecord();
    }

    protected MMJSegmentRecord getSegmentRecordType() {
        return new AUS_GNAFMMJSegmentRecord();
    }

    protected MMJRangeRecord getRangeRecordType() {
        return new AUS_GNAFMMJRangeRecord();
    }

    protected MMJRangeUnitRecord getUnitRecordType() {
        return new AUS_GNAFMMJRangeUnitRecord();
    }

    protected void convertStreetRecord2DataItem(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetRecord2DataItem(record, item);
        try {
            GNAFStreetInfo info = ((AUS_GNAFMMJStreetRecord)record).getGNAFStreetInfo();
            if (info != null && info.getSpecialHandlingRequired()) {
                item.putBlob(33, info.encode());
            }
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to encode GNAF street info");
            DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
            throw new DataSourceException(14, (Throwable)IOEx);
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate street item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            throw new DataSourceException(14, (Throwable)MMJETASEEx);
        }
    }

    protected void convertStreetDataItem2Record(MMJStreetRecord record, IntermediateStreetDataItem item) throws DataSourceException {
        super.convertStreetDataItem2Record(record, item);
        if (item.hasBlob(33)) {
            GNAFStreetInfo info = new GNAFStreetInfo();
            try {
                info.decode(item.getBlob(33));
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to decode GNAF street info");
                DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
                throw new DataSourceException(14, (Throwable)IOEx);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to access street item.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                throw new DataSourceException(14, (Throwable)MMJETASEEx);
            }
            ((AUS_GNAFMMJStreetRecord)record).setGNAFStreetInfo(info);
        }
    }

    protected void convertSegmentRecord2DataItem(MMJSegmentRecord record, IntermediateSegmentDataItem item) throws DataSourceException {
        super.convertSegmentRecord2DataItem(record, item);
        AUS_GNAFMMJSegmentRecord AUSRecord = (AUS_GNAFMMJSegmentRecord)record;
        try {
            LongPoint originalPoint;
            if (AUSRecord.hasValidReliability()) {
                item.putByte(33, AUSRecord.getReliability());
            }
            if (AUSRecord.hasValidMeshBlock()) {
                item.putLong(33, AUSRecord.getMeshBlock());
            }
            if (AUSRecord.getLocalityPID() != null) {
                item.putString(33, AUSRecord.getLocalityPID());
            }
            if ((originalPoint = AUSRecord.getOriginalPoint()) != null) {
                item.putLong(34, originalPoint.getX());
                item.putLong(35, originalPoint.getY());
            }
            if (AUSRecord.getGeoContainment()) {
                item.putBoolean(33, true);
            }
            if (AUSRecord.getGeoFeature() != null) {
                item.putString(34, AUSRecord.getGeoFeature());
            }
            if (AUSRecord.hasSA1()) {
                item.putLong(36, AUSRecord.getSA1());
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataSourceException(14, (Throwable)MMJETASEEx);
        }
    }

    protected void convertSegmentDataItem2Record(MMJSegmentRecord record, IntermediateSegmentDataItem item) throws DataSourceException {
        super.convertSegmentDataItem2Record(record, item);
        AUS_GNAFMMJSegmentRecord AUSRecord = (AUS_GNAFMMJSegmentRecord)record;
        try {
            if (item.hasByte(33)) {
                AUSRecord.setReliability(item.getByte(33));
            }
            if (item.hasLong(33)) {
                AUSRecord.setMeshBlock(item.getLong(33));
            }
            if (item.hasString(33)) {
                AUSRecord.setLocalityPID(item.getString(33));
            }
            if (item.hasLong(34) && item.hasLong(35)) {
                AUSRecord.setOriginalPoint(new LongPoint(item.getLong(34), item.getLong(35)));
            }
            if (item.hasBoolean(33)) {
                AUSRecord.setGeoContainment(true);
            }
            if (item.hasString(34)) {
                AUSRecord.setGeoFeature(item.getString(34));
            }
            if (item.hasLong(36)) {
                AUSRecord.setSA1(item.getLong(36));
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataSourceException(14, (Throwable)MMJETASEEx);
        }
    }

    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeRecord2DataItem(record, item);
        AUS_GNAFMMJRangeRecord AUSRecord = (AUS_GNAFMMJRangeRecord)record;
        try {
            LongPoint originalPoint;
            if (AUSRecord.hasValidConfidence()) {
                item.putByte(34, AUSRecord.getConfidence());
            }
            if (AUSRecord.hasValidGeocodeLevel()) {
                item.putByte(35, AUSRecord.getGeocodeLevel());
            }
            if (AUSRecord.hasValidReliability()) {
                item.putByte(33, AUSRecord.getReliability());
            }
            if (AUSRecord.hasPID()) {
                item.putString(33, AUSRecord.getPID());
            }
            if (AUSRecord.hasLotNumber()) {
                item.putString(34, AUSRecord.getLotNumber());
            }
            if (AUSRecord.hasLotPrefix()) {
                item.putString(35, AUSRecord.getLotPrefix());
            }
            if (AUSRecord.hasLotSuffix()) {
                item.putString(36, AUSRecord.getLotSuffix());
            }
            if (AUSRecord.isUsedLotForHouse()) {
                item.putBoolean(33, AUSRecord.isUsedLotForHouse());
            }
            if ((originalPoint = AUSRecord.getOriginalPoint()) != null) {
                item.putLong(33, originalPoint.getX());
                item.putLong(34, originalPoint.getY());
            }
            if (AUSRecord.hasPrimaryPID()) {
                item.putString(37, AUSRecord.getPrimaryPID());
            }
            if (AUSRecord.getGeoContainment()) {
                item.putBoolean(34, true);
            }
            if (AUSRecord.getGeoFeature() != null) {
                item.putString(38, AUSRecord.getGeoFeature());
            }
            if (AUSRecord.getAddressClass() != null) {
                item.putByte(36, (byte)AUSRecord.getAddressClass().ordinal());
            }
            if (AUSRecord.getParcelID() != null) {
                item.putString(39, AUSRecord.getParcelID());
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataSourceException(14, (Throwable)MMJETASEEx);
        }
    }

    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeDataItem2Record(record, item);
        AUS_GNAFMMJRangeRecord AUSRecord = (AUS_GNAFMMJRangeRecord)record;
        try {
            if (item.hasByte(34)) {
                AUSRecord.setConfidence(item.getByte(34));
            }
            if (item.hasByte(35)) {
                AUSRecord.setGeocodeLevel(item.getByte(35));
            }
            if (item.hasByte(33)) {
                AUSRecord.setReliability(item.getByte(33));
            }
            if (item.hasString(33)) {
                AUSRecord.setPID(item.getString(33));
            }
            if (item.hasString(34)) {
                AUSRecord.setLotNumber(item.getString(34));
            }
            if (item.hasString(35)) {
                AUSRecord.setLotPrefix(item.getString(35));
            }
            if (item.hasString(36)) {
                AUSRecord.setLotSuffix(item.getString(36));
            }
            if (item.hasBoolean(33)) {
                AUSRecord.setUsedLotForHouse(item.getBoolean(33));
            }
            if (item.hasLong(33) && item.hasLong(34)) {
                AUSRecord.setOriginalPoint(new LongPoint(item.getLong(33), item.getLong(34)));
            }
            if (item.hasString(37)) {
                AUSRecord.setPrimaryPID(item.getString(37));
            }
            if (item.hasBoolean(34)) {
                AUSRecord.setGeoContainment(true);
            }
            if (item.hasString(38)) {
                AUSRecord.setGeoFeature(item.getString(38));
            }
            if (item.hasByte(36)) {
                AUSRecord.setAddressClass(GNAFAddressClass.values()[item.getByte(36)]);
            }
            if (item.hasString(39)) {
                AUSRecord.setParcelID(item.getString(39));
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate range record.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataSourceException(14, (Throwable)MMJETASEEx);
        }
    }

    protected void convertUnitRecord2DataItem(MMJRangeUnitRecord record, IntermediateUnitDataItem item) throws DataSourceException {
        super.convertUnitRecord2DataItem(record, item);
        AUS_GNAFMMJRangeUnitRecord AUSRecord = (AUS_GNAFMMJRangeUnitRecord)record;
        try {
            if (AUSRecord.hasValidConfidence()) {
                item.putByte(33, AUSRecord.getConfidence());
            }
            if (AUSRecord.hasValidGeocodeLevel()) {
                item.putByte(34, AUSRecord.getGeocodeLevel());
            }
            if (AUSRecord.hasPID()) {
                item.putString(33, AUSRecord.getPID());
            }
            if (AUSRecord.hasLevelType()) {
                item.putString(34, AUSRecord.getLevelType());
            }
            if (AUSRecord.hasLevelNumber()) {
                item.putInt(33, AUSRecord.getLevelNumber());
            }
            if (AUSRecord.hasLevelPrefix()) {
                item.putString(35, AUSRecord.getLevelPrefix());
            }
            if (AUSRecord.hasLevelSuffix()) {
                item.putString(36, AUSRecord.getLevelSuffix());
            }
            if (AUSRecord.hasPrimaryPID()) {
                item.putString(37, AUSRecord.getPrimaryPID());
            }
            if (AUSRecord.getAddressClass() != null) {
                item.putByte(35, (byte)AUSRecord.getAddressClass().ordinal());
            }
            if (AUSRecord.getParcelID() != null) {
                item.putString(38, AUSRecord.getParcelID());
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate unit item.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataSourceException(14, (Throwable)MMJETASEEx);
        }
    }

    protected void convertUnitDataItem2Record(MMJRangeUnitRecord record, IntermediateUnitDataItem item) throws DataSourceException {
        super.convertUnitDataItem2Record(record, item);
        AUS_GNAFMMJRangeUnitRecord AUSRecord = (AUS_GNAFMMJRangeUnitRecord)record;
        try {
            if (item.hasByte(33)) {
                AUSRecord.setConfidence(item.getByte(33));
            }
            if (item.hasByte(34)) {
                AUSRecord.setGeocodeLevel(item.getByte(34));
            }
            if (item.hasString(33)) {
                AUSRecord.setPID(item.getString(33));
            }
            if (item.hasString(34)) {
                AUSRecord.setLevelType(item.getString(34));
            }
            if (item.hasInteger(33)) {
                AUSRecord.setLevelNumber(item.getInt(33));
            }
            if (item.hasString(35)) {
                AUSRecord.setLevelPrefix(item.getString(35));
            }
            if (item.hasString(36)) {
                AUSRecord.setLevelSuffix(item.getString(36));
            }
            if (item.hasString(37)) {
                AUSRecord.setPrimaryPID(item.getString(37));
            }
            if (item.hasByte(35)) {
                AUSRecord.setAddressClass(GNAFAddressClass.values()[item.getByte(35)]);
            }
            if (item.hasString(38)) {
                AUSRecord.setParcelID(item.getString(38));
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate unit record.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
            throw new DataSourceException(14, (Throwable)MMJETASEEx);
        }
    }
}

