/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.intermediate.ud;

import com.mapinfo.mapmarker.AUS.dp.ud.binary.AUS_MMJUDRangeRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateRangeDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class AUS_UDIntermediateStreetDataFileFormatHandler
extends IntermediateStreetDataFileFormatHandler {
    private static final int ORIGINAL_LATITUDE = 34;
    private static final int ORIGINAL_LONGITUDE = 35;

    public AUS_UDIntermediateStreetDataFileFormatHandler(String fileName) {
        super(fileName);
    }

    protected MMJRangeRecord getRangeRecordType() {
        return new AUS_MMJUDRangeRecord();
    }

    protected void convertRangeRecord2DataItem(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeRecord2DataItem(record, item);
        AUS_MMJUDRangeRecord udRecord = (AUS_MMJUDRangeRecord)record;
        if (!StringUtilities.isEmpty((String)udRecord.getOriginalLatitude()) && !StringUtilities.isEmpty((String)udRecord.getOriginalLongitude())) {
            try {
                item.putString(34, udRecord.getOriginalLatitude());
                item.putString(35, udRecord.getOriginalLongitude());
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate range item.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
                throw new DataSourceException(14, (Throwable)MMJETASEEx);
            }
        }
    }

    protected void convertRangeDataItem2Record(MMJRangeRecord record, IntermediateRangeDataItem item) throws DataSourceException {
        super.convertRangeDataItem2Record(record, item);
        if (item.hasString(34) && item.hasString(35)) {
            AUS_MMJUDRangeRecord udRecord = (AUS_MMJUDRangeRecord)record;
            try {
                udRecord.setOriginalLatitude(item.getString(34));
                udRecord.setOriginalLongitude(item.getString(35));
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate range record.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)MMJETASEEx);
                throw new DataSourceException(14, (Throwable)MMJETASEEx);
            }
        }
    }
}

