/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.tab.gnaf;

import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJRangeUnitRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMMJSegmentRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.gnaf.AUS_GNAFMultiSegmentStreet;
import com.mapinfo.mapmarker.AUS.dp.tab.gnaf.AUS_GNAFTabStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeUnitRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.tab.TabStreetDataHandler;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AUS_GNAFTabStreetDataHandler
extends TabStreetDataHandler {
    public AUS_GNAFTabStreetDataHandler(IDataSource dataSourceAccess, IDataSourceRecordConvertor dataConvertor, IIntermediateDataHandler intermediateHandler, MMJStreetRecordComparator streetComparator, MMJSegmentComparer segmentComparer, ITempDataRecordHandler tempHandler) {
        super(dataSourceAccess, dataConvertor, intermediateHandler, streetComparator, segmentComparer, tempHandler);
    }

    public Object getNextDataRecord() throws DataCreationException {
        AUS_GNAFMultiSegmentStreet street = (AUS_GNAFMultiSegmentStreet)((Object)super.getNextDataRecord());
        if (street != null) {
            Iterator segmentIterator = street.getSegments().iterator();
            while (segmentIterator.hasNext()) {
                this.fixRangesOnSegment((AUS_GNAFMMJSegmentRecord)((Object)segmentIterator.next()));
            }
        }
        return street;
    }

    protected IDataSourceRecord makeDataSourceRecord(IDataSourceRecordObjects objects) {
        return new AUS_GNAFTabStreetDataSourceRecord((TabDataSourceRecordObjects)objects);
    }

    protected MultiSegmentStreet makeMultiSegmentStreet(MMJStreetRecord street) {
        return new AUS_GNAFMultiSegmentStreet(street, this.getSegmentComparer());
    }

    private void fixRangesOnSegment(AUS_GNAFMMJSegmentRecord segment) {
        if (this.containsUnits(segment)) {
            Iterator rangeIterator = segment.getRanges().iterator();
            AUS_GNAFMMJRangeRecord previousRange = (AUS_GNAFMMJRangeRecord)((Object)rangeIterator.next());
            while (rangeIterator.hasNext()) {
                AUS_GNAFMMJRangeRecord range = (AUS_GNAFMMJRangeRecord)((Object)rangeIterator.next());
                if (this.representSameRange(previousRange, range)) {
                    if (this.equalPoints(previousRange.getPoint(), range.getPoint())) {
                        if (range.getRangeUnits() == null || range.getRangeUnits().isEmpty()) continue;
                        Iterator unitIterator = range.getRangeUnits().iterator();
                        while (unitIterator.hasNext()) {
                            previousRange.addRangeUnit((MMJRangeUnitRecord)unitIterator.next());
                        }
                        rangeIterator.remove();
                        continue;
                    }
                    previousRange = range;
                    continue;
                }
                previousRange = range;
            }
        }
    }

    private void printRanges(List ranges) {
        System.out.println("\n\n");
        Iterator iterator = ranges.iterator();
        while (iterator.hasNext()) {
            this.printRange((AUS_GNAFMMJRangeRecord)((Object)iterator.next()));
        }
    }

    private void printRange(AUS_GNAFMMJRangeRecord range) {
        System.out.println("from: " + range.getFromHouse().getCombinedAddressNumber() + " to: " + range.getToHouse().getCombinedAddressNumber() + " sorted units: " + range.areUnitsSorted());
        List units = range.getRangeUnits();
        if (units == null || units.isEmpty()) {
            System.out.println("\tno units");
        } else {
            this.printUnits(units);
        }
    }

    private void printUnits(List units) {
        Iterator iterator = units.iterator();
        while (iterator.hasNext()) {
            this.printUnit((AUS_GNAFMMJRangeUnitRecord)((Object)iterator.next()));
        }
    }

    private void printUnit(AUS_GNAFMMJRangeUnitRecord unit) {
        System.out.println("\tlow: " + unit.getLowUnit() + " high: " + unit.getHighUnit());
    }

    private boolean containsUnits(MMJSegmentRecord segment) {
        for (MMJRangeRecord range : segment.getRanges()) {
            if (range.getRangeUnits() == null || range.getRangeUnits().size() <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean representSameRange(AUS_GNAFMMJRangeRecord range1, AUS_GNAFMMJRangeRecord range2) {
        if (range1.getOddEven() != range2.getOddEven()) {
            return false;
        }
        if (range1.getReliability() != range2.getReliability()) {
            return false;
        }
        if (!range1.getFromHouse().equals((Object)range2.getFromHouse())) {
            return false;
        }
        if (!range1.getToHouse().equals((Object)range2.getToHouse())) {
            return false;
        }
        if (range1.getOriginalPoint() != null && range2.getOriginalPoint() != null) {
            if (range1.getOriginalPoint().getX() != range2.getOriginalPoint().getX()) {
                return false;
            }
            if (range1.getOriginalPoint().getY() != range2.getOriginalPoint().getY()) {
                return false;
            }
        } else if (range1.getOriginalPoint() != range2.getOriginalPoint()) {
            return false;
        }
        if (range1.hasLotNumber() && range2.hasLotNumber() ? !range1.getLotNumber().equalsIgnoreCase(range2.getLotNumber()) : range1.hasLotNumber() != range2.hasLotNumber()) {
            return false;
        }
        if (range1.hasLotPrefix() && range2.hasLotPrefix() ? !range1.getLotPrefix().equalsIgnoreCase(range2.getLotPrefix()) : range1.hasLotPrefix() != range2.hasLotPrefix()) {
            return false;
        }
        if (range1.hasLotSuffix() && range2.hasLotSuffix() ? !range1.getLotSuffix().equalsIgnoreCase(range2.getLotSuffix()) : range1.hasLotSuffix() != range2.hasLotSuffix()) {
            return false;
        }
        if (!this.equivalentAdditionalFields(range1.getAdditionalFields(), range2.getAdditionalFields())) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)range1.getPrimaryPID(), (String)range2.getPrimaryPID())) {
            return false;
        }
        if (range1.getGeoContainment() != range2.getGeoContainment()) {
            return false;
        }
        return StringUtilities.equalStrings((String)range1.getGeoFeature(), (String)range2.getGeoFeature());
    }

    private boolean equalPoints(DirectPosition point1, DirectPosition point2) {
        if (point1 == null) {
            return point2 == null;
        }
        if (point2 == null) {
            return false;
        }
        return point1.equals((Object)point2);
    }

    private boolean equivalentAdditionalFields(Map<String, String> map1, Map<String, String> map2) {
        if (map1.isEmpty() && map2.isEmpty()) {
            return true;
        }
        if (map1.isEmpty() || map2.isEmpty()) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        boolean[] bMatches = new boolean[map1.size()];
        int i = 0;
        for (Map.Entry<String, String> targetEntry : map1.entrySet()) {
            for (Map.Entry<String, String> testEntry : map2.entrySet()) {
                if (!targetEntry.getKey().equals(testEntry.getKey())) continue;
                if (!targetEntry.getValue().equals(testEntry.getValue())) {
                    return false;
                }
                bMatches[i] = true;
                break;
            }
            ++i;
        }
        for (Object b : (Object)bMatches) {
            if (b != false) continue;
            return false;
        }
        return true;
    }
}

