/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.ud;

import com.mapinfo.mapmarker.AUS.dp.binary.AUSGeo2SacRecord;
import com.mapinfo.mapmarker.AUS.dp.binary.AUSGeoBase;
import com.mapinfo.mapmarker.AUS.dp.ud.IAUS_OriginalCoordsDataSourceRecord;
import com.mapinfo.mapmarker.AUS.dp.ud.IAUS_UDRangeDataSourceRecord;
import com.mapinfo.mapmarker.AUS.dp.ud.binary.AUS_MMJUDRangeRecord;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUDNonStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataItem;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Properties;

public class AUS_UDStreetDataSourceRecordConvertor
extends UDStreetDataSourceRecordConvertor {
    public AUS_UDStreetDataSourceRecordConvertor(Soundex soundex, Properties dataProperties, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints, IUDNonStreetDataHandler post2SacHandler, IUDNonStreetDataHandler geo2SacHandler) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints, post2SacHandler, geo2SacHandler);
    }

    protected MMJGeo2SacRecord makeGeo2SacRecord(int sac, IGeoBase base) {
        return new AUSGeo2SacRecord(sac, (AUSGeoBase)base);
    }

    protected MMJGeo2SacRecord makeGeo2SacDataRecordType() {
        return new AUSGeo2SacRecord();
    }

    protected IGeoBase makeGeoBase(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        if (left && input.hasLeftAreaName3() && this.stringExists(input.getLeftAreaName3())) {
            AUSGeoBase base = new AUSGeoBase((MiSoundexKey)this.makeSoundexKey(input.getLeftAreaName3()));
            return base;
        }
        if (!left && input.hasRightAreaName3() && this.stringExists(input.getRightAreaName3())) {
            AUSGeoBase base = new AUSGeoBase((MiSoundexKey)this.makeSoundexKey(input.getRightAreaName3()));
            return base;
        }
        return super.makeGeoBase(input, left);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        String standardPrefix;
        if (address.getPreAddress() == null || (standardPrefix = AUS_AddressUtils.getStandardPrefix(address.getPreAddress())) == null) {
            return super.makeStreetBrowseKeys(address, sac);
        }
        String mainAddress = address.getMainAddress();
        MapMarkerIndexKey[] keys = new MapMarkerIndexKey[3];
        keys[0] = new MapMarkerBrowseMultiLevelIndexKey(sac, mainAddress.charAt(0), this.m_generator.getCollationKey(mainAddress));
        keys[1] = new MapMarkerBrowseMultiLevelIndexKey(sac, standardPrefix.charAt(0), this.m_generator.getCollationKey(standardPrefix));
        StringBuffer buffer = new StringBuffer();
        buffer.append(standardPrefix);
        buffer.append(' ');
        buffer.append(mainAddress);
        String combined = buffer.toString();
        keys[2] = new MapMarkerBrowseMultiLevelIndexKey(sac, combined.charAt(0), this.m_generator.getCollationKey(combined));
        return keys;
    }

    protected void populateAlternateDataItems(MMJRangeRecord range, IRangeDataSourceRecord input, int sac) throws DataSourceException {
        if (range == null || AUS_StringUtilities.isEmpty(range.getPlaceName())) {
            return;
        }
        MapMarkerIndexKey searchKey = this.makeSoundexSearchKey(range.getPlaceName(), sac);
        MapMarkerIndexKey browseKey = this.makeAlternateStreetBrowseKey(range.getPlaceName(), sac);
        AlternateDataRecord alternateDataRecord = new AlternateDataRecord();
        AlternateDataItem alternateItem = new AlternateDataItem(0, alternateDataRecord, searchKey, browseKey);
        range.addAlternateDataItem(alternateItem);
    }

    protected MapMarkerIndexKey makeSoundexSearchKey(String soundexString, int sac) {
        MiSoundexKey sndxKey = (MiSoundexKey)this.makeSoundexKey(soundexString);
        if (sndxKey == null) {
            return null;
        }
        return new MiSoundexStreetDataIndexKey(sac, (ISoundexKey)sndxKey);
    }

    protected MapMarkerIndexKey makeAlternateStreetBrowseKey(String str, int sac) {
        String keyString = str.toUpperCase();
        int[] collationKey = this.m_generator.getCollationKey(keyString);
        char c = keyString.charAt(0);
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
    }

    protected int[] getLeftSacs(IStreetDataSourceRecord input) throws DataCreationException {
        int[] finalSacs = super.getLeftSacs(input);
        return this.getFinalSac(finalSacs);
    }

    protected int[] getRightSacs(IStreetDataSourceRecord input) throws DataCreationException {
        int[] finalSacs = super.getRightSacs(input);
        return this.getFinalSac(finalSacs);
    }

    private int[] getFinalSac(int[] finalSacs) {
        return finalSacs;
    }

    protected String makeMainAddressString(String street, String houseNumber) {
        return houseNumber + " " + street;
    }

    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        ParsedNumber from = new ParsedNumber(input.getFrom());
        ParsedNumber to = new ParsedNumber(input.getTo());
        int oddEvenBoth = 0;
        if (input.hasStatus()) {
            if (input.getStatus().toLowerCase().startsWith("e")) {
                oddEvenBoth = 2;
            } else if (input.getStatus().toLowerCase().startsWith("o")) {
                oddEvenBoth = 1;
            }
        }
        if (oddEvenBoth != 0 && this.isRangeStatusValid(from, to, oddEvenBoth)) {
            return oddEvenBoth;
        }
        if (from.compareTo((Object)to) == 0) {
            return from.isRangeOddEvenBoth();
        }
        return 0;
    }

    private boolean isRangeStatusValid(ParsedNumber from, ParsedNumber to, int oddEvenBoth) {
        int fromOddEvenBoth = from.isRangeOddEvenBoth();
        return fromOddEvenBoth == to.isRangeOddEvenBoth() && fromOddEvenBoth == oddEvenBoth;
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord source, int sac) throws DataSourceException {
        AUS_MMJUDRangeRecord range = (AUS_MMJUDRangeRecord)super.convertRangeRecord(source, sac);
        if (range == null || range.getPoint() == null) {
            return range;
        }
        IAUS_OriginalCoordsDataSourceRecord coordsRecord = ((IAUS_UDRangeDataSourceRecord)source).getOriginalCoordsRecord();
        if (coordsRecord == null) {
            return range;
        }
        if (coordsRecord.hasOriginalLatitude() != coordsRecord.hasOriginalLongitude()) {
            throw new DataSourceException(9, "Only one of originalLatitude or originalLongitude is mapped");
        }
        if (!coordsRecord.hasOriginalLatitude()) {
            return range;
        }
        String originalLatitude = coordsRecord.getOriginalLatitude();
        String originalLongitude = coordsRecord.getOriginalLongitude();
        if (StringUtilities.isEmpty((String)originalLatitude) != StringUtilities.isEmpty((String)originalLongitude)) {
            throw new DataSourceException(7, "Only one of originalLatitude or originalLongitude is populated");
        }
        if (!StringUtilities.isEmpty((String)originalLatitude)) {
            range.setOriginalLatitude(originalLatitude);
            range.setOriginalLongitude(originalLongitude);
        }
        return range;
    }

    protected MMJRangeRecord makeRangeRecordType() {
        return new AUS_MMJUDRangeRecord();
    }
}

