/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.dp.ud.tab;

import com.mapinfo.mapmarker.AUS.AUSLanguageSoundex;
import com.mapinfo.mapmarker.AUS.AUS_GeocodeConstraints;
import com.mapinfo.mapmarker.AUS.dp.AUS_DataConstructionParser;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.AUS.dp.intermediate.ud.AUS_UDIntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.AUS.dp.ud.AUS_UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.AUS.dp.ud.binary.AUS_UDStreetBuilder;
import com.mapinfo.mapmarker.AUS.dp.ud.tab.AUS_TabUDStreetDataHandler;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.IUDNonStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.AbstractUDDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ListFileTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.tab.TabFileDataSource;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Locale;
import java.util.Properties;

public class AUS_TabUDDataProvider
extends AbstractUDDataProvider {
    private boolean m_bPointDataSource;
    private MMJComplexDataFileMetadata m_streetMetadata;

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_post2sacDataHandler = new UDPost2SacDataHandler();
        this.m_geo2sacDataHandler = new UDGeo2SacDataHandler();
        this.m_streetDataHandler = new AUS_TabUDStreetDataHandler((IDataSource)new TabFileDataSource(processingProperties), (IDataSourceRecordConvertor)new AUS_UDStreetDataSourceRecordConvertor(new AUSLanguageSoundex(), processingProperties, new CollationKeyGenerator(new Locale("AU", "AUS")), new AUS_DataConstructionParser(), new Constraints((IGeocodeConstraints)new AUS_GeocodeConstraints()), (IUDNonStreetDataHandler)this.m_post2sacDataHandler, (IUDNonStreetDataHandler)this.m_geo2sacDataHandler), (IIntermediateDataHandler)new AUS_UDIntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"street.tmp")), new AUS_MMJStreetRecordComparator(new MMJRangeRecordComparator()), new MMJSegmentComparer(), (ITempDataRecordHandler)new ListFileTempDataRecordHandler(processingProperties.getProperty("street_outputFilePath")));
        this.m_dataBuilder = new AUS_UDStreetBuilder();
        String isPointAddressRanges = processingProperties.getProperty("pointAddressRanges");
        if (isPointAddressRanges != null) {
            this.m_bPointDataSource = true;
        }
    }

    public MMJComplexDataFileMetadata getStreetMetadata() throws DataCreationException {
        if (this.m_streetMetadata == null) {
            this.m_streetMetadata = new MMJComplexDataFileMetadata();
            this.m_streetMetadata.setCountry("AUS");
            this.m_streetMetadata.setDataFileMasks(new DataFileMasks());
            this.m_streetMetadata.setFrequentStrings(this.m_streetFrequentStrings);
            this.m_streetMetadata.setVersion(new MiVersion(4, 0, 0));
            this.m_streetMetadata.setVendorCode(this.getVandorAndDataType());
            if (this.m_bPointDataSource) {
                this.m_streetMetadata.setXPow10((byte)6);
                this.m_streetMetadata.setYPow10((byte)6);
            } else {
                this.m_streetMetadata.setXPow10((byte)5);
                this.m_streetMetadata.setYPow10((byte)5);
            }
        }
        return this.m_streetMetadata;
    }

    @Override
    public MMJComplexDataFileMetadata getPostInfoMetadata() throws DataCreationException {
        return null;
    }

    @Override
    public void preProcessStreetDataSet() throws DataCreationException {
        super.preProcessStreetDataSet();
    }

    @Override
    public void createOtherFiles() throws DataCreationException {
        super.copyOtherFiles();
    }
}

