/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.filters;

import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.filters.FilterUtils;
import com.mapinfo.mapmarker.AUS.utils.AUS_AddressUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class PickByAddressNumberFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        boolean bPassPostcode;
        Address inputAddr = inputAddresses[0];
        ParsedNumber inputNumber = inputAddr.getParsedAddressNumber();
        if (inputNumber == null) {
            return false;
        }
        AUS_InternalCandidateAddress best = (AUS_InternalCandidateAddress)bestCandidate;
        AUS_InternalCandidateAddress other = (AUS_InternalCandidateAddress)otherCandidate;
        boolean bPassCity = StringUtilities.isEmpty((String)inputAddr.getAreaName3()) || StringUtilities.equalStrings((String)best.getAreaName3(), (String)other.getAreaName3());
        boolean bPassState = StringUtilities.isEmpty((String)inputAddr.getAreaName1()) || StringUtilities.equalStrings((String)best.getAreaName1(), (String)other.getAreaName1());
        boolean bl = bPassPostcode = StringUtilities.isEmpty((String)inputAddr.getPostCode1()) || StringUtilities.equalStrings((String)best.getPostCode1(), (String)other.getPostCode1());
        if (!(bPassCity && bPassState && bPassPostcode)) {
            return false;
        }
        if (!AUS_AddressUtils.getFormattedStreetPortion((Address)best, null, false).equals(AUS_AddressUtils.getFormattedStreetPortion((Address)other, null, false))) {
            return false;
        }
        if (best.hasMatchingRange()) {
            if (other.hasMatchingRange()) {
                if (FilterUtils.demoteOtherBasedOnLevelAndUnit(inputAddr, best, other, false) || FilterUtils.demoteOtherBasedOnLevelAndUnit(inputAddr, other, best, false)) {
                    return false;
                }
                if (best.getDictionaryPriority() > other.getDictionaryPriority()) {
                    return false;
                }
                String inputAddrNumber = inputNumber.getCombinedAddressNumber();
                return StringUtilities.equalStrings((String)inputAddrNumber, (String)best.getAddressNumber()) && !StringUtilities.equalStrings((String)inputAddrNumber, (String)other.getAddressNumber());
            }
            return true;
        }
        if (other.hasMatchingRange()) {
            return false;
        }
        if (best.hasClosestRange()) {
            if (!other.hasClosestRange()) {
                return true;
            }
            Range bestRange = best.getSegment().getRangeAt(best.getClosestRangeNumber(), best.getClosestSegmentSide());
            Range otherRange = other.getSegment().getRangeAt(other.getClosestRangeNumber(), other.getClosestSegmentSide());
            long bestDistance = inputNumber.computeDifference(bestRange.getParsedFrom(), 1);
            long test = inputNumber.computeDifference(bestRange.getParsedTo(), 1);
            if (test < bestDistance) {
                bestDistance = test;
            }
            long otherDistance = inputNumber.computeDifference(otherRange.getParsedFrom(), 1);
            test = inputNumber.computeDifference(otherRange.getParsedTo(), 1);
            if (test < otherDistance) {
                otherDistance = test;
            }
            return bestDistance < otherDistance;
        }
        return false;
    }
}

