/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.filters;

import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.filters.FilterUtils;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class PickPerfectLocationWithGoodStreetPortionFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        AUS_InternalCandidateAddress best = (AUS_InternalCandidateAddress)bestCandidate;
        AUS_InternalCandidateAddress other = (AUS_InternalCandidateAddress)otherCandidate;
        if (best.getCombinedAdditionalFieldScore() != 1.0 || !FilterUtils.isPerfectStreetPortion(best)) {
            return false;
        }
        String bestAddressNumber = best.getAddressNumber();
        String otherAddressNumber = other.getAddressNumber();
        if (StringUtilities.isEmpty((String)bestAddressNumber)) {
            boolean bOtherPerfectHouseNumber;
            if (StringUtilities.isEmpty((String)inputAddresses[0].getAddressNumber())) {
                return true;
            }
            if (StringUtilities.isEmpty((String)otherAddressNumber)) {
                return true;
            }
            boolean bOtherPerfectPostCode = other.getPostCode1Score() == 1.0;
            boolean bOtherPerfectCity = other.getAreaName3Score() == 1.0 || StringUtilities.equalStrings((String)best.getAreaName3(), (String)other.getAreaName3());
            boolean bOtherPerfectStreetPortion = FilterUtils.isPerfectStreetPortion(other);
            boolean bl = bOtherPerfectHouseNumber = other.getAddressNumberScore() == 1.0;
            if (bOtherPerfectPostCode && bOtherPerfectCity) {
                return false;
            }
            if ((bOtherPerfectPostCode || bOtherPerfectCity) && bOtherPerfectStreetPortion && bOtherPerfectHouseNumber) {
                return false;
            }
            return best.getAddressNumberScore() >= other.getAddressNumberScore();
        }
        return best.getUserDictionaryPriority() < other.getUserDictionaryPriority() && best.getAddressNumberScore() >= other.getAddressNumberScore() && !FilterUtils.isPerfectStreetPortion(other) && other.getCombinedAdditionalFieldScore() < 1.0;
    }
}

