/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.filters;

import com.mapinfo.mapmarker.AUS.AUS_GNAFInfoData;
import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class RemoveDuplicatesFilterRule
implements ICloseMatchFilterRule {
    public boolean demoteOther(Address[] inputAddresses, ICandidate bestCandidate, ICandidate otherCandidate) {
        AUS_InternalCandidateAddress best = (AUS_InternalCandidateAddress)bestCandidate;
        AUS_InternalCandidateAddress other = (AUS_InternalCandidateAddress)otherCandidate;
        if (StringUtilities.isEmpty((String)inputAddresses[0].getMainAddress()) && !StringUtilities.isEmpty((String)inputAddresses[0].getPlaceName())) {
            return false;
        }
        if (best.getCombinedAddressScore() != other.getCombinedAddressScore() || best.getCombinedAdditionalFieldScore() != other.getCombinedAdditionalFieldScore() || best.getAdditionalParserFieldsScore() != other.getAdditionalParserFieldsScore()) {
            return false;
        }
        if (best.getUnitNumberScore() != other.getUnitNumberScore()) {
            return false;
        }
        if (best.getUnitTypeScore() != other.getUnitTypeScore()) {
            return false;
        }
        if (best.fromGNAFDictionary() != other.fromGNAFDictionary()) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)best.getAddressNumber(), (String)other.getAddressNumber())) {
            return false;
        }
        if (!StringUtilities.equalStrings((String)best.getUnitValue(), (String)other.getUnitValue())) {
            return false;
        }
        if (!best.getFormattedLocationAddress().equals(other.getFormattedLocationAddress())) {
            return false;
        }
        if (!best.getFormattedStreetAddress().equals(other.getFormattedStreetAddress())) {
            return false;
        }
        if (best.fromGNAFDictionary()) {
            AUS_GNAFInfoData bestInfoData = best.getGNAFInfoData();
            AUS_GNAFInfoData otherInfoData = other.getGNAFInfoData();
            if (bestInfoData != null) {
                if (otherInfoData == null) {
                    return false;
                }
                if (!bestInfoData.equals(otherInfoData)) {
                    return false;
                }
            } else if (otherInfoData != null) {
                return false;
            }
        }
        return true;
    }
}

