/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.geography;

import com.mapinfo.mapmarker.AUS.AUS_InternalGeographicCandidate;
import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.core.geographic.IGeographicMatcher;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class AUS_GeographicMatcher
implements IGeographicMatcher {
    public List matchGeographic(IConstraints constraints, Address parsedAddress, IRetrievedCandidates candidateInfo) throws MatcherException {
        if (candidateInfo != null) {
            List candidateList = candidateInfo.getCandidates();
            if (candidateList != null && !candidateList.isEmpty()) {
                InternalMatcherConstants matcherConstants = constraints.getHandler().getMatcherConstants().getGeographicMatcherConstants();
                double maxScore = this.computeMaximumGeographicScore(parsedAddress, matcherConstants);
                IMatchPreferences preferences = constraints.getHandler().getMatchConstraintsConverter().repackageGeocodingConstraints(constraints, parsedAddress);
                ListIterator candidateIterator = candidateList.listIterator();
                while (candidateIterator.hasNext()) {
                    InternalGeographicCandidate candidate = (InternalGeographicCandidate)candidateIterator.next();
                    this.scoreCandidate(candidate, parsedAddress, matcherConstants, maxScore);
                    this.decideCloseMatch(preferences, candidate, matcherConstants);
                    if (constraints.getDictionaryUsage() == DictionaryUsagePreference.PREFER_UD && candidate.fromUserDictionary()) {
                        candidate.setDictionaryBonus();
                        continue;
                    }
                    if (constraints.getDictionaryUsage() != DictionaryUsagePreference.PREFER_AD || candidate.fromUserDictionary()) continue;
                    candidate.setDictionaryBonus();
                }
                this.orderCandidates(candidateList);
            }
            return candidateList;
        }
        return null;
    }

    private void orderCandidates(List candidateList) {
        Collections.sort(candidateList);
        Collections.reverse(candidateList);
    }

    private void decideCloseMatch(IMatchPreferences preferences, InternalGeographicCandidate candidate, InternalMatcherConstants constants) {
        if (candidate.getCombinedScore() < constants.getCloseMatchCutOff()) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (preferences.getExactMatchAreaName1() && candidate.getAreaName1Score() != 1.0) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (preferences.getExactMatchAreaName2() && candidate.getAreaName2Score() != 1.0) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (preferences.getExactMatchAreaName3() && candidate.getAreaName3Score() != 1.0) {
            candidate.setCloseMatchStatus(false);
            return;
        }
        if (preferences.getExactMatchAreaName4() && candidate.getAreaName4Score() != 1.0) {
            candidate.setCloseMatchStatus(false);
        }
        if (preferences.getExactMatchCountry() && candidate.getCountryScore() != 1.0) {
            candidate.setCloseMatchStatus(false);
        }
        if (preferences.getExactMatchPostalCode1() && ((AUS_InternalGeographicCandidate)candidate).getPostCodeScore() < 1.0) {
            candidate.setCloseMatchStatus(false);
        }
    }

    private void scoreCandidate(InternalGeographicCandidate candidate, Address parsedAddress, InternalMatcherConstants constants, double maxScore) {
        candidate.scoreCandidate(parsedAddress, constants.getCharsToIgnore());
        this.scoreGeographicCandidate(candidate, parsedAddress, constants, maxScore);
    }

    private void scoreGeographicCandidate(InternalGeographicCandidate candidate, Address parsedAddress, InternalMatcherConstants constants, double maxScore) {
        double score = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        score = AUS_GeographicMatcher.fieldExists(parsedAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1() * candidate.getAreaName1Score()) : (score += blankConstants.getAreaName1() * candidate.getAreaName1Score());
        score = AUS_GeographicMatcher.fieldExists(parsedAddress.getAreaName2()) ? (score += matchedConstants.getAreaName2() * candidate.getAreaName2Score()) : (score += blankConstants.getAreaName2() * candidate.getAreaName2Score());
        score = AUS_GeographicMatcher.fieldExists(parsedAddress.getAreaName3()) ? (score += matchedConstants.getAreaName3() * candidate.getAreaName3Score()) : (score += blankConstants.getAreaName3() * candidate.getAreaName3Score());
        score = AUS_GeographicMatcher.fieldExists(parsedAddress.getAreaName4()) ? (score += matchedConstants.getAreaName4() * candidate.getAreaName4Score()) : (score += blankConstants.getAreaName4() * candidate.getAreaName4Score());
        score = AUS_GeographicMatcher.fieldExists(parsedAddress.getCountry()) ? (score += matchedConstants.getCountry() * candidate.getCountryScore()) : (score += blankConstants.getCountry() * candidate.getCountryScore());
        candidate.setCombinedScore(score / maxScore);
    }

    private double computeMaximumGeographicScore(Address parsedAddress, InternalMatcherConstants constants) {
        double m_maximumAddressScore = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        m_maximumAddressScore = AUS_GeographicMatcher.fieldExists(parsedAddress.getAreaName1()) ? (m_maximumAddressScore += matchedConstants.getAreaName1()) : (m_maximumAddressScore += blankConstants.getAreaName1());
        m_maximumAddressScore = AUS_GeographicMatcher.fieldExists(parsedAddress.getAreaName2()) ? (m_maximumAddressScore += matchedConstants.getAreaName2()) : (m_maximumAddressScore += blankConstants.getAreaName2());
        m_maximumAddressScore = AUS_GeographicMatcher.fieldExists(parsedAddress.getAreaName3()) ? (m_maximumAddressScore += matchedConstants.getAreaName3()) : (m_maximumAddressScore += blankConstants.getAreaName3());
        m_maximumAddressScore = AUS_GeographicMatcher.fieldExists(parsedAddress.getAreaName4()) ? (m_maximumAddressScore += matchedConstants.getAreaName4()) : (m_maximumAddressScore += blankConstants.getAreaName4());
        m_maximumAddressScore = AUS_GeographicMatcher.fieldExists(parsedAddress.getCountry()) ? (m_maximumAddressScore += matchedConstants.getCountry()) : (m_maximumAddressScore += blankConstants.getCountry());
        return m_maximumAddressScore;
    }

    private static boolean fieldExists(String str) {
        return str != null && str.length() != 0;
    }
}

