/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.licensing;

import com.mapinfo.mapmarker.AUS.AUS_InternalBrowseAddress;
import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_InternalGeographicCandidate;
import com.mapinfo.mapmarker.AUS.AUS_PIDInternalCandidate;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataDictionary;
import com.mapinfo.mapmarker.AUS.dp.binary.AUS_DataManager;
import com.mapinfo.mapmarker.AUS.licensing.MMAUSLicenseException;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.licensing.MMLicenseException;
import com.mapinfo.mapmarker.licensing.MMLicensing;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.MMCustomConfiguration;
import com.mapinfo.scp.spi.License;
import com.mapinfo.scp.spi.LicenseDefinition;
import com.mapinfo.scp.spi.LicenseRequest;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class AUSLicenseFilter
extends LicenseFilter {
    private static final String FACTORY_CONFIG_FILE = "MMAUSLicenseFactory.config";
    private static final String PROVIDER_CONFIG_FILE = "MMAUSLicenseProvider.config";
    private static final String BASIC_FEATURE = "mapmarker.data.aus.basic";
    private static final String VERSION = "1.0";
    private static final String FEATURE_PREFIX = "mapmarker.data.aus.";
    private static final String STREET_SUFFIX = ".street";
    private static final String STREET_SUFFIX_GNAF = ".gnaf.street";
    private static final String POSTAL_SUFFIX = ".postal";
    private static final String GEOGRAPHIC_SUFFIX = ".geographic";
    private MMLicensing m_licenser;
    private Map m_streetRequestMap = new HashMap();
    private Map m_streetGnafRequestMap = new HashMap();
    private Map m_postalRequestMap = new HashMap();
    private Map m_geographicRequestMap = new HashMap();
    private LicenseRequest m_basicRequest;
    private static final String STREET_LIC_HEADER = "AUS street: ";
    private static final String POSTAL_LIC_HEADER = "AUS postal: ";
    private static final String GEOGRAPHIC_LIC_HEADER = "AUS geographic: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AUSLicenseFilter() throws MMLicenseException {
        URL providerURL;
        URL factoryURL;
        if (MMCustomConfiguration.getUseCustomProperties()) {
            factoryURL = FileUtilities.getUrlFromString((String)(MMCustomConfiguration.getConfigLocation() + FACTORY_CONFIG_FILE));
            providerURL = FileUtilities.getUrlFromString((String)(MMCustomConfiguration.getConfigLocation() + PROVIDER_CONFIG_FILE));
        } else {
            ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
            factoryURL = cl.getResource(FACTORY_CONFIG_FILE);
            providerURL = cl.getResource(PROVIDER_CONFIG_FILE);
        }
        this.m_licenser = factoryURL == null || providerURL == null ? new MMLicensing() : new MMLicensing(factoryURL.toExternalForm(), providerURL.toExternalForm());
        this.m_basicRequest = this.m_licenser.createLicenseRequest(BASIC_FEATURE, VERSION);
        License basicLicense = null;
        try {
            basicLicense = this.m_licenser.checkout(this.m_basicRequest);
            if (basicLicense == null) {
                throw new MMAUSLicenseException(5200);
            }
        }
        finally {
            if (basicLicense != null) {
                this.m_licenser.checkin(basicLicense);
            }
        }
    }

    protected LicenseRequest buildRequest(ICandidate candidate, int mode) throws MMAUSLicenseException {
        switch (mode) {
            case 0: {
                boolean bGNAF;
                String state;
                if (candidate instanceof AUS_PIDInternalCandidate) {
                    state = ((AUS_PIDInternalCandidate)candidate).getAreaName1();
                    bGNAF = true;
                } else {
                    AUS_InternalCandidateAddress candAddress = (AUS_InternalCandidateAddress)candidate;
                    state = candAddress.getAreaName1();
                    bGNAF = this.isGnafRecord(candAddress);
                }
                LicenseRequest request = null;
                request = state == null || state.trim().length() == 0 ? this.m_basicRequest : (bGNAF ? this.getGnafStreetRequest(state.toLowerCase()) : this.getStreetRequest(state.toLowerCase()));
                return request;
            }
            case 1: {
                String state = this.determineLicenseState((AUS_InternalBrowseAddress)candidate);
                LicenseRequest request = state == null || state.length() == 0 ? this.m_basicRequest : this.getStreetRequest(state);
                return request;
            }
            case 2: {
                String state = ((InternalPostalCandidate)candidate).getAreaName1();
                LicenseRequest request = state == null || state.length() == 0 ? this.m_basicRequest : this.getPostalRequest(state);
                return request;
            }
            case 3: {
                String state = ((AUS_InternalGeographicCandidate)candidate).getAreaName1();
                LicenseRequest request = state == null || state.length() == 0 ? this.m_basicRequest : this.getGeographicRequest(state);
                return request;
            }
        }
        throw new MMAUSLicenseException(5201);
    }

    private boolean isGnafRecord(AUS_InternalCandidateAddress candAddress) {
        AUS_DataDictionary dict = null;
        try {
            AUS_DataManager dataManager = new AUS_DataManager();
            dict = (AUS_DataDictionary)dataManager.getDictionary(candAddress.getDictionaryPriority());
        }
        catch (MMJEDataManagerInitializationException e) {
            dict = null;
        }
        return dict == null ? false : dict.isGNAFDictionary();
    }

    protected MMLicensing getLicenser() {
        return this.m_licenser;
    }

    public String[] getLicenseInformation() {
        StringBuffer streetLic = new StringBuffer(STREET_LIC_HEADER);
        StringBuffer postalLic = new StringBuffer(POSTAL_LIC_HEADER);
        StringBuffer geographicLic = new StringBuffer(GEOGRAPHIC_LIC_HEADER);
        LicenseDefinition[] defs = this.m_licenser.getAvailableLicenseDefinitions();
        if (defs.length > 0) {
            Arrays.sort(defs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    LicenseDefinition def1 = (LicenseDefinition)o1;
                    LicenseDefinition def2 = (LicenseDefinition)o2;
                    int result = def1.getLicenseFeature().getName().compareTo(def2.getLicenseFeature().getName());
                    if (result == 0) {
                        result = def1.getLicenseFeature().getVersion().compareTo(def2.getLicenseFeature().getVersion());
                    }
                    return result;
                }
            });
        }
        LicenseDefinition lastDef = null;
        for (int i = 0; i < defs.length; ++i) {
            LicenseDefinition def = defs[i];
            if (lastDef != null && lastDef.getLicenseFeature().getName().equals(def.getLicenseFeature().getName())) continue;
            String featureName = def.getLicenseFeature().getName();
            if (featureName.startsWith(FEATURE_PREFIX)) {
                if (featureName.endsWith(STREET_SUFFIX)) {
                    streetLic.append(featureName.substring(FEATURE_PREFIX.length(), featureName.length() - STREET_SUFFIX.length()));
                    streetLic.append(", ");
                } else if (featureName.endsWith(POSTAL_SUFFIX)) {
                    postalLic.append(featureName.substring(FEATURE_PREFIX.length(), featureName.length() - POSTAL_SUFFIX.length()));
                    postalLic.append(", ");
                } else if (featureName.endsWith(GEOGRAPHIC_SUFFIX)) {
                    geographicLic.append(featureName.substring(FEATURE_PREFIX.length(), featureName.length() - GEOGRAPHIC_SUFFIX.length()));
                    geographicLic.append(", ");
                }
            }
            lastDef = def;
        }
        streetLic.setLength(streetLic.length() - 2);
        postalLic.setLength(postalLic.length() - 2);
        geographicLic.setLength(geographicLic.length() - 2);
        return new String[]{streetLic.toString(), postalLic.toString(), geographicLic.toString()};
    }

    private LicenseRequest getStreetRequest(String state) {
        LicenseRequest request = (LicenseRequest)this.m_streetRequestMap.get(state);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(state.toLowerCase());
            sb.append(STREET_SUFFIX);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_streetRequestMap.put(state, request);
        }
        return request;
    }

    private LicenseRequest getGnafStreetRequest(String state) {
        LicenseRequest request = (LicenseRequest)this.m_streetGnafRequestMap.get(state);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(state.toLowerCase());
            sb.append(STREET_SUFFIX_GNAF);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_streetGnafRequestMap.put(state, request);
        }
        return request;
    }

    private LicenseRequest getPostalRequest(String state) {
        LicenseRequest request = (LicenseRequest)this.m_postalRequestMap.get(state);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(state.toLowerCase());
            sb.append(POSTAL_SUFFIX);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_postalRequestMap.put(state, request);
        }
        return request;
    }

    private LicenseRequest getGeographicRequest(String state) {
        LicenseRequest request = (LicenseRequest)this.m_geographicRequestMap.get(state);
        if (request == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(FEATURE_PREFIX);
            sb.append(state.toLowerCase());
            sb.append(GEOGRAPHIC_SUFFIX);
            request = this.m_licenser.createLicenseRequest(sb.toString(), VERSION);
            this.m_geographicRequestMap.put(state, request);
        }
        return request;
    }

    private String determineLicenseState(AUS_InternalBrowseAddress browseAddress) {
        String result = null;
        for (int i = 0; i < browseAddress.getSegmentCount(); ++i) {
            String segmentState;
            Segment segment = browseAddress.getSegmentAt(i);
            String leftState = segment.getLeftAreaName1();
            String rightState = segment.getRightAreaName1();
            if (leftState != null && (rightState == null || leftState.equals(rightState))) {
                segmentState = leftState;
            } else if (rightState != null && (leftState == null || rightState.equals(leftState))) {
                segmentState = rightState;
            } else {
                result = null;
                break;
            }
            if (result == null) {
                result = segmentState;
                continue;
            }
            if (result.equals(segmentState)) continue;
            result = null;
            break;
        }
        return result;
    }

    public IRetrievedCandidates filterCandidates(IRetrievedCandidates candidates, int mode) {
        return super.filterCandidates(candidates, mode);
    }
}

