/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.parser;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class AUS_Abbreviations {
    private static Properties m_abbr = null;
    private static HashMap m_keys = new HashMap();

    public static void load() throws Throwable {
        try {
            if (m_abbr == null) {
                Properties temp = new Properties();
                m_abbr = new Properties();
                temp.load(AUS_Abbreviations.class.getResourceAsStream("AUS_Abbreviations.properties"));
                Enumeration<Object> em = temp.keys();
                while (em.hasMoreElements()) {
                    String key = (String)em.nextElement();
                    m_abbr.put(key.toUpperCase(), ((String)temp.get(key)).toUpperCase());
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for AUS_Parser.");
        }
    }

    public static boolean isAbbreviation(String abbr) {
        return m_abbr.containsValue(abbr.toUpperCase());
    }

    public static boolean hasAbbreviation(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        return m_abbr.containsKey(term.trim().toUpperCase());
    }

    public static String getAbbreviation(String word) {
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        return (String)m_abbr.get(word.trim().toUpperCase());
    }

    public static boolean containAbbreviations(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!AUS_Abbreviations.isAbbreviation(temp)) continue;
            return true;
        }
        return false;
    }

    public static boolean containWordThatCanBeAbbreviated(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!AUS_Abbreviations.hasAbbreviation(temp)) continue;
            return true;
        }
        return false;
    }

    public static String abbreviateWords(String words) {
        if (words == null || words.trim().length() == 0) {
            return null;
        }
        StringBuffer output = new StringBuffer(words.length());
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            String abbr = AUS_Abbreviations.getAbbreviation(temp);
            if (abbr != null) {
                output.append(abbr);
            } else {
                output.append(temp);
            }
            output.append(" ");
        }
        return output.toString().trim();
    }

    static {
        try {
            AUS_Abbreviations.load();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }
}

