/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.parser;

import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AUS_Directionals {
    private static final Map DIRECTIONALS;

    private AUS_Directionals() {
    }

    public static boolean isDirection(String str) {
        return !StringUtilities.isEmpty((String)str) && DIRECTIONALS.containsKey(str);
    }

    public static String getFullName(String direction) {
        Directional dir = AUS_Directionals.getDirectional(direction);
        if (dir == null) {
            return null;
        }
        return dir.getFullName();
    }

    public static String getAbbreviation(String direction) {
        Directional dir = AUS_Directionals.getDirectional(direction);
        if (dir == null) {
            return null;
        }
        return dir.getAbbreviation();
    }

    public static Directional getDirectional(String direction) {
        if (StringUtilities.isEmpty((String)direction)) {
            return null;
        }
        return (Directional)DIRECTIONALS.get(direction);
    }

    static {
        HashMap<String, Directional> temp = new HashMap<String, Directional>(20);
        Directional northDir = new Directional("NORTH", "N");
        temp.put("NORTH", northDir);
        temp.put("N", northDir);
        temp.put("N.", northDir);
        temp.put("NTH", northDir);
        temp.put("NTH.", northDir);
        Directional southDir = new Directional("SOUTH", "S");
        temp.put("SOUTH", southDir);
        temp.put("S", southDir);
        temp.put("S.", southDir);
        temp.put("STH", southDir);
        temp.put("STH.", southDir);
        Directional eastDir = new Directional("EAST", "E");
        temp.put("EAST", eastDir);
        temp.put("E", eastDir);
        temp.put("E.", eastDir);
        temp.put("EST", eastDir);
        temp.put("EST.", eastDir);
        Directional westDir = new Directional("WEST", "W");
        temp.put("WEST", westDir);
        temp.put("W", westDir);
        temp.put("W.", westDir);
        temp.put("WST", westDir);
        temp.put("WST.", westDir);
        Directional nwDir = new Directional("NORTHWEST", "NW");
        temp.put("NORTHWEST", nwDir);
        temp.put("NW", nwDir);
        temp.put("NW.", nwDir);
        Directional neDir = new Directional("NORTHEAST", "NE");
        temp.put("NORTHEAST", neDir);
        temp.put("NE", neDir);
        temp.put("NE.", neDir);
        Directional swDir = new Directional("SOUTHWEST", "SW");
        temp.put("SOUTHWEST", swDir);
        temp.put("SW", swDir);
        temp.put("SW.", swDir);
        Directional seDir = new Directional("SOUTHEAST", "SE");
        temp.put("SOUTHEAST", seDir);
        temp.put("SE", seDir);
        temp.put("SE.", seDir);
        northDir.setRelatives(new Directional[]{neDir, nwDir});
        southDir.setRelatives(new Directional[]{seDir, swDir});
        eastDir.setRelatives(new Directional[]{neDir, seDir});
        westDir.setRelatives(new Directional[]{nwDir, swDir});
        nwDir.setRelatives(new Directional[]{northDir, westDir});
        neDir.setRelatives(new Directional[]{northDir, eastDir});
        swDir.setRelatives(new Directional[]{southDir, westDir});
        seDir.setRelatives(new Directional[]{southDir, eastDir});
        DIRECTIONALS = Collections.unmodifiableMap(temp);
    }

    public static class Directional {
        private String m_fullName;
        private String m_abbreviation;
        private Directional[] m_relatives;

        private Directional(String fullName, String abbreviation) {
            this.m_fullName = fullName;
            this.m_abbreviation = abbreviation;
            this.m_relatives = null;
        }

        public String getFullName() {
            return this.m_fullName;
        }

        public String getAbbreviation() {
            return this.m_abbreviation;
        }

        public boolean isSame(Directional dir) {
            return this == dir;
        }

        private void setRelatives(Directional[] relatives) {
            if (this.m_relatives == null) {
                this.m_relatives = relatives;
            }
        }

        public boolean isRelative(Directional dir) {
            if (this.m_relatives == null || dir == null) {
                return false;
            }
            for (int index = 0; index < this.m_relatives.length; ++index) {
                if (this.m_relatives[index] != dir) continue;
                return true;
            }
            return false;
        }
    }
}

