/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.parser;

import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;

public class AUS_ParsePostAddressRule
implements IParseRule {
    private static String[] states = new String[]{"QLD", "NSW", "VIC", "NT", "SA", "TAS", "WA", "ACT", "QUEENSLAND", "VICTORIA", "TASMANIA"};
    private static final Set<String> AUSTRALIA_TOKENS;
    private static final Set<String> AUSTRALIA_STATE_FIRSTWORD_TOKENS;
    private static final Set<String> SINGLE_TOKEN_STATES;
    private static String WALES;
    private static String TERRITORY;
    private static String TERRITORY_ABBR;
    public static String POSSIBLE_PIA_SL_STATE;

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        String postcode = null;
        String town = null;
        StringBuffer townx = new StringBuffer();
        String state = null;
        pa.setPostCode1(null);
        postcode = this.standardizePostalCode(AUS_StringUtilities.standardize(ura.getPostCode1(), true), constraints);
        if (ura.getAreaName3() != null && ura.getAreaName3().trim().length() > 0) {
            town = AUS_StringUtilities.standardize(ura.getAreaName3(), true);
        }
        if (ura.getAreaName1() != null && ura.getAreaName1().trim().length() > 0) {
            state = this.abbrState(AUS_StringUtilities.standardize(ura.getAreaName1(), true));
        }
        if (town != null && postcode != null) {
            pa.setAreaName3(town.trim());
            pa.setPostCode1(postcode.trim());
            if (state != null) {
                pa.setAreaName1(state.trim());
            }
            return;
        }
        if (ura.getPostAddress() != null && ura.getPostAddress().trim().length() > 0) {
            StringTokenizer tokens = new StringTokenizer(AUS_StringUtilities.standardize(ura.getPostAddress(), true));
            if (tokens.countTokens() == 0) {
                return;
            }
            LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            if (listOfTokens == null || listOfTokens.size() < 1) {
                return;
            }
            int tokenCount = listOfTokens.size();
            if (tokenCount == 1) {
                String token = (String)listOfTokens.getFirst();
                if (this.isPostalCode(token = token.trim())) {
                    pa.setPostCode1(token);
                } else if (StringUtilities.hasNumeric((String)token)) {
                    if (token.length() == 3 && this.isPostalCode(token = "0" + token)) {
                        pa.setPostCode1(token);
                    }
                } else if (!AUSTRALIA_TOKENS.contains(token.trim()) && !SINGLE_TOKEN_STATES.contains(token.trim())) {
                    pa.setAreaName3(token.trim());
                }
            } else {
                this.parseLastlineTokens(pa, listOfTokens);
            }
        }
        if (pa.getPostCode1() == null) {
            pa.setPostCode1(postcode);
        }
        if (town != null) {
            pa.setAreaName3(town.trim());
        }
        if (state != null) {
            pa.setAreaName1(this.abbrState(state.trim()));
        } else if (ura.getPostAddress() != null && AUS_ParsePostAddressRule.isState(ura.getPostAddress().trim().toUpperCase())) {
            pa.getAdditionalFields().put(POSSIBLE_PIA_SL_STATE, this.abbrState(ura.getPostAddress().trim().toUpperCase()));
        }
        pa.setPostAddress(null);
    }

    protected void parseLastlineTokens(Address pa, LinkedList listOfTokens) {
        boolean bFoundFullState = false;
        LinkedList<String> townTokens = new LinkedList<String>();
        for (int i = listOfTokens.size() - 1; i >= 0; --i) {
            String token = (String)listOfTokens.get(i);
            if (this.isPostalCode(token)) {
                pa.setPostCode1(token);
                continue;
            }
            if (!bFoundFullState && SINGLE_TOKEN_STATES.contains(token)) {
                pa.setAreaName1(token);
                bFoundFullState = true;
                continue;
            }
            if (!bFoundFullState && AUSTRALIA_TOKENS.contains(token) && i > 0) {
                String test = (String)listOfTokens.get(i - 1);
                if (!AUSTRALIA_STATE_FIRSTWORD_TOKENS.contains(test)) continue;
                bFoundFullState = true;
                --i;
                if (test.charAt(0) == 'W') {
                    pa.setAreaName1("WA");
                    continue;
                }
                pa.setAreaName1("SA");
                continue;
            }
            if (!bFoundFullState && StringUtilities.equalStrings((String)WALES, (String)token) && i > 1) {
                String testSouth = (String)listOfTokens.get(i - 1);
                String testNew = (String)listOfTokens.get(i - 2);
                if ("NEW".equals(testNew) && ("SOUTH".equals(testSouth) || "S".equals(testSouth))) {
                    pa.setAreaName1("NSW");
                    bFoundFullState = true;
                    i -= 2;
                    continue;
                }
                townTokens.add(token);
                continue;
            }
            if (!bFoundFullState && i > 0 && (StringUtilities.equalStrings((String)TERRITORY, (String)token) || StringUtilities.equalStrings((String)TERRITORY_ABBR, (String)token))) {
                String testTerritory = (String)listOfTokens.get(i - 1);
                if ("NORTHERN".equals(testTerritory)) {
                    pa.setAreaName1("NT");
                    bFoundFullState = true;
                    --i;
                    continue;
                }
                if ("CAPITAL".equals(testTerritory) && i > 1) {
                    String testAustralian = (String)listOfTokens.get(i - 2);
                    if ("AUSTRALIAN".equals(testAustralian) || AUSTRALIA_TOKENS.contains(testAustralian)) {
                        pa.setAreaName1("ACT");
                        bFoundFullState = true;
                        i -= 2;
                        continue;
                    }
                    townTokens.add(token);
                    continue;
                }
                townTokens.add(token);
                continue;
            }
            townTokens.add(token);
        }
        StringBuilder townBuf = new StringBuilder();
        for (int i = townTokens.size() - 1; i >= 0; --i) {
            townBuf.append((String)townTokens.get(i));
            if (i == 0) continue;
            townBuf.append(' ');
        }
        pa.setAreaName3(townBuf.toString());
    }

    public static boolean isState(String state) {
        for (int i = 0; i < states.length; ++i) {
            if (!state.equalsIgnoreCase(states[i])) continue;
            return true;
        }
        return false;
    }

    private String abbrState(String state) {
        if (state.trim().length() > 3) {
            if (state.startsWith("QUE")) {
                return "QLD";
            }
            if (state.startsWith("NEW")) {
                return "NSW";
            }
            if (state.startsWith("VIC")) {
                return "VIC";
            }
            if (state.startsWith("SOU")) {
                return "SA";
            }
            if (state.startsWith("TAS")) {
                return "TAS";
            }
            if (state.startsWith("NOR")) {
                return "NT";
            }
            if (state.startsWith("WES")) {
                return "WA";
            }
            if (state.startsWith("AUS")) {
                return "ACT";
            }
        }
        return state;
    }

    private boolean isPostalCode(String pc) {
        if (pc == null || pc.length() == 0) {
            return false;
        }
        if (!StringUtilities.isNumeric((String)pc)) {
            return false;
        }
        return pc.length() == 4;
    }

    private String standardizePostalCode(String postalCode, IConstraints constraints) {
        if (StringUtilities.isEmpty((String)postalCode)) {
            return null;
        }
        if ((postalCode = postalCode.trim()).length() == 4) {
            if (!StringUtilities.isNumeric((String)postalCode)) {
                return null;
            }
            return postalCode;
        }
        if (postalCode.length() == 3) {
            if (!StringUtilities.isNumeric((String)postalCode)) {
                return null;
            }
            StringBuffer buf = new StringBuffer(4);
            buf.append('0');
            buf.append(postalCode);
            return buf.toString();
        }
        if (postalCode.length() > 4) {
            int additionalCount = postalCode.length() - 4;
            for (int index = 0; index < additionalCount; ++index) {
                if (postalCode.charAt(index) == '0') continue;
                return null;
            }
            String subStr = postalCode.substring(additionalCount, postalCode.length());
            if (StringUtilities.isNumeric((String)subStr)) {
                return subStr;
            }
        }
        return null;
    }

    public static boolean isValidTownName(String town) {
        return !StringUtilities.hasNumeric((String)town);
    }

    static {
        WALES = "WALES";
        TERRITORY = "TERRITORY";
        TERRITORY_ABBR = "TERR";
        POSSIBLE_PIA_SL_STATE = "POSSIBLE_PIA_SL_STATE";
        HashSet<String> set = new HashSet<String>(3);
        set.add("AUSTRALIA");
        set.add("AUS");
        set.add("AU");
        AUSTRALIA_TOKENS = Collections.unmodifiableSet(set);
        set = new HashSet(3);
        set.add("WESTERN");
        set.add("WEST");
        set.add("W");
        set.add("SOUTH");
        set.add("SO");
        set.add("S");
        AUSTRALIA_STATE_FIRSTWORD_TOKENS = Collections.unmodifiableSet(set);
        set = new HashSet(3);
        set.add("QLD");
        set.add("QUEENSLAND");
        set.add("VICTORIA");
        set.add("ACT");
        set.add("WA");
        set.add("TAS");
        set.add("TASMANIA");
        set.add("SA");
        set.add("NT");
        set.add("VIC");
        set.add("NSW");
        set.add("OT");
        SINGLE_TOKEN_STATES = Collections.unmodifiableSet(set);
    }
}

