/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.parser;

import com.mapinfo.mapmarker.AUS.parser.AUS_UnitType;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class AUS_UnitTypes {
    public static final int MAX_TOKENS_FOR_UNIT;
    private static final Map UNIT_TYPES;
    private static final Set UNIT_TYPE_TOKENS;

    private AUS_UnitTypes() {
    }

    public static AUS_UnitType getUnitType(String key) {
        if (StringUtilities.isEmpty((String)key)) {
            return null;
        }
        AUS_UnitType unitType = (AUS_UnitType)UNIT_TYPES.get(key);
        if (unitType == null && key.charAt(key.length() - 1) == '.') {
            unitType = (AUS_UnitType)UNIT_TYPES.get(key.substring(0, key.length() - 1));
        }
        return unitType;
    }

    public static boolean isLevelType(String key) {
        AUS_UnitType unitType = AUS_UnitTypes.getUnitType(key);
        if (unitType == null) {
            return false;
        }
        return unitType.getSecondaryType() == AUS_UnitType.LEVEL;
    }

    public static boolean isBuildingType(String key) {
        AUS_UnitType unitType = AUS_UnitTypes.getUnitType(key);
        if (unitType == null) {
            return false;
        }
        return unitType.getSecondaryType() == AUS_UnitType.BUILDING;
    }

    public static boolean isUnitTypeToken(String token) {
        return token != null && UNIT_TYPE_TOKENS.contains(token);
    }

    public static String[] separateUnitTypeAndValue(String typeAndValue) {
        if (StringUtilities.isEmpty((String)typeAndValue) || typeAndValue.length() < 2) {
            return null;
        }
        if (!Character.isLetter(typeAndValue.charAt(0))) {
            return null;
        }
        int numericPos = -1;
        for (int index = 1; index < typeAndValue.length(); ++index) {
            if (!Character.isDigit(typeAndValue.charAt(index))) continue;
            numericPos = index;
            break;
        }
        if (numericPos == -1) {
            return null;
        }
        String unitTypePortion = typeAndValue.substring(0, numericPos);
        AUS_UnitType unitType = AUS_UnitTypes.getUnitType(unitTypePortion);
        if (unitType == null) {
            return null;
        }
        return new String[]{unitType.getAbbreviation(), typeAndValue.substring(numericPos)};
    }

    public static String findUnitTypeFromStart(String possibleUnitString) {
        if (StringUtilities.isEmpty((String)possibleUnitString)) {
            return null;
        }
        AUS_UnitType type = AUS_UnitTypes.getUnitType(possibleUnitString);
        if (type != null) {
            return possibleUnitString;
        }
        StringTokenizer st = new StringTokenizer(possibleUnitString);
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(st.nextToken());
            type = AUS_UnitTypes.getUnitType(sb.toString());
            if (type == null) continue;
            return sb.toString();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        try {
            Properties unitTypes = new Properties();
            unitTypes.load(AUS_UnitTypes.class.getResourceAsStream("AUS_UnitTypes.properties"));
            HashMap<String, AUS_UnitType> tempMap = new HashMap<String, AUS_UnitType>(50);
            HashSet<String> tempSet = new HashSet<String>(15);
            int maxTokensFromUnit = 0;
            Enumeration<?> e = unitTypes.propertyNames();
            while (e.hasMoreElements()) {
                AUS_UnitType.SecondaryType secondaryType;
                String key = (String)e.nextElement();
                String val = unitTypes.getProperty(key);
                key = key.toUpperCase();
                StringTokenizer tokens = new StringTokenizer(val, ",");
                String abbr = tokens.nextToken().trim();
                String mustFollowByValue = tokens.nextToken().trim();
                if (tokens.hasMoreTokens()) {
                    String secondaryUnitType = tokens.nextToken();
                    if ("B".equalsIgnoreCase(secondaryUnitType)) {
                        secondaryType = AUS_UnitType.BUILDING;
                    } else {
                        if (!"L".equalsIgnoreCase(secondaryUnitType)) throw new RuntimeException("Wrong secondary unit type, can only be B, L or empty.");
                        secondaryType = AUS_UnitType.LEVEL;
                    }
                } else {
                    secondaryType = AUS_UnitType.REGULAR;
                }
                if (key.indexOf(43) > -1) {
                    StringWithTokens keyTokens = new StringWithTokens(key, "+");
                    maxTokensFromUnit = Math.max(maxTokensFromUnit, keyTokens.size());
                    key = keyTokens.toStringWithSep(' ');
                    StringWithTokens.TokenIterator iter = keyTokens.iterator();
                    while (iter.hasNext()) {
                        tempSet.add(iter.next());
                    }
                }
                AUS_UnitType unitType = new AUS_UnitType(key, abbr, Boolean.valueOf(mustFollowByValue), secondaryType);
                tempMap.put(key, unitType);
            }
            MAX_TOKENS_FOR_UNIT = maxTokensFromUnit;
            UNIT_TYPES = Collections.unmodifiableMap(tempMap);
            UNIT_TYPE_TOKENS = Collections.unmodifiableSet(tempSet);
            return;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to load required files for AUS_UnitTypes.", e);
        }
    }
}

