/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.SingleLineUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;

public class AUS_AvoidNumericTokenInMiddleOfStreetNameRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasPlace1 = this.hasPossiblePlace(o1);
        boolean hasPlace2 = this.hasPossiblePlace(o2);
        if (hasPlace1 && hasPlace2) {
            if (o1.getSplit().isFromReverseSplit() && !o2.getSplit().isFromReverseSplit()) {
                return 1;
            }
            if (!o1.getSplit().isFromReverseSplit() && o2.getSplit().isFromReverseSplit()) {
                return -1;
            }
        } else {
            if (hasPlace1 && !hasPlace2) {
                return -1;
            }
            if (hasPlace2 && !hasPlace1) {
                return 1;
            }
        }
        return 0;
    }

    private boolean hasPossiblePlace(IAddressParsing parsing) {
        Address parse1 = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        String place = (String)parse1.getAdditionalFields().get("POSSIBLE_PLACE_NAME");
        return !StringUtilities.isEmpty((String)place) && parsing.getSplit().getAddress().getMainAddress().startsWith(place);
    }
}

