/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.singleline;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.SingleLineUtils;
import com.mapinfo.mapmarker.utils.EnglishVerbalNumber;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Comparator;

public class AUS_AvoidNumericsInCityRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasNumerics1 = this.hasNumericsInCity(o1);
        boolean hasNumerics2 = this.hasNumericsInCity(o2);
        if (hasNumerics1 && !hasNumerics2) {
            return 1;
        }
        if (!hasNumerics1 && hasNumerics2) {
            return -1;
        }
        return 0;
    }

    private boolean hasNumericsInCity(IAddressParsing parsing) {
        Address parse1 = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        if (StringUtilities.hasNumeric((String)parse1.getAreaName3())) {
            return true;
        }
        StringWithTokens tokens = new StringWithTokens(parse1.getAreaName3());
        for (String token : tokens) {
            if (token.equals(EnglishVerbalNumber.convertVerbalToNumericStreetString((String)token))) continue;
            return true;
        }
        return false;
    }
}

