/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.singleline;

import com.mapinfo.mapmarker.AUS.parser.AUS_Directionals;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.SingleLineUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AUS_NoMiscWordEndingMainWhenPostTypePopulated
implements Comparator<IAddressParsing> {
    private static final List<String> commonStreetTypes;

    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasType1 = this.hasStreetTypeInMiddleOfMainAndPostTypeSet(o1);
        boolean hasType2 = this.hasStreetTypeInMiddleOfMainAndPostTypeSet(o2);
        if (hasType1 && !hasType2) {
            return 1;
        }
        if (!hasType1 && hasType2) {
            return -1;
        }
        return 0;
    }

    private boolean hasStreetTypeInMiddleOfMainAndPostTypeSet(IAddressParsing parsing) {
        Address parsed = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        if (StringUtilities.isEmpty((String)parsed.getPostThoroughfareType()) || StringUtilities.isEmpty((String)parsed.getMainAddress())) {
            return false;
        }
        String main = parsed.getMainAddress();
        StringWithTokens toks = new StringWithTokens(main);
        if (toks.size() < 2) {
            return false;
        }
        int i = 0;
        StringWithTokens.TokenIterator iterator = toks.iterator();
        while (iterator.hasNext()) {
            if (!commonStreetTypes.contains(iterator.next()) || !iterator.hasNext() || AUS_Directionals.isDirection(toks.getToken(++i))) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("STREET");
        temp.add("ROAD");
        temp.add("AVENUE");
        temp.add("RD");
        temp.add("AVE");
        temp.add("LANE");
        temp.add("ESPLANADE");
        temp.add("DRIVE");
        temp.add("CIRCUIT");
        temp.add("PLACE");
        temp.add("WALK");
        temp.add("COURT");
        temp.add("VIEW");
        temp.add("BOULEVARD");
        temp.add("BLVD");
        temp.add("HWY");
        temp.add("BAY");
        commonStreetTypes = Collections.unmodifiableList(temp);
    }
}

