/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.singleline;

import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Comparator;

public class AUS_PreferPoBoxWithNumber
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean parse2HasPoBox;
        String lastLine1 = o1.getSplit().getAddress().getPostAddress();
        String lastLine2 = o2.getSplit().getAddress().getPostAddress();
        String main1 = o1.getSplit().getAddress().getMainAddress();
        String main2 = o2.getSplit().getAddress().getMainAddress();
        if (lastLine1 == null || lastLine2 == null || main1 == null || main2 == null) {
            return 0;
        }
        boolean parse1HasPoBox = o1.getParse()[0].getAdditionalFields().get(AddressImpl.KEY_POBOX) != null;
        boolean bl = parse2HasPoBox = o2.getParse()[0].getAdditionalFields().get(AddressImpl.KEY_POBOX) != null;
        if (!parse1HasPoBox || !parse2HasPoBox) {
            return 0;
        }
        boolean poBox1HasNumber = o1.getParse()[0].getAdditionalFields().get(AddressImpl.KEY_POBOX_NUMBER) != null;
        boolean poBox2HasNumber = o2.getParse()[0].getAdditionalFields().get(AddressImpl.KEY_POBOX_NUMBER) != null;
        StringWithTokens swt1 = new StringWithTokens(lastLine1);
        StringWithTokens swt2 = new StringWithTokens(lastLine2);
        if (swt1.size() < 2 || swt2.size() < 2) {
            return 0;
        }
        String lastLine1FirstToken = swt1.getFirstToken();
        String lastLine2FirstToken = swt2.getFirstToken();
        if (poBox1HasNumber && !poBox2HasNumber && !StringUtilities.isNumeric((String)lastLine1FirstToken) && StringUtilities.isNumeric((String)lastLine2FirstToken)) {
            return -1;
        }
        if (poBox2HasNumber && !poBox1HasNumber && !StringUtilities.isNumeric((String)lastLine2FirstToken) && StringUtilities.isNumeric((String)lastLine1FirstToken)) {
            return 1;
        }
        return 0;
    }
}

