/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.singleline;

import com.mapinfo.mapmarker.AUS.parser.AUS_ThoroughfareTypes;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.singleline.IAddressParsing;
import com.mapinfo.mapmarker.core.singleline.SingleLineUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Comparator;

public class AUS_PreferTypeInMainRule
implements Comparator<IAddressParsing> {
    @Override
    public int compare(IAddressParsing o1, IAddressParsing o2) {
        boolean hasType1 = this.hasStreetType(o1);
        boolean hasType2 = this.hasStreetType(o2);
        if (hasType1 && !hasType2) {
            return -1;
        }
        if (!hasType1 && hasType2) {
            return 1;
        }
        return 0;
    }

    private boolean hasStreetType(IAddressParsing parsing) {
        Address parse1 = SingleLineUtils.getFirstParsedAddress((IAddressParsing)parsing);
        if (!StringUtilities.isEmpty((String)parse1.getPreThoroughfareType())) {
            return true;
        }
        if (!StringUtilities.isEmpty((String)parse1.getPostThoroughfareType())) {
            return true;
        }
        return this.elementIsProperStreetType(parse1.getPreAddress());
    }

    private boolean elementIsProperStreetType(String element) {
        AUS_ThoroughfareTypes.KeyInfo info = AUS_ThoroughfareTypes.lookupType(element);
        if (info != null) {
            return element.equals(info.getProperTypeName());
        }
        return false;
    }
}

