/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.utils;

import com.mapinfo.mapmarker.AUS.AUS_GNAFInfoData;
import com.mapinfo.mapmarker.AUS.AUS_InternalCandidateAddress;
import com.mapinfo.mapmarker.AUS.AUS_Range;
import com.mapinfo.mapmarker.AUS.dp.binary.GNAFStreetInfo;
import com.mapinfo.mapmarker.AUS.parser.AUS_Directionals;
import com.mapinfo.mapmarker.AUS.parser.AUS_ThoroughfareTypes;
import com.mapinfo.mapmarker.AUS.parser.AUS_UnitType;
import com.mapinfo.mapmarker.AUS.parser.AUS_UnitTypes;
import com.mapinfo.mapmarker.AUS.utils.AUS_StringUtilities;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.utils.EN_StringUtilities;
import com.mapinfo.mapmarker.utils.EnglishVerbalNumber;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AUS_AddressUtils {
    private static final Map PREFIX_STANDARDS;
    private static final Map m_fullLevelNames;
    private static final int MAX_ABBR_FOR_STATE = 3;

    public static String getFormattedStreetAddress(Address addr, boolean bAppendGenericField, boolean bConvertNumericToVerbal, boolean bFollowGNAFAddressRules, boolean bUseTypeAbbrevs) {
        AUS_Range range;
        AUS_InternalCandidateAddress ausCand;
        StringBuffer str = new StringBuffer();
        String addressNumber = addr.getAddressNumber();
        if (!AUS_StringUtilities.isEmpty(addr.getUnitType())) {
            AUS_UnitType unitType = AUS_UnitTypes.getUnitType(addr.getUnitType());
            if (unitType == null) {
                str.append(addr.getUnitType().toUpperCase());
            } else {
                str.append(unitType.getUnitTypeDescription().toUpperCase());
            }
            str.append(" ");
        }
        if (!AUS_StringUtilities.isEmpty(addr.getUnitValue())) {
            if (AUS_StringUtilities.isEmpty(addr.getUnitType())) {
                AUS_AddressUtils.addLevelInfo(addr, str);
            }
            str.append(addr.getUnitValue());
            if (AUS_StringUtilities.isEmpty(addr.getUnitType())) {
                str.append("/");
                if (AUS_StringUtilities.isEmpty(addressNumber)) {
                    str.append(" ");
                }
            } else {
                str.append(" ");
                if (bAppendGenericField && !StringUtilities.isEmpty((String)addr.getGenericField4())) {
                    str.append(addr.getGenericField4());
                    str.append(" ");
                }
            }
        }
        if (!AUS_StringUtilities.isEmpty(addr.getUnitType()) || AUS_StringUtilities.isEmpty(addr.getUnitValue())) {
            AUS_AddressUtils.addLevelInfo(addr, str);
        }
        if (addressNumber == null && addr instanceof AUS_InternalCandidateAddress && (ausCand = (AUS_InternalCandidateAddress)addr).fromGNAFDictionary() && (addressNumber = AUS_AddressUtils.getFakeGNAFAddressNumber(ausCand)) == null && ausCand.hasMatchingRange() && (range = (AUS_Range)ausCand.getSegment().getRangeAt(ausCand.getMatchedRangeNumber(), ausCand.getSegmentSide())).isHouseFromLotNumber()) {
            ParsedNumber num = new ParsedNumber(range.getLotNumber());
            num.setAddressPrefix(range.getLotPrefix());
            num.setAddressSuffix(range.getLotSuffix());
            str.append("LOT ");
            str.append(num.getCombinedAddressNumber());
            str.append(' ');
        }
        if (addressNumber != null) {
            str.append(addressNumber);
            str.append(" ");
        }
        return AUS_AddressUtils.getFormattedStreetPortion(addr, str, bConvertNumericToVerbal, bFollowGNAFAddressRules, bUseTypeAbbrevs);
    }

    public static String getFormattedStreetAddress(Address addr, boolean bAppendGenericField, boolean bConvertNumericToVerbal) {
        return AUS_AddressUtils.getFormattedStreetAddress(addr, bAppendGenericField, bConvertNumericToVerbal, false, false);
    }

    public static String getFakeGNAFAddressNumber(AUS_InternalCandidateAddress candidate) {
        AUS_GNAFInfoData gnafData = candidate.getGNAFInfoData();
        Segment segment = candidate.getSegment();
        if (gnafData != null && segment != null && gnafData.getReliability() < 4 && gnafData.getRangeIndex() != -1) {
            List ranges = segment.getRanges(gnafData.getSegmentSide());
            AUS_Range range = (AUS_Range)((Object)ranges.get(gnafData.getRangeIndex()));
            if (range.isHouseFromLotNumber()) {
                return null;
            }
            return ((Range)ranges.get(gnafData.getRangeIndex())).getParsedFrom().getCombinedAddressNumber();
        }
        return null;
    }

    public static String getPlaceAndUnitForNonClosePlaceCandidate(AUS_InternalCandidateAddress candidate, CandidateAddress addr) {
        List ranges;
        AUS_GNAFInfoData gnafData = candidate.getGNAFInfoData();
        Segment segment = candidate.getSegment();
        if (gnafData != null && segment != null && gnafData.getRangeIndex() != -1 && (ranges = segment.getRanges(gnafData.getSegmentSide())) != null) {
            if (((Range)ranges.get(gnafData.getRangeIndex())).getPlaceName() != null) {
                return ((Range)ranges.get(gnafData.getRangeIndex())).getPlaceName();
            }
            int rgucnt = ((Range)ranges.get(gnafData.getRangeIndex())).getRangeUnitCount();
            RangeUnit Rgu = ((Range)ranges.get(gnafData.getRangeIndex())).getRangeUnitAt(0);
            if (Rgu != null) {
                StringBuffer buf = null;
                if (!StringUtilities.isEmpty((String)Rgu.getUnitType())) {
                    addr.setUnitType(Rgu.getUnitType());
                    buf = new StringBuffer(Rgu.getUnitType());
                }
                if (!StringUtilities.isEmpty((String)Rgu.getHighUnit())) {
                    if (buf != null) {
                        buf.append(' ');
                    } else {
                        buf = new StringBuffer();
                    }
                    addr.setUnitValue(Rgu.getHighUnit());
                    buf.append(Rgu.getHighUnit());
                    buf.append(' ');
                    buf.append(addr.getFormattedStreetAddress());
                    addr.setFormattedStreetAddress(buf.toString());
                }
                return Rgu.getPlaceName();
            }
        }
        return null;
    }

    private static void addLevelInfo(Address addr, StringBuffer str) {
        AUS_InternalCandidateAddress ausCand;
        if (addr instanceof AUS_InternalCandidateAddress && (ausCand = (AUS_InternalCandidateAddress)addr).fromGNAFDictionary() && (ausCand.getLevelNumber() != null || ausCand.getLevelType() != null)) {
            String type = ausCand.getLevelType();
            if (StringUtilities.isEmpty((String)type)) {
                type = "LEVEL";
            }
            str.append(type);
            if (ausCand.getLevelNumber() != null) {
                str.append(" ");
                str.append(ausCand.getLevelNumber());
            }
            str.append(" ");
        }
    }

    public static String getFormattedStreetPortion(Address addr, StringBuffer buf, boolean bConvertNumericToVerbal) {
        return AUS_AddressUtils.getFormattedStreetPortion(addr, buf, bConvertNumericToVerbal, false, false);
    }

    public static String getFormattedStreetPortion(Address addr, StringBuffer buf, boolean bConvertNumericToVerbal, boolean bFollowGNAFAddressRules, boolean bUseTypeAbbrevs) {
        StringBuffer formattedStreet;
        StringBuffer stringBuffer = formattedStreet = buf == null ? new StringBuffer(50) : buf;
        if (bFollowGNAFAddressRules) {
            formattedStreet.append(addr.getMainAddress());
            if (!StringUtilities.isEmpty((String)addr.getPostThoroughfareType())) {
                formattedStreet.append(' ');
                if (!bUseTypeAbbrevs) {
                    formattedStreet.append(addr.getPostThoroughfareType());
                } else {
                    formattedStreet.append(AUS_ThoroughfareTypes.lookupPreferredName(addr.getPostThoroughfareType()));
                }
            }
            if (!StringUtilities.isEmpty((String)addr.getGenericField2())) {
                formattedStreet.append(' ');
                formattedStreet.append(addr.getGenericField2());
            }
        } else {
            String properName;
            if (!StringUtilities.isEmpty((String)addr.getPreDirectional())) {
                formattedStreet.append(addr.getPreDirectional());
                formattedStreet.append(" ");
            }
            if (addr.getPreAddress() != null) {
                formattedStreet.append(addr.getPreAddress());
                formattedStreet.append(" ");
            }
            if (addr.getPreThoroughfareType() != null) {
                if (!bUseTypeAbbrevs) {
                    properName = AUS_ThoroughfareTypes.lookupProperName(addr.getPreThoroughfareType());
                    formattedStreet.append(properName);
                } else {
                    formattedStreet.append(addr.getPreThoroughfareType());
                }
                formattedStreet.append(" ");
            }
            if (addr.getMainAddress() != null) {
                String mainAddress = addr.getMainAddress();
                if (bConvertNumericToVerbal && (EN_StringUtilities.isOrdinal((String)mainAddress) || StringUtilities.isNumeric((String)mainAddress))) {
                    mainAddress = EnglishVerbalNumber.convertNumericStreetToVerbal((String)mainAddress);
                }
                formattedStreet.append(mainAddress);
                formattedStreet.append(" ");
                if (addr.getGenericField2() != null) {
                    formattedStreet.append(addr.getGenericField2());
                    formattedStreet.append(' ');
                }
            }
            if (addr.getPostAddress() != null) {
                formattedStreet.append(addr.getPostAddress());
                formattedStreet.append(" ");
            }
            if (addr.getPostThoroughfareType() != null) {
                if (!bUseTypeAbbrevs) {
                    properName = AUS_ThoroughfareTypes.lookupProperName(addr.getPostThoroughfareType());
                    formattedStreet.append(properName);
                } else {
                    formattedStreet.append(addr.getPostThoroughfareType());
                }
                formattedStreet.append(" ");
            }
            if (!StringUtilities.isEmpty((String)addr.getPostDirectional())) {
                formattedStreet.append(addr.getPostDirectional());
                formattedStreet.append(" ");
            }
        }
        return formattedStreet.toString().trim();
    }

    public static void cleanStreetItemsFromAddress(Address addr) {
        if (addr == null) {
            return;
        }
        addr.setPreDirectional(null);
        addr.setPreThoroughfareType(null);
        addr.setGenericField4(null);
        addr.setPreAddress(null);
        addr.setMainAddress(null);
        addr.setPostAddress(null);
        addr.setPostThoroughfareType(null);
        addr.setPostDirectional(null);
    }

    public static String getStandardPrefix(String prefix) {
        return (String)PREFIX_STANDARDS.get(prefix);
    }

    public static String getFullLevelName(String levelType) {
        String result = (String)m_fullLevelNames.get(levelType);
        return result == null ? levelType : result;
    }

    public static String buildGnafPIDString(String pid, String areaName1) {
        if (!StringUtilities.isEmpty((String)pid)) {
            StringBuilder buffer = null;
            buffer = new StringBuilder(15);
            buffer.append("GA");
            if (StringUtilities.isEmpty((String)areaName1)) {
                AUS_AddressUtils.appendUnderlines(buffer, 3);
            } else {
                buffer.append(areaName1);
                AUS_AddressUtils.appendUnderlines(buffer, 3 - areaName1.length());
            }
            buffer.append(pid);
            return buffer.toString();
        }
        return null;
    }

    private static void appendUnderlines(StringBuilder buf, int count) {
        for (int index = 0; index < count; ++index) {
            buf.append('_');
        }
    }

    public static String combineNonNullStrings(String prefix, String main, String suffix) {
        if (prefix == null && main == null && suffix == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (main != null) {
            sb.append(main);
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    public static OriginalCoordinatesStrings createOriginalCoordinatesStrings(LongPoint originalCoordinates) {
        StringBuffer longitude = new StringBuffer(String.valueOf(originalCoordinates.getX()));
        StringBuffer latitude = new StringBuffer(String.valueOf(originalCoordinates.getY()));
        if (longitude.charAt(0) == '1') {
            longitude.insert(3, '.');
        } else {
            longitude.insert(2, '.');
        }
        if (latitude.charAt(1) == '9') {
            latitude.insert(2, '.');
        } else {
            latitude.insert(3, '.');
        }
        return new OriginalCoordinatesStrings(longitude.toString(), latitude.toString());
    }

    public static Address reconstructAddress(Address address, GNAFStreetInfo info) {
        AddressImpl output = new AddressImpl();
        if (!StringUtilities.isEmpty((String)info.getStreetTypeAbbreviation())) {
            output.getAdditionalFields().put("STREET_TYPE_ABB", info.getStreetTypeAbbreviation());
        } else if (!(StringUtilities.isEmpty((String)address.getPostThoroughfareType()) || info.getStreetTypeAttached() || info.getTypeIsSuffix() || info.getPostDirectionalAttached())) {
            output.getAdditionalFields().put("STREET_TYPE_ABB", address.getPostThoroughfareType());
        }
        if (!StringUtilities.isEmpty((String)info.getOriginalMainAddress())) {
            output.setMainAddress(info.getOriginalMainAddress());
        } else if (info.getPostDirectionalAttached()) {
            StringBuilder builder = new StringBuilder(AUS_AddressUtils.buildStandardMainAddress(address));
            builder.append(' ');
            if (!StringUtilities.isEmpty((String)address.getPostThoroughfareType())) {
                builder.append(AUS_ThoroughfareTypes.lookupProperName(address.getPostThoroughfareType()));
                builder.append(' ');
            }
            builder.append(AUS_Directionals.getFullName(address.getPostDirectional()));
            output.setMainAddress(builder.toString());
        } else if (info.getStreetTypeAttached()) {
            StringBuilder builder = new StringBuilder(AUS_AddressUtils.buildStandardMainAddress(address));
            builder.append(' ');
            builder.append(AUS_ThoroughfareTypes.lookupProperName(address.getPostThoroughfareType()));
            output.setPostThoroughfareType(null);
            if (info.getGenericField2NotSuffix()) {
                builder.append(' ');
                builder.append(address.getGenericField2());
            }
            output.setMainAddress(builder.toString());
        } else {
            output.setMainAddress(AUS_AddressUtils.buildStandardMainAddress(address));
        }
        if (!StringUtilities.isEmpty((String)info.getStreetSuffix())) {
            output.setGenericField2(info.getStreetSuffix());
        } else if (!info.getPostDirectionalAttached() && !StringUtilities.isEmpty((String)address.getPostDirectional())) {
            output.setGenericField2(address.getPostDirectional());
            output.setPostDirectional(address.getPostDirectional());
        } else if (!info.getGenericField2NotSuffix()) {
            output.setGenericField2(address.getGenericField2());
        }
        if (info.getTypeIsSuffix()) {
            if (StringUtilities.isEmpty((String)info.getStreetSuffix())) {
                output.setGenericField2(address.getPostThoroughfareType());
            } else {
                output.setGenericField2(info.getStreetSuffix());
            }
            output.setPostThoroughfareType(null);
        } else if (!info.getStreetTypeAttached() && !StringUtilities.isEmpty((String)address.getPostThoroughfareType())) {
            if (!StringUtilities.isEmpty((String)info.getStreetType())) {
                output.setPostThoroughfareType(info.getStreetType());
            } else {
                output.setPostThoroughfareType(AUS_ThoroughfareTypes.lookupProperName(address.getPostThoroughfareType()));
            }
        }
        if (!StringUtilities.isEmpty((String)info.getStreetType()) && StringUtilities.isEmpty((String)address.getPostThoroughfareType())) {
            output.setPostThoroughfareType(info.getStreetType());
        }
        return output;
    }

    private static String buildStandardMainAddress(Address address) {
        StringBuilder builder = new StringBuilder();
        if (!StringUtilities.isEmpty((String)address.getPreDirectional())) {
            builder.append(address.getPreDirectional());
            builder.append(' ');
        }
        if (!StringUtilities.isEmpty((String)address.getPreAddress())) {
            builder.append(address.getPreAddress());
            builder.append(' ');
        }
        if (!StringUtilities.isEmpty((String)address.getPreThoroughfareType())) {
            builder.append(AUS_ThoroughfareTypes.lookupProperName(address.getPreThoroughfareType()));
            builder.append(' ');
        }
        builder.append(address.getMainAddress());
        return builder.toString();
    }

    public static void adjustCandidateStreetTypes(Address candidate, boolean bGNAF, boolean bReturnTypeAbbrevs) {
        if (!bGNAF && !bReturnTypeAbbrevs) {
            if (!StringUtilities.isEmpty((String)candidate.getPreThoroughfareType())) {
                candidate.setPreThoroughfareType(AUS_ThoroughfareTypes.lookupProperName(candidate.getPreThoroughfareType()));
            }
            if (!StringUtilities.isEmpty((String)candidate.getPostThoroughfareType())) {
                candidate.setPostThoroughfareType(AUS_ThoroughfareTypes.lookupProperName(candidate.getPostThoroughfareType()));
            }
        } else if (bGNAF && bReturnTypeAbbrevs) {
            if (!StringUtilities.isEmpty((String)candidate.getPreThoroughfareType())) {
                candidate.setPreThoroughfareType(AUS_ThoroughfareTypes.lookupPreferredName(candidate.getPreThoroughfareType()));
            }
            if (!StringUtilities.isEmpty((String)candidate.getPostThoroughfareType())) {
                candidate.setPostThoroughfareType(AUS_ThoroughfareTypes.lookupPreferredName(candidate.getPostThoroughfareType()));
            }
        }
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("B", "BASEMENT");
        map.put("FL", "FLOOR");
        map.put("G", "GROUND");
        map.put("L", "LEVEL");
        map.put("LB", "LOBBY");
        map.put("LG", "LOWER GROUND FLOOR");
        map.put("M", "MEZZANINE");
        map.put("P", "PARKING");
        map.put("PTHS", "PENTHOUSE");
        map.put("PDM", "PODIUM");
        map.put("PLF", "PLATFORM");
        map.put("RT", "ROOFTOP");
        map.put("SB", "SUB-BASEMENT");
        map.put("UG", "UPPER GROUND FLOOR");
        m_fullLevelNames = Collections.unmodifiableMap(map);
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("MOUNT", "MOUNT");
        temp.put("MT", "MOUNT");
        temp.put("MT.", "MOUNT");
        temp.put("THE", "THE");
        temp.put("SAINT", "SAINT");
        temp.put("ST", "SAINT");
        temp.put("ST.", "SAINT");
        PREFIX_STANDARDS = Collections.unmodifiableMap(temp);
    }

    public static class OriginalCoordinatesStrings {
        private final String m_longitude;
        private final String m_latitude;

        private OriginalCoordinatesStrings(String longitude, String latitude) {
            this.m_longitude = longitude;
            this.m_latitude = latitude;
        }

        public String getLongitude() {
            return this.m_longitude;
        }

        public String getLatitude() {
            return this.m_latitude;
        }
    }
}

