/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.utils;

import com.mapinfo.mapmarker.utils.EnglishVerbalNumber;
import java.util.regex.Pattern;

public abstract class AUS_StringUtilities {
    private static final Pattern[] standardizePatterns;
    private static String[] standardizeRegexes;
    private static String[] standardizeReplacements;
    private static final Pattern[] punctuationRemoverPatterns;
    private static String[] punctuationRemoverRegexes;
    private static String[] punctuationRemoverReplacements;

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String removeRepeatedString(String str, String removeStr) {
        if (AUS_StringUtilities.isEmpty(str) || removeStr == null || str.indexOf(removeStr) == -1) {
            return str;
        }
        while (str.indexOf(removeStr + removeStr) != -1) {
            str = str.replaceFirst(removeStr + removeStr, removeStr);
        }
        return str;
    }

    public static String removeIfFirst(String inputString, String removeStr) {
        if (inputString == null || removeStr == null) {
            return inputString;
        }
        if (inputString.startsWith(removeStr)) {
            return inputString.replaceFirst(removeStr, "");
        }
        return inputString;
    }

    public static String removeIfLast(String inputString, String removeStr) {
        if (inputString == null || removeStr == null) {
            return inputString;
        }
        if (inputString.endsWith(removeStr)) {
            return inputString.substring(0, inputString.length() - removeStr.length());
        }
        return inputString;
    }

    public static double extractDouble(String string) {
        if (AUS_StringUtilities.isEmpty(string)) {
            return -1.0;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (!Character.isDigit(ch)) continue;
            sb.append(ch);
        }
        try {
            return new Double(sb.toString());
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public static String standardize(String input, boolean removePunctuationOnly) {
        if (input == null) {
            return input;
        }
        input = removePunctuationOnly ? AUS_StringUtilities.replace(input, punctuationRemoverPatterns, punctuationRemoverReplacements) : AUS_StringUtilities.replace(input, standardizePatterns, standardizeReplacements);
        return input.trim().toUpperCase();
    }

    public static boolean isNumber(String str) {
        return str != null && (str.equals("0") || EnglishVerbalNumber.convertString((String)str.toUpperCase()) != 0);
    }

    private static Pattern[] preCompile(String[] regexes) {
        Pattern[] patterns = new Pattern[regexes.length];
        for (int i = 0; i < regexes.length; ++i) {
            patterns[i] = Pattern.compile(regexes[i]);
        }
        return patterns;
    }

    private static String replace(String input, Pattern[] patterns, String[] replacements) {
        if (input == null || input.length() == 0) {
            return input;
        }
        for (int i = 0; i < patterns.length; ++i) {
            input = patterns[i].matcher(input).replaceAll(replacements[i]);
        }
        return input;
    }

    static {
        standardizeRegexes = new String[]{"\\s+", "(\\W|_)\\1+", " & ", "\\\\", "([^a-zA-Z0-9,/&'\\-\\s\\(\\)\\.\\+])", "\\s+", "(\\W|_)\\1+", "^\\s*([^a-zA-Z0-9\\(])", "([^a-zA-Z0-9\\)])\\s*$"};
        standardizeReplacements = new String[]{" ", "$1", " AND ", "/", " ", " ", "$1", "", ""};
        punctuationRemoverRegexes = new String[]{"((^|\\b|_)(\\W|_)+)"};
        punctuationRemoverReplacements = new String[]{" "};
        standardizePatterns = AUS_StringUtilities.preCompile(standardizeRegexes);
        punctuationRemoverPatterns = AUS_StringUtilities.preCompile(punctuationRemoverRegexes);
    }
}

