/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.AUS.utils;

public enum GNAFAddressClass {
    ADDRESS_CLASS_A("A"),
    ADDRESS_CLASS_P("P"),
    ADDRESS_CLASS_PP("PP"),
    ADDRESS_CLASS_PS("PS"),
    ADDRESS_CLASS_AP("AP"),
    ADDRESS_CLASS_AS("AS");

    private final String m_addressClass;

    private GNAFAddressClass(String addressClass) {
        this.m_addressClass = addressClass;
    }

    public String getAddressClass() {
        return this.m_addressClass;
    }

    public static GNAFAddressClass getGNAFAddressClass(String addressClass) {
        if ("A".equals(addressClass)) {
            return ADDRESS_CLASS_A;
        }
        if ("P".equals(addressClass)) {
            return ADDRESS_CLASS_P;
        }
        if ("PP".equals(addressClass)) {
            return ADDRESS_CLASS_PP;
        }
        if ("PS".equals(addressClass)) {
            return ADDRESS_CLASS_PS;
        }
        if ("AP".equals(addressClass)) {
            return ADDRESS_CLASS_AP;
        }
        if ("AS".equals(addressClass)) {
            return ADDRESS_CLASS_AS;
        }
        throw new IllegalArgumentException(addressClass + " is not a valid addressClass value");
    }
}

