/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_ParsedAddress;
import com.mapinfo.mapmarker.CAN.CAN_RuralRouteIdentifier;
import com.mapinfo.mapmarker.CAN.parser.CAN_Abbreviations;
import com.mapinfo.mapmarker.CAN.parser.CAN_UnitTypes;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.parser.CoreParser;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.IntObjMap;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class AddressUtils {
    public static final String CAN_REAL_MAIN_ADDRESS = "CAN_REAL_MAIN_ADDRESS";
    private static final String[] SAINTS = new String[]{"SAINT", "SAINTS", "ST", "STS", "SAINTE", "SAINTES", "STE", "STES"};
    private static final Set SAINTS_LOOKUP_TABLE;
    private static final IntObjMap m_provinceCodes;
    private static final Pattern MT_PATTERN;
    private static final String MT_REPLACE = "MOUNT ";

    public static boolean isSaintVariation(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        String locstr = str.toUpperCase();
        if (locstr.charAt(0) != 'S' || locstr.length() > 7) {
            return false;
        }
        return SAINTS_LOOKUP_TABLE.contains(locstr);
    }

    public static boolean isValidHouseNumber(String houseNumber) {
        boolean bValid = true;
        if (houseNumber == null || houseNumber.length() == 0) {
            return false;
        }
        String abbr = CAN_Abbreviations.getAbbrFromValue(houseNumber);
        if (abbr != null && StringUtilities.isNumeric((String)abbr)) {
            return true;
        }
        if (!(Character.isLetterOrDigit(houseNumber.charAt(0)) || '#' == houseNumber.charAt(0) && houseNumber.contains("-"))) {
            bValid = false;
        } else if (!StringUtilities.hasNumeric((String)houseNumber)) {
            bValid = false;
        } else if (houseNumber.length() > 2 && (houseNumber.indexOf("TH") > 0 || houseNumber.indexOf("3RD") > -1 || houseNumber.indexOf("2ND") > -1) || houseNumber.indexOf("1ST") > -1) {
            bValid = false;
        } else {
            ParsedNumber test = new ParsedNumber(houseNumber);
            if (!test.isPureNumeric() && test.hasAddressSuffix() && test.getAddressSuffix().length() > 2) {
                bValid = false;
            }
        }
        return bValid;
    }

    public static Address cleanseAddress(Address pa) {
        if (pa == null) {
            return null;
        }
        String mainAddr = pa.getMainAddress();
        if (mainAddr == null) {
            return null;
        }
        if (mainAddr.indexOf("'") < 0) {
            return null;
        }
        StringWithTokens tokens = new StringWithTokens(mainAddr, "-, ");
        StringBuffer buff = new StringBuffer(mainAddr.length());
        StringWithTokens.TokenIterator iter = tokens.iterator();
        boolean bFoundValidApostrophe = false;
        while (iter.hasNext()) {
            int apoLocation;
            String token = iter.next();
            boolean bAppendWholeToken = true;
            if (token.length() > 0 && (apoLocation = token.indexOf("'")) > 0) {
                int numOfLeadingChars = apoLocation;
                int restOfChars = token.length() - numOfLeadingChars - 1;
                if (numOfLeadingChars < 3 && numOfLeadingChars <= restOfChars) {
                    bFoundValidApostrophe = true;
                    bAppendWholeToken = false;
                    buff.append(token.substring(apoLocation + 1));
                    buff.append(" ");
                }
            }
            if (!bAppendWholeToken) continue;
            buff.append(token);
            buff.append(" ");
        }
        if (!bFoundValidApostrophe) {
            return null;
        }
        CAN_ParsedAddress newAddr = pa instanceof CAN_ParsedAddress ? new CAN_ParsedAddress(pa) : new AddressImpl(pa);
        newAddr.setMainAddress(buff.toString());
        HashMap fields = newAddr.getAdditionalFields();
        fields.put(CAN_REAL_MAIN_ADDRESS, pa.getMainAddress());
        return newAddr;
    }

    public static void setGenericField4(Address spa, String infoString, IConstraints constraints) throws ParserException {
        CAN_RuralRouteIdentifier.RRPositionInfo rrPosInfo;
        StringWithTokens info = new StringWithTokens(infoString);
        StringWithTokens wantedInfo = new StringWithTokens("");
        int rrPos = -1;
        int unitPos = -1;
        int boxPos = -1;
        if (info.size() > 1 && (rrPos = (rrPosInfo = CAN_RuralRouteIdentifier.findRuralRouteInString(info)).getPosition()) != -1) {
            if (rrPosInfo.getTokensCount() == 3) {
                info.remove(rrPos + 1);
            }
            wantedInfo.insert(0, info.remove(rrPos + 1));
            wantedInfo.insert(0, info.remove(rrPos));
        }
        if ((spa.getUnitType() == null && spa.getUnitValue() == null || spa.getGenericField4() != null) && info.size() > 1 && (unitPos = AddressUtils.findUnitInString(info, constraints)) != -1) {
            String item2 = info.remove(unitPos + 1);
            String item1 = info.remove(unitPos);
            if (!StringUtilities.isEmpty((String)spa.getUnitType())) {
                wantedInfo.insert(0, spa.getUnitValue());
                wantedInfo.insert(0, spa.getUnitType());
            }
            if (CAN_UnitTypes.getUnitType(item1) == null) {
                spa.setUnitType(item2);
                spa.setUnitValue(item1);
            } else {
                spa.setUnitType(item1);
                spa.setUnitValue(item2);
            }
        }
        spa.setGenericField4(wantedInfo.toStringWithSep(' '));
    }

    public static int findUnitInString(StringWithTokens tokens, IConstraints constraints) throws ParserException {
        boolean bFoundUnit = false;
        int pos = 0;
        int typeIndex = -1;
        String unitType = null;
        String unitValue = null;
        CAN_ParsedAddress spa = new CAN_ParsedAddress(constraints.getHandler().getParsedAddress());
        spa.setMainAddress("MAIN ST " + tokens.toString());
        spa.setUnitType(null);
        spa.setUnitValue(null);
        spa = AddressUtils.reparseMainAddress((Address)spa, constraints);
        unitType = spa.getUnitType();
        unitValue = spa.getUnitValue();
        if (unitType == null && unitValue == null && tokens.size() > 1) {
            if (CAN_UnitTypes.getUnitType(tokens.getFirstToken()) != null) {
                typeIndex = 0;
                ParsedNumber val = new ParsedNumber(tokens.getToken(typeIndex + 1));
                if (!val.isEmpty()) {
                    unitType = CAN_UnitTypes.getUnitType(tokens.getToken(typeIndex)).getAbbreviation();
                    unitValue = val.getCombinedAddressNumber();
                }
            } else if (CAN_UnitTypes.getUnitType(tokens.getToken(1)) != null) {
                ParsedNumber val;
                typeIndex = 1;
                String valStr = tokens.getToken(typeIndex - 1);
                String abbrValStr = CAN_Abbreviations.getAbbrFromValue(valStr);
                if (abbrValStr != null) {
                    valStr = abbrValStr;
                }
                if (!(val = new ParsedNumber(valStr = AddressUtils.stripOrdinals(valStr))).isEmpty()) {
                    unitType = CAN_UnitTypes.getUnitType(tokens.getToken(typeIndex)).getAbbreviation();
                    unitValue = val.getCombinedAddressNumber();
                }
            }
        } else if (unitType != null && unitValue != null) {
            typeIndex = 0;
        }
        if (unitType != null && unitValue != null) {
            for (String tok : tokens) {
                if (unitValue.equalsIgnoreCase(tok = AddressUtils.stripOrdinals(tok)) || unitValue.equalsIgnoreCase(CAN_Abbreviations.getExpandedName(tok)) || unitValue.equalsIgnoreCase(CAN_Abbreviations.getAbbrFromValue(tok))) {
                    bFoundUnit = true;
                    tokens.remove(pos);
                    tokens.insert(pos, unitValue);
                    if (typeIndex == 0 && pos != 0) {
                        tokens.remove(--pos);
                        tokens.insert(pos, unitType);
                        break;
                    }
                    ParsedNumber tmp = new ParsedNumber(unitValue);
                    if (tmp.isPureNumeric()) {
                        tokens.remove(pos);
                        tokens.insert(pos, unitType);
                        tokens.remove(pos + 1);
                        tokens.insert(pos + 1, unitValue);
                        break;
                    }
                    tokens.remove(pos + 1);
                    tokens.insert(pos + 1, unitType);
                    break;
                }
                ++pos;
            }
        }
        if (bFoundUnit) {
            return pos;
        }
        return -1;
    }

    public static Address reparseMainAddress(Address spa, IConstraints constraints) throws ParserException {
        IHandler handler = constraints.getHandler();
        CoreParser coreParser = (CoreParser)((CoreHandler)handler).getParser();
        int originalRuleFlag = coreParser.getRuleFlag();
        coreParser.setRuleFlag(1);
        Address newParsedAddr = coreParser.parse(spa, constraints)[0];
        coreParser.setRuleFlag(originalRuleFlag);
        return newParsedAddr;
    }

    public static String stripOrdinals(String token) {
        if (token.length() > 2 && (token.substring(token.length() - 2).equalsIgnoreCase("ST") || token.substring(token.length() - 2).equalsIgnoreCase("ND") || token.substring(token.length() - 2).equalsIgnoreCase("RD") || token.substring(token.length() - 2).equalsIgnoreCase("TH"))) {
            token = token.length() == 3 ? String.valueOf(token.charAt(0)) : token.substring(0, token.length() - 2);
        }
        return token;
    }

    public static String getProvinceForCode(int code) {
        return (String)m_provinceCodes.get(code);
    }

    public static String replaceMTWithMOUNT(String str) {
        if (str != null) {
            return MT_PATTERN.matcher(str).replaceAll(MT_REPLACE);
        }
        return str;
    }

    public static String stripEndQuotes(String str) {
        if (str == null || str.length() == 0 || str.trim().length() == 0) {
            return str;
        }
        if ('\"' == (str = str.trim()).charAt(0)) {
            str = str.substring(1);
        }
        if ('\"' == str.charAt(str.length() - 1)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    static {
        HashSet<String> tempSet = new HashSet<String>(SAINTS.length);
        for (int index = 0; index < SAINTS.length; ++index) {
            tempSet.add(SAINTS[index]);
        }
        SAINTS_LOOKUP_TABLE = Collections.unmodifiableSet(tempSet);
        m_provinceCodes = new IntObjMap();
        m_provinceCodes.put(35, (Object)"ON");
        m_provinceCodes.put(24, (Object)"QC");
        m_provinceCodes.put(59, (Object)"BC");
        m_provinceCodes.put(48, (Object)"AB");
        m_provinceCodes.put(13, (Object)"NB");
        m_provinceCodes.put(12, (Object)"NS");
        m_provinceCodes.put(46, (Object)"MB");
        m_provinceCodes.put(47, (Object)"SK");
        m_provinceCodes.put(10, (Object)"NL");
        m_provinceCodes.put(11, (Object)"PE");
        m_provinceCodes.put(60, (Object)"YT");
        m_provinceCodes.put(61, (Object)"NT");
        m_provinceCodes.put(62, (Object)"NU");
        MT_PATTERN = Pattern.compile("^MT ");
    }
}

