/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_Handler;
import com.mapinfo.mapmarker.CAN.dp.binary.CAN_DataManager;
import com.mapinfo.mapmarker.CAN.licensing.CANLicenseFilter;
import com.mapinfo.mapmarker.CAN.singleline.CANSingleLineParser;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodableAddressFactory;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.core.CoreGeocoder;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.singleline.IGeocoderFactory;
import com.mapinfo.mapmarker.core.singleline.ISingleLineParser;
import com.mapinfo.mapmarker.core.singleline.SingleLineGeocoder;
import com.mapinfo.mapmarker.utils.MMJLog;

public class CANGeocodableAddressFactory
extends GeocodableAddressFactory {
    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        return SingleLineGeocoder.getGeocoder((IGeocoderFactory)new GeocoderFactory(), (ISingleLineParser)new CANSingleLineParser(), (Address)address, (IGeocodeConstraints)constraints);
    }

    protected String[] getLicenseInformation() {
        try {
            CANLicenseFilter lf = new CANLicenseFilter();
            return lf.getLicenseInformation();
        }
        catch (MapMarkerInternalException e) {
            MMJLog.getLog().debug("Error building license information list.", (Throwable)e);
            return new String[0];
        }
    }

    protected void resetSpecificDataManager() throws MMInternalFatalException {
        try {
            CAN_DataManager.reset();
        }
        catch (MMJEDataManagerInitializationException MMJEDMIEx) {
            throw new FatalDataAccessException(2306, (Throwable)MMJEDMIEx);
        }
    }

    private static class GeocoderFactory
    implements IGeocoderFactory {
        private GeocoderFactory() {
        }

        public IGeocoder createGeocoder(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
            IHandler handler = CAN_Handler.buildHandler(address);
            return new CoreGeocoder(handler);
        }
    }
}

