/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CAN;

import com.mapinfo.mapmarker.CAN.CAN_IConstraints;
import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;

public class CAN_Constraints
extends Constraints
implements CAN_IConstraints,
IConstraints {
    public static final String KEY_MUST_MATCH_HOUSE_NUMBER = "KEY_MUST_MATCH_HOUSE_NUMBER";
    public static final String KEY_MUST_MATCH_STREET = "KEY_MUST_MATCH_STREET";
    public static final String KEY_MUST_MATCH_CITY = "KEY_MUST_MATCH_CITY";
    public static final String KEY_MUST_MATCH_PROVINCE = "KEY_MUST_MATCH_PROVINCE";
    public static final String KEY_MUST_MATCH_FSA = " KEY_MUST_MATCH_FSA";
    public static final String KEY_MUST_HAVE_LDU = "KEY_MUST_HAVE_LDU";
    public static final String KEY_POSTAL_SAC_ONLY = "KEY_POSTAL_SAC_ONLY";
    private static final String KEY_REMOVED_WORD = "KEY_REMOVED_WORD";
    private static final String KEY_STRICT_FIRST_PASS = "KEY_STRICT_FIRST_PASS";
    private boolean m_bPostaSacOnly;
    private boolean m_RemovedStartEndWordforRetry;
    private boolean m_mustHaveLDU;
    private int m_cityAdjustment;
    private boolean m_lookupPlaceBase;
    private boolean m_strictFirstPass;
    private boolean m_bRequirePreDirectionalToMatch;

    public CAN_Constraints() {
    }

    public CAN_Constraints(IGeocodeConstraints defaults) {
        super(defaults);
    }

    public void setDefaultValues() {
        this.setGeocodeType(0);
        this.setClientCoordinateSystem("epsg:4326");
        this.setClientLocale("en_CAN");
        this.setReturnCloseCandidatesOnly(false);
        this.setCornerOffset(7.0);
        this.setCornerOffsetUnits("m");
        this.setFallbackToGeographic(false);
        this.setFallbackToPostal(false);
        this.setMaxCandidates(1);
        this.setMaxRanges(0);
        this.setMaxRangeUnits(0);
        this.setMustMatchArea1(false);
        this.setMustMatchArea3(false);
        this.setMustMatchInput(false);
        this.setMustMatchCountry(true);
        this.setStreetOffset(7.0);
        this.setStreetOffsetUnits("m");
        this.setMustMatchAddressNumber(false);
        this.setMustMatchMainAddress(false);
        this.setMustMatchPostalCode(false);
        this.setDictionaryUsage(DictionaryUsagePreference.AD_ONLY);
        this.setUsePostalSacOnly(false);
        this.setStrictFirstPass(false);
    }

    public static CAN_IConstraints convertFromConstraints(IConstraints inConstraints) {
        CAN_Constraints newConstraints = new CAN_Constraints((IGeocodeConstraints)inConstraints);
        String tmp = newConstraints.getCustomString(KEY_POSTAL_SAC_ONLY);
        if (tmp != null) {
            newConstraints.setUsePostalSacOnly(tmp.equalsIgnoreCase("true"));
        }
        if ((tmp = newConstraints.getCustomString(KEY_REMOVED_WORD)) != null && tmp.equals("true")) {
            newConstraints.setRemovedStartEndWordforRetry(true);
        }
        newConstraints.setHandler(inConstraints.getHandler());
        tmp = newConstraints.getCustomString(KEY_MUST_HAVE_LDU);
        if (tmp != null) {
            newConstraints.setMustHaveLDU(tmp.equalsIgnoreCase("true"));
        }
        if ((tmp = newConstraints.getCustomString(KEY_STRICT_FIRST_PASS)) != null) {
            newConstraints.setStrictFirstPass(tmp.equalsIgnoreCase("true"));
        }
        if (inConstraints instanceof CAN_Constraints) {
            newConstraints.setRequirePreDirectionalToMatch(((CAN_Constraints)inConstraints).getRequirePreDirectionalToMatch());
        }
        return newConstraints;
    }

    @Override
    public void setUsePostalSacOnly(boolean flag) {
        this.m_bPostaSacOnly = flag;
    }

    @Override
    public boolean isUsePostalSacOnly() {
        return this.m_bPostaSacOnly;
    }

    @Override
    public boolean isRemovedStartEndWordforRetry() {
        return this.m_RemovedStartEndWordforRetry;
    }

    @Override
    public void setRemovedStartEndWordforRetry(boolean flag) {
        this.m_RemovedStartEndWordforRetry = flag;
        super.setCustomString(KEY_REMOVED_WORD, flag ? "true" : "false");
    }

    @Override
    public void setMustHaveLDU(boolean flag) {
        this.m_mustHaveLDU = flag;
    }

    @Override
    public boolean isMustHaveLDU() {
        return this.m_mustHaveLDU;
    }

    protected void setDefaultSettings(IGeocodeConstraints inConstraints) {
        inConstraints.setMustMatchAddressNumber(false);
        inConstraints.setMustMatchMainAddress(false);
        inConstraints.setMustMatchArea1(false);
        inConstraints.setMustMatchArea2(false);
        inConstraints.setMustMatchArea3(false);
        inConstraints.setMustMatchArea4(false);
        inConstraints.setMustMatchPostalCode(false);
        inConstraints.setMustMatchInput(false);
    }

    public void setCityAdjustment(int adjustment) {
        this.m_cityAdjustment = adjustment;
    }

    public int getCityAdjustment() {
        return this.m_cityAdjustment;
    }

    public void setLookupPlaceBase(boolean lookupPlaceBase) {
        this.m_lookupPlaceBase = lookupPlaceBase;
    }

    public boolean isLookupPlaceBase() {
        return this.m_lookupPlaceBase;
    }

    @Override
    public boolean isStrictFirstPass() {
        return this.m_strictFirstPass;
    }

    @Override
    public void setStrictFirstPass(boolean flag) {
        this.m_strictFirstPass = flag;
    }

    public void setRequirePreDirectionalToMatch(boolean flag) {
        this.m_bRequirePreDirectionalToMatch = flag;
    }

    @Override
    public boolean getRequirePreDirectionalToMatch() {
        return this.m_bRequirePreDirectionalToMatch;
    }
}

